/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.tydic.payment.bill.busi.bo.BillChinaBankPayTransCreateReqBo;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.payable.impl.AbstractChinaBankPayAble;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankBodyReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankHeadReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankRequestBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankResponseBo;
import com.tydic.payment.pay.util.PayAbleManager;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.payment.pay.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class PayBillAbleChinaBankImpl
implements PayBillAble {
    private static final Logger log = LoggerFactory.getLogger(PayBillAbleChinaBankImpl.class);
    private static final String STATE_CODE_SUCCESS = "OK";
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayAbleManager payAbleManager;

    public Long paymentIns() {
        return BillConstant.PaymentIns.CHINA_BANK_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        PayBillAbleDownloadRspBo retBo = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        AbstractChinaBankPayAble chinaBankPayAble = (AbstractChinaBankPayAble)this.payAbleManager.getPayAbleByPayMethod(180L);
        Map paraMap = reqBo.getParaMap();
        String validateStr = this.validateBillArgs(reqBo, chinaBankPayAble);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        Map<String, Object> formMap = this.assembleTicketData(reqBo, chinaBankPayAble);
        String ticketedPath = this.payPropertiesVo.getValueByKey("china.bank.ticket.url");
        log.debug("\u4e2d\u884c\u5546\u6237\u53d6\u7968\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)ticketedPath);
        if (StringUtils.isEmpty((Object)ticketedPath)) {
            log.error("\u4e2d\u884c\u5546\u6237\u53d6\u7968\u5730\u5740'china.bank.ticket.url'\u672a\u914d\u7f6e");
        }
        String retTicketStr = HttpUtil.post((String)ticketedPath, formMap);
        log.debug("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u63a5\u53e3\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)retTicketStr);
        ChinaBankResponseBo ticketRspBo = chinaBankPayAble.base64DeCode(retTicketStr);
        if (ticketRspBo == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u5bf9\u8d26\u53d6\u7968\u63a5\u53e3\uff0c\u8fd4\u56de\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25");
            return retBo;
        }
        if (!STATE_CODE_SUCCESS.equals(ticketRspBo.getHead().getResponseCode())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u5bf9\u8d26\u53d6\u7968\u63a5\u53e3\u5f02\u5e38\uff0c" + ticketRspBo.getHead().getResponseInfo());
            return retBo;
        }
        String downFileReqStr = this.assembleDownFileData(ticketRspBo.getBody().getTicketId(), ticketRspBo.getBody().getUri());
        String downFilePath = this.payPropertiesVo.getValueByKey("china.bank.down.file.url");
        log.debug("\u4e2d\u884c\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)downFilePath);
        if (StringUtils.isEmpty((Object)downFilePath)) {
            log.error("\u4e2d\u884c\u5546\u6237\u53d6\u7968\u5730\u5740'china.bank.down.file.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u5546\u6237\u53d6\u7968\u5730\u5740'china.bank.down.file.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        HttpResponse httpResponse = HttpRequest.post((String)downFilePath).form(downFileReqStr, new File[0]).execute();
        InputStream inputStream = httpResponse.bodyStream();
        File file = new File("E:\\" + new Date().toString() + ".text");
        File writeFile = FileUtil.writeFromStream((InputStream)inputStream, (File)file);
        ArrayList<String> dataList = new ArrayList<String>(16);
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(inputStream);
            while ((entry = zin.getNextEntry()) != null && !entry.isDirectory()) {
                if (entry.getName().lastIndexOf("error.txt") != -1) {
                    String errorMsg = IoUtil.read((InputStream)inputStream, (String)"UTF-8");
                    retBo.setRespCode("8888");
                    retBo.setRespDesc("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c" + errorMsg);
                    return retBo;
                }
                if (entry.getSize() <= 0L) continue;
                IoUtil.readLines((InputStream)inputStream, (String)"UTF-8", dataList);
            }
            zin.closeEntry();
            zin.close();
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u6d41\u5185\u5bb9\u6709\u8bef\uff0c{}", (Object)e.getMessage());
            throw new BillDownAndTransException("\u5904\u7406\u538b\u7f29\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        if (dataList.size() <= 1) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5bf9\u8d26\u4fe1\u606f\u4e3a\u7a7a");
            return retBo;
        }
        this.parseRspDataBos(dataList, retBo, (String)paraMap.get("accountNo"));
        return retBo;
    }

    private Map<String, Object> assembleTicketData(PayBillAbleDownloadReqBo reqBo, AbstractChinaBankPayAble chinaBankPayAble) {
        ChinaBankRequestBo ticketReqBo = new ChinaBankRequestBo();
        ChinaBankHeadReqBo ticketHeadReqBo = new ChinaBankHeadReqBo();
        DateTime nowTime = new DateTime(this.payMethodMapper.getDBDate().getDate());
        ticketHeadReqBo.setRequestTime(nowTime.toString("YYYYMMDDHHmmss"));
        ticketReqBo.setHead(ticketHeadReqBo);
        ChinaBankBodyReqBo ticketBodyReqBo = new ChinaBankBodyReqBo();
        ticketBodyReqBo.setHandleType("1");
        ticketBodyReqBo.setFileType("MCC");
        ticketBodyReqBo.setFileDate(String.valueOf(reqBo.getBillDate()));
        ticketBodyReqBo.setSubmitTime(nowTime.toString("YYYYMMDDHHmmss"));
        ticketBodyReqBo.setExtend("");
        ticketReqBo.setBody(ticketBodyReqBo);
        String messageId = "0000310";
        return chinaBankPayAble.assembleFormData(ticketReqBo, messageId);
    }

    private String assembleDownFileData(String ticketId, String uri) {
        ChinaBankRequestBo downFileReqBo = new ChinaBankRequestBo();
        downFileReqBo.setUri(uri);
        downFileReqBo.setTicketed(ticketId);
        String requestStr = null;
        try {
            requestStr = XmlUtils.objToXml(downFileReqBo);
        }
        catch (Exception e) {
            log.error("\u5bf9\u8d26\u6587\u4ef6\u4e0b\u8f7d\u5165\u53c2\u6709\u8bef\uff0c{}", (Object)e.getMessage());
        }
        return requestStr;
    }

    private void parseRspDataBos(List<String> dataList, PayBillAbleDownloadRspBo retBo, String amount) {
        for (int i = 1; i < dataList.size(); ++i) {
            if (dataList.get(i).indexOf(amount) != -1) continue;
            BillChinaBankPayTransCreateReqBo payTransBo = this.buildChinaBankTransBo(dataList.get(i));
            this.buildPayBillDownloadData(payTransBo, retBo);
        }
    }

    private BillChinaBankPayTransCreateReqBo buildChinaBankTransBo(String row) {
        int index = 0;
        String[] columns = row.trim().replaceAll("\\s+", "").split("|");
        BillChinaBankPayTransCreateReqBo payTransBo = new BillChinaBankPayTransCreateReqBo();
        payTransBo.setMerchantId(columns[index++]);
        payTransBo.setGatewayTradeId(columns[index++]);
        payTransBo.setCibpTradeId(columns[index++]);
        payTransBo.setTradeType(columns[index++]);
        payTransBo.setCurrency(columns[index++]);
        payTransBo.setAmount(columns[index++]);
        payTransBo.setPayerActNam(columns[index++]);
        payTransBo.setPayerActNum(columns[index++]);
        payTransBo.setPayerIbkOrg(columns[index++]);
        payTransBo.setPayerBnkOrg(columns[index++]);
        payTransBo.setPayeeActNam(columns[index++]);
        payTransBo.setPayeeActNum(columns[index++]);
        payTransBo.setPayeeIbkOrg(columns[index++]);
        payTransBo.setPayeeBnkOrg(columns[index++]);
        payTransBo.setPayeeBankEpsbtp(columns[index++]);
        payTransBo.setPayeeName(columns[index++]);
        payTransBo.setTradeState(columns[index++]);
        payTransBo.setSubmitTime(columns[index++]);
        payTransBo.setDealTime(columns[index]);
        String billDate = payTransBo.getDealTime();
        billDate = billDate.substring(0, 8);
        payTransBo.setBillDate(Long.valueOf(billDate));
        payTransBo.setBillCheckFlag("0");
        return payTransBo;
    }

    private void buildPayBillDownloadData(BillChinaBankPayTransCreateReqBo payTransBo, PayBillAbleDownloadRspBo retBo) {
        PayBillAbleDownloadRspDataBo trans = new PayBillAbleDownloadRspDataBo();
        trans.setBillDate(payTransBo.getBillDate());
        trans.setBillFlag("0");
        trans.setPaymentMchId(payTransBo.getMerchantId());
        trans.setTypeTransId(payTransBo.getGatewayTradeId());
        trans.setRealFee(Long.valueOf(Long.parseLong(payTransBo.getAmount())));
        trans.setPaymentInsId(BillConstant.PaymentIns.CHINA_BANK_PAY.getPaymentInsId());
        trans.setTradeTime(payTransBo.getSubmitTime().substring(0, 8));
        if ("1".equals(payTransBo.getTradeType()) || "2".equals(payTransBo.getTradeType())) {
            trans.setTypeOrderId(payTransBo.getGatewayTradeId());
            trans.setOrderType("01");
        } else {
            trans.setTypeOrderId(payTransBo.getGatewayTradeId());
            trans.setOrderType("02");
        }
        trans.setPaymentInsObj((Object)payTransBo);
        retBo.getRspDataBos().add(trans);
    }

    private String validateBillArgs(PayBillAbleDownloadReqBo reqBo, AbstractChinaBankPayAble chinaBankPayAble) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBillDate())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return chinaBankPayAble.validateParaMap(reqBo.getParaMap());
    }
}

