/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PayQryStayCloseTransAtomService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.impl.AbstractNewWopayPayAble;
import com.tydic.payment.pay.payable.impl.transbo.WoPayNewWqhReqBO;
import com.tydic.payment.pay.wopay.util.UniPaySignUtilsCer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WoPayNewWqhPayAbleImpl
extends AbstractNewWopayPayAble {
    private static final Logger log = LoggerFactory.getLogger(WoPayNewWqhPayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderMapper porderMapper;
    @Resource
    private FileClient fileClient;
    @Autowired
    private PayQryStayCloseTransAtomService payQryStayCloseTransAtomService;
    private static final String TRAN_TYPE = "20101";
    private static final String TRADE_MODE = "0001";
    private static final String INTERFACE_VERSION = "2.0.0.0";
    private static final String RESP_MODE = "1";
    private static final String SIGN_TYPE = "RSA_SHA256";
    private String formHead = "<form name=\"message_form\" method=\"post\" action=\"URL\">";
    private String inputItem = "<input type=\"hidden\" name=\"CODE\" value=\"VALUE\">";
    private String submit = "<input type=\"submit\" value=\"\u63d0\u4ea4\" style=\"display:none\">";
    private String script = "<script>document.forms[0].submit();</script>";

    public Long getPayMethod() {
        return PayProConstants.PayMethod.WOPAY_NEW_WQH.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        log.info("\u8fdb\u5165\u6c83\u4f01\u884c\u6536\u94f6\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        PayAbleDealPayRspBo rspBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return rspBo;
        }
        Map paraMap = reqBo.getParaMap();
        String merNo = (String)paraMap.get("merNo");
        String merPrivateKeyCert = (String)paraMap.get("merSignDir");
        String certPwd = (String)paraMap.get("merSignKey");
        if (StringUtils.isEmpty((Object)merNo)) {
            throw new BusinessException("8888", "\u5546\u6237\u53f7\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)merPrivateKeyCert)) {
            throw new BusinessException("8888", "\u79c1\u94a5\u8bc1\u4e66\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)certPwd)) {
            throw new BusinessException("8888", "\u8bc1\u4e66\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        String requestUrl = this.payPropertiesVo.getWopayNewPayUrl();
        if (StringUtils.isEmpty((Object)requestUrl)) {
            log.error("\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u8bf7\u6c42\u5730\u5740(wopay.new.web.pay.url)\u672a\u914d\u7f6e");
            throw new BusinessException("8888", "\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u6c83\u4f01\u884c\u6536\u94f6\u53f0\u8bf7\u6c42\u5730\u5740(wopay.new.web.pay.url)\u672a\u914d\u7f6e");
        }
        String notifyUrl = this.payPropertiesVo.getWoPayNewNotifyUrl();
        if (StringUtils.isEmpty((Object)notifyUrl)) {
            log.error("\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u56de\u8c03\u5730\u5740(wopay.new.notify.url)\u672a\u914d\u7f6e");
            throw new BusinessException("8888", "\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u56de\u8c03\u5730\u5740(wopay.new.notify.url)\u672a\u914d\u7f6e");
        }
        PorderPo porderPo = this.porderMapper.selectByOrderId(reqBo.getOrderId());
        WoPayNewWqhReqBO woPayNewWqhReqBO = new WoPayNewWqhReqBO();
        woPayNewWqhReqBO.setInterfaceVersion(INTERFACE_VERSION);
        woPayNewWqhReqBO.setTranType(TRAN_TYPE);
        woPayNewWqhReqBO.setMerNo(merNo);
        woPayNewWqhReqBO.setGoodsName(reqBo.getDetailName());
        woPayNewWqhReqBO.setOrderDate(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        woPayNewWqhReqBO.setOrderNo(reqBo.getPayOrderId());
        woPayNewWqhReqBO.setAmount(reqBo.getPayFee());
        woPayNewWqhReqBO.setCharSet("UTF-8");
        woPayNewWqhReqBO.setTradeMode(TRADE_MODE);
        woPayNewWqhReqBO.setReqTime(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        woPayNewWqhReqBO.setRespMode(RESP_MODE);
        woPayNewWqhReqBO.setCallbackUrl(reqBo.getRedirectUrl());
        woPayNewWqhReqBO.setServerCallUrl(notifyUrl);
        woPayNewWqhReqBO.setMerUserId(porderPo.getCreateOperId());
        woPayNewWqhReqBO.setSignType(SIGN_TYPE);
        Map sortMap = UniPaySignUtilsCer.obj2NormalMap((Object)woPayNewWqhReqBO);
        String sign = this.getSign(sortMap, merPrivateKeyCert, certPwd);
        woPayNewWqhReqBO.setSignMsg(sign);
        Map payParamMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)woPayNewWqhReqBO), Map.class);
        String html = this.buildHtml(payParamMap, requestUrl);
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        rspBo.setHtmlBody(html);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public String buildHtml(Map<String, Object> payParamMap, String requestUrl) {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append(this.formHead.replace("URL", requestUrl));
        for (Map.Entry<String, Object> entry : payParamMap.entrySet()) {
            String input = this.inputItem.replace("CODE", entry.getKey()).replace("VALUE", entry.getValue().toString());
            htmlBuilder.append(input);
        }
        htmlBuilder.append(this.submit);
        htmlBuilder.append("</form>");
        htmlBuilder.append(this.script);
        log.debug("\u6c83\u652f\u4ed8\u7ec4\u88c5\u597d\u7684HTML\u4e3a\uff1a{}", (Object)htmlBuilder);
        return htmlBuilder.toString();
    }
}

