/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.WithdrawCardBindRequest;
import java.util.Map;
import java.util.UUID;

public class WithdrawCardBindRequestMarshaller
implements RequestMarshaller<WithdrawCardBindRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/withdraw/card/bind";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<WithdrawCardBindRequest> marshall(WithdrawCardBindRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/withdraw/card/bind");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getBankCardType() != null) {
            internalRequest.addParameter("bankCardType", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCardType(), (String)"String"));
        }
        if (request.getAccountNo() != null) {
            internalRequest.addParameter("accountNo", PrimitiveMarshallerUtils.marshalling((Object)request.getAccountNo(), (String)"String"));
        }
        if (request.getBankCode() != null) {
            internalRequest.addParameter("bankCode", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCode(), (String)"String"));
        }
        if (request.getBranchCode() != null) {
            internalRequest.addParameter("branchCode", PrimitiveMarshallerUtils.marshalling((Object)request.getBranchCode(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static WithdrawCardBindRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static WithdrawCardBindRequestMarshaller INSTANCE = new WithdrawCardBindRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

