/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.cashier.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.cashier.request.PayLinkOrderRequest;
import java.util.Map;
import java.util.UUID;

public class PayLinkOrderRequestMarshaller
implements RequestMarshaller<PayLinkOrderRequest> {
    private final String serviceName = "Cashier";
    private final String resourcePath = "/rest/v1.0/cashier/pay-link/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<PayLinkOrderRequest> marshall(PayLinkOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Cashier");
        internalRequest.setResourcePath("/rest/v1.0/cashier/pay-link/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getAmount() != null) {
            internalRequest.addParameter("amount", PrimitiveMarshallerUtils.marshalling((Object)request.getAmount(), (String)"BigDecimal"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling((Object)request.getExpiredTime(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getScene() != null) {
            internalRequest.addParameter("scene", PrimitiveMarshallerUtils.marshalling((Object)request.getScene(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getAppId() != null) {
            internalRequest.addParameter("appId", PrimitiveMarshallerUtils.marshalling((Object)request.getAppId(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static PayLinkOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static PayLinkOrderRequestMarshaller INSTANCE = new PayLinkOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

