/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.mer.request.AuthStateQueryV2Request;
import java.util.Map;
import java.util.UUID;

public class AuthStateQueryV2RequestMarshaller
implements RequestMarshaller<AuthStateQueryV2Request> {
    private final String serviceName = "Mer";
    private final String resourcePath = "/rest/v2.0/mer/auth/state/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<AuthStateQueryV2Request> marshall(AuthStateQueryV2Request request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Mer");
        internalRequest.setResourcePath("/rest/v2.0/mer/auth/state/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getReportMerchantNo() != null) {
            internalRequest.addParameter("reportMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getReportMerchantNo(), (String)"String"));
        }
        if (request.getFeeType() != null) {
            internalRequest.addParameter("feeType", PrimitiveMarshallerUtils.marshalling((Object)request.getFeeType(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static AuthStateQueryV2RequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static AuthStateQueryV2RequestMarshaller INSTANCE = new AuthStateQueryV2RequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

