/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.netpay;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.netpay.NetpayClient;
import com.yeepay.yop.sdk.service.netpay.request.OrderRequest;
import com.yeepay.yop.sdk.service.netpay.request.OrderRequestMarshaller;
import com.yeepay.yop.sdk.service.netpay.response.OrderResponse;

public class NetpayClientImpl
implements NetpayClient {
    private final ClientHandler clientHandler;

    NetpayClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public OrderResponse order(OrderRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        OrderRequestMarshaller requestMarshaller = OrderRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(OrderResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (OrderResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

