/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.reprocess.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.reprocess.request.MigrateBankOrderRequest;
import java.util.Map;
import java.util.UUID;

public class MigrateBankOrderRequestMarshaller
implements RequestMarshaller<MigrateBankOrderRequest> {
    private final String serviceName = "Reprocess";
    private final String resourcePath = "/rest/v1.0/reprocess/migrate/bank/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<MigrateBankOrderRequest> marshall(MigrateBankOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Reprocess");
        internalRequest.setResourcePath("/rest/v1.0/reprocess/migrate/bank/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMigrateRequestId() != null) {
            internalRequest.addParameter("migrateRequestId", PrimitiveMarshallerUtils.marshalling((Object)request.getMigrateRequestId(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getUniqueOrderNo() != null) {
            internalRequest.addParameter("uniqueOrderNo", PrimitiveMarshallerUtils.marshalling((Object)request.getUniqueOrderNo(), (String)"String"));
        }
        if (request.getMigrateNotifyUrl() != null) {
            internalRequest.addParameter("migrateNotifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getMigrateNotifyUrl(), (String)"String"));
        }
        if (request.getMigrateAmount() != null) {
            internalRequest.addParameter("migrateAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getMigrateAmount(), (String)"String"));
        }
        if (request.getAccountLinkInfo() != null) {
            internalRequest.addParameter("accountLinkInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getAccountLinkInfo(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static MigrateBankOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static MigrateBankOrderRequestMarshaller INSTANCE = new MigrateBankOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

