/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.trade.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.trade.request.RefundSupplyRequest;
import java.util.Map;
import java.util.UUID;

public class RefundSupplyRequestMarshaller
implements RequestMarshaller<RefundSupplyRequest> {
    private final String serviceName = "Trade";
    private final String resourcePath = "/rest/v1.0/trade/refund/supply";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<RefundSupplyRequest> marshall(RefundSupplyRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Trade");
        internalRequest.setResourcePath("/rest/v1.0/trade/refund/supply");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getRefundRequestId() != null) {
            internalRequest.addParameter("refundRequestId", PrimitiveMarshallerUtils.marshalling((Object)request.getRefundRequestId(), (String)"String"));
        }
        if (request.getCardInfo() != null) {
            internalRequest.addParameter("cardInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getCardInfo(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static RefundSupplyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static RefundSupplyRequestMarshaller INSTANCE = new RefundSupplyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

