/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.bo.PayAbleBusiRspDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.impl.AbstractYeePayAble;
import com.yeepay.yop.sdk.inter.utils.RSA;
import com.yeepay.yop.sdk.inter.utils.RSAKeyUtils;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.service.trade.TradeClient;
import com.yeepay.yop.sdk.service.trade.TradeClientBuilder;
import com.yeepay.yop.sdk.service.trade.model.OrderYopCreateOrderV2ResDTOResult;
import com.yeepay.yop.sdk.service.trade.request.OrderRequest;
import com.yeepay.yop.sdk.service.trade.response.OrderResponse;
import com.yeepay.yop.sdk.utils.Encodes;
import java.security.PrivateKey;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class YeePayAbleImpl
extends AbstractYeePayAble {
    private static final Logger log = LoggerFactory.getLogger(YeePayAbleImpl.class);
    @Value(value="${yee.pay.app.key:123}")
    private String appKey;
    @Value(value="${yee.pay.private.key:123}")
    private String privateKey;
    @Value(value="${yee.pay.public.key:123}")
    private String publicKey;
    @Value(value="${yee.pay.notify.url:123}")
    private String notifyUrl;
    @Value(value="${yee.pay.cashier.url:https://cash.yeepay.com/cashier/std}")
    private String yeePayCashierUrl;
    @Value(value="${yee.pay.platform.merchantNo}")
    private String platformMerchantNo;
    private static final String SUCCESS = "OPR00000";
    private static final String MERCHANT_NO = "merchantNo";
    private static final TradeClient api = (TradeClient)TradeClientBuilder.builder().build();

    public Long getPayMethod() {
        return PayProConstants.PayMethod.YEE_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo rspBo = new PayAbleDealPayRspBo();
        String validateArgs = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgs)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(validateArgs);
            return rspBo;
        }
        Map paraMap = reqBo.getParaMap();
        String merchantNo = (String)paraMap.get(MERCHANT_NO);
        OrderRequest request = new OrderRequest();
        request.setParentMerchantNo(this.platformMerchantNo);
        request.setMerchantNo(merchantNo);
        request.setOrderId(reqBo.getPayOrderId());
        request.setOrderAmount(String.valueOf(Double.valueOf(reqBo.getPayFee().longValue()) / 100.0));
        request.setGoodsName(reqBo.getDetailName());
        request.setNotifyUrl(this.notifyUrl);
        request.setRedirectUrl(reqBo.getRedirectUrl());
        log.info("\u6613\u5b9d\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u4fe1\u606f request:{}", (Object)JSON.toJSONString((Object)request));
        OrderResponse response = null;
        try {
            response = api.order(request);
            log.info("\u6613\u5b9d\u652f\u4ed8\u4e0b\u5355\u8fd4\u56de\u62a5\u6587-->result:{}", (Object)response.getResult());
        }
        catch (Exception e) {
            log.error("\u6613\u5b9d\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("8888", "\u6613\u5b9d\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38");
        }
        OrderYopCreateOrderV2ResDTOResult result = response.getResult();
        if (!SUCCESS.equals(result.getCode())) {
            log.info("\u6613\u5b9d\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(result.getMessage());
            return rspBo;
        }
        String token = result.getToken();
        String url = this.getUrl(this.yeePayCashierUrl, reqBo, token);
        PayAbleBusiRspDataBo rspBusiDataBo = new PayAbleBusiRspDataBo();
        rspBusiDataBo.setYeePayUrl(url);
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        rspBo.setBusiRspDataBo(JSON.toJSONString((Object)rspBusiDataBo));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String getUrl(String address, PayAbleDealPayReqBo reqBo, String token) {
        Map paraMap = reqBo.getParaMap();
        String merchantNo = (String)paraMap.get(MERCHANT_NO);
        StringBuffer url = new StringBuffer();
        url.append(address);
        StringBuilder reqSb = new StringBuilder();
        reqSb.append("appKey=").append(this.appKey);
        reqSb.append("&merchantNo=").append(merchantNo);
        reqSb.append("&token=").append(token);
        reqSb.append("&timestamp=").append(System.currentTimeMillis() / 1000L);
        reqSb.append("&directPayType=");
        reqSb.append("&cardType=");
        reqSb.append("&userNo=");
        reqSb.append("&userType=");
        reqSb.append("&ext=");
        log.info("reqSb:{}", (Object)reqSb);
        String sign = this.getSign(reqSb.toString(), this.privateKey);
        url.append("?sign=").append(sign).append("&").append((CharSequence)reqSb);
        return url.toString();
    }

    private String getSign(String preSign, String pKey) {
        PrivateKey privateKey = RSAKeyUtils.string2PrivateKey((String)pKey);
        byte[] data = preSign.getBytes();
        byte[] sign = RSA.sign((byte[])data, (PrivateKey)privateKey, (DigestAlgEnum)DigestAlgEnum.SHA256);
        String signToBase64 = Encodes.encodeUrlSafeBase64((byte[])sign);
        return signToBase64 + "$" + "SHA256";
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

