/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.impl.AbstractYeePayAble;
import com.yeepay.yop.sdk.service.aggpay.AggpayClient;
import com.yeepay.yop.sdk.service.aggpay.AggpayClientBuilder;
import com.yeepay.yop.sdk.service.aggpay.model.PrePayOrderResponseDTOResult;
import com.yeepay.yop.sdk.service.aggpay.request.PrePayRequest;
import com.yeepay.yop.sdk.service.aggpay.response.PrePayResponse;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class YeePayWeChatCodeAbleImpl
extends AbstractYeePayAble {
    private static final Logger log = LoggerFactory.getLogger(YeePayWeChatCodeAbleImpl.class);
    @Value(value="${yee.pay.app.key:123}")
    private String appKey;
    @Value(value="${yee.pay.private.key:123}")
    private String privateKey;
    @Value(value="${yee.pay.public.key:123}")
    private String publicKey;
    @Value(value="${yee.pay.notify.url:123}")
    private String notifyUrl;
    @Value(value="${yee.pay.cashier.url:https://cash.yeepay.com/cashier/std}")
    private String yeePayCashierUrl;
    @Value(value="${yee.pay.platform.merchantNo}")
    private String platformMerchantNo;
    private static final AggpayClient api = (AggpayClient)AggpayClientBuilder.builder().build();
    private static final String SUCCESS = "00000";
    private static final String MERCHANT_NO = "merchantNo";

    public Long getPayMethod() {
        return PayProConstants.PayMethod.YEE_PAY_WECHAT_CODE.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo rspBo = new PayAbleDealPayRspBo();
        String validateArgs = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgs)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(validateArgs);
            return rspBo;
        }
        Map paraMap = reqBo.getParaMap();
        String merchantNo = (String)paraMap.get(MERCHANT_NO);
        PrePayRequest request = new PrePayRequest();
        request.setParentMerchantNo(this.platformMerchantNo);
        request.setMerchantNo(merchantNo);
        request.setOrderId(reqBo.getPayOrderId());
        Long payFee = reqBo.getPayFee();
        Double fee = payFee.doubleValue() / 100.0;
        request.setOrderAmount(new BigDecimal(fee.toString()));
        request.setNotifyUrl(this.notifyUrl);
        request.setRedirectUrl(reqBo.getRedirectUrl());
        request.setGoodsName(reqBo.getDetailName());
        request.setFundProcessType("REAL_TIME");
        request.setPayWay("USER_SCAN");
        request.setChannel("WECHAT");
        request.setScene("OFFLINE");
        request.setUserIp("113.248.155.169");
        PrePayResponse response = null;
        try {
            response = api.prePay(request);
            log.info("\u6613\u5b9d\u652f\u4ed8\u4e0b\u5355\u8fd4\u56de\u62a5\u6587-->result:{}", (Object)response.getResult());
        }
        catch (Exception e) {
            log.error("\u6613\u5b9d\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        PrePayOrderResponseDTOResult result = response.getResult();
        if (!ObjectUtils.isEmpty((Object)result) && SUCCESS.equals(result.getCode())) {
            BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
            rspBo.setQrCodeUrl(result.getPrePayTn());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        rspBo.setRespCode("8888");
        rspBo.setRespDesc("\u5931\u8d25");
        return rspBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

