/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.ability.bo.PayProMerchantInfoReqBo;
import com.tydic.payment.pay.ability.bo.PayProMerchantInfoRspBo;
import com.tydic.payment.pay.ability.bo.PayProRelMerchantBusiSysDataBo;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.busi.PayProDealMerchantInfoBusiService;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.constant.CodeTypeValueConstants;
import com.tydic.payment.pay.dao.BusiSystemMerchantRelMapper;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="payProDealMerchantInfoBusiService")
public class PayProDealMerchantInfoBusiServiceImpl
implements PayProDealMerchantInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(PayProDealMerchantInfoBusiServiceImpl.class);
    private static final int ADD = 1;
    private static final int UPDATE = 2;
    private static final int DEAL_STATUS = 3;
    private Long busiId;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private BusiSystemMerchantRelMapper busiSystemMerchantRelMapper;
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;

    public PayProMerchantInfoRspBo dealMerchant(PayProMerchantInfoReqBo reqBo) {
        PayProMerchantInfoRspBo retBo = new PayProMerchantInfoRspBo();
        Long merchantId = null;
        switch (reqBo.getDealType()) {
            case 1: {
                merchantId = this.addMerchantInfo(reqBo);
                break;
            }
            case 2: {
                this.updateMerchantInfo(reqBo);
                break;
            }
            case 3: {
                this.updateMerchant(reqBo, this.payMethodMapper.getDBDate().getDate());
                break;
            }
        }
        retBo.setMerchantId(merchantId);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Long addMerchantInfo(PayProMerchantInfoReqBo reqBo) {
        this.validateArgInfo(reqBo);
        Long merchantId = this.generateMerchantId(reqBo.getMerchantId());
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        MerChantInfoPo merchantInfoPo = this.getInfoByTemp(reqBo);
        merchantInfoPo.setMerchantId(merchantId);
        merchantInfoPo.setCreateTime(dbDate);
        int addMerchantRetValue = this.merChantInfoMapper.createMerChantInfo(merchantInfoPo);
        if (addMerchantRetValue < 1) {
            throw new BusinessException("216031", "\u65b0\u589e\u5546\u6237\u5f02\u5e38\uff0c\u8fd4\u56de\u503c\u4e0d\u4e3a1");
        }
        this.insertRelInfo(reqBo, merchantId, dbDate, null);
        return merchantId;
    }

    private void updateMerchantInfo(PayProMerchantInfoReqBo reqBo) {
        this.validateArgInfo(reqBo);
        MerChantInfoPo merChantInfoPo = new MerChantInfoPo();
        merChantInfoPo.setMerchantId(reqBo.getMerchantId());
        merChantInfoPo = this.merChantInfoMapper.queryMerChantInfoById(merChantInfoPo);
        if (null == merChantInfoPo) {
            throw new BusinessException("216031", "\u5546\u6237\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u5546\u6237[" + reqBo.getMerchantId() + "]\u4e0d\u5b58\u5728");
        }
        BusiSystemMerchantRelPo busiRelPo = new BusiSystemMerchantRelPo();
        busiRelPo.setMerchantId(reqBo.getMerchantId());
        int busiRelResult = this.busiSystemMerchantRelMapper.deleteBusiSystemMerchantRelByBusiReqWayMerchant(busiRelPo);
        if (busiRelResult < 1) {
            throw new BusinessException("216031", "\u5546\u6237\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u4e1a\u52a1\u7cfb\u7edf\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
        Date updateDate = this.payMethodMapper.getDBDate().getDate();
        this.updateMerchant(reqBo, updateDate);
        reqBo.setCreateOperId(merChantInfoPo.getCreateOperId());
        this.insertRelInfo(reqBo, reqBo.getMerchantId(), merChantInfoPo.getCreateTime(), updateDate);
    }

    private void updateMerchant(PayProMerchantInfoReqBo reqBo, Date updateDate) {
        int result;
        MerChantInfoPo infoPo = new MerChantInfoPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)infoPo);
        infoPo.setUpdateTime(updateDate);
        infoPo.setUpdateOperId(reqBo.getUpdateOperId());
        if (!StringUtils.isEmpty((Object)reqBo.getStatus())) {
            infoPo.setFlag(reqBo.getStatus());
        }
        if ((result = this.merChantInfoMapper.updateMerChantInfo(infoPo)) < 1) {
            throw new BusinessException("216031", "\u5546\u6237\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u5546\u6237\u4fe1\u606f\u5904\u7406\u5931\u8d25");
        }
    }

    private void insertRelInfo(PayProMerchantInfoReqBo reqBo, Long merchantId, Date dbDate, Date updateDate) {
        List relBusiSysList = reqBo.getRelBusiSysList();
        if (!CollectionUtils.isEmpty((Collection)relBusiSysList)) {
            ArrayList<BusiSystemMerchantRelPo> relPos = new ArrayList<BusiSystemMerchantRelPo>();
            for (PayProRelMerchantBusiSysDataBo tempBo : relBusiSysList) {
                BusiSystemMerchantRelPo relPo = new BusiSystemMerchantRelPo();
                BeanUtils.copyProperties((Object)tempBo, (Object)relPo);
                relPo.setBusiId(this.busiId);
                relPo.setCreateOperId(reqBo.getCreateOperId());
                relPo.setMerchantId(merchantId);
                relPo.setCreateTime(dbDate);
                if (2 == reqBo.getDealType()) {
                    relPo.setUpdateOperId(reqBo.getUpdateOperId());
                    relPo.setUpdateTime(updateDate);
                }
                relPos.add(relPo);
            }
            int result = this.busiSystemMerchantRelMapper.insertBatch(relPos);
            if (result < relBusiSysList.size()) {
                throw new BusinessException("216031", "\u64cd\u4f5c\u5546\u6237\u4fe1\u606f\u5f02\u5e38\uff0c\u5199\u5165\u5546\u6237-\u4e1a\u52a1\u7cfb\u7edf\u5173\u7cfb\u5931\u8d25");
            }
        }
    }

    private MerChantInfoPo getInfoByTemp(PayProMerchantInfoReqBo reqBo) {
        MerChantInfoPo merchantInfoBo = new MerChantInfoPo();
        if (StringUtils.isEmpty((Object)reqBo.getTempMerchantId())) {
            merchantInfoBo.setFlag(reqBo.getStatus());
            merchantInfoBo.setMerchantType(CodeTypeValueConstants.P_PRO_MERCHANT_TYPE_MAIN);
        } else {
            MerChantInfoPo qryMerchantPo = new MerChantInfoPo();
            qryMerchantPo.setMerchantId(reqBo.getTempMerchantId());
            MerChantInfoPo qryRetMerchantBo = this.merChantInfoMapper.queryMerChantInfoById(qryMerchantPo);
            if (qryRetMerchantBo == null) {
                throw new BusinessException("218001", "\u6a21\u677f\u5546\u6237(" + reqBo.getTempMerchantId() + ")\u4e0d\u5b58\u5728");
            }
            BeanUtils.copyProperties((Object)qryRetMerchantBo, (Object)merchantInfoBo);
        }
        merchantInfoBo.setMerchantName(reqBo.getMerchantName());
        merchantInfoBo.setMerchantNameAbb(reqBo.getMerchantName());
        merchantInfoBo.setContactTel(reqBo.getContactTel());
        merchantInfoBo.setContactEmail(reqBo.getContactEmail());
        merchantInfoBo.setCreateOperId(reqBo.getCreateOperId());
        merchantInfoBo.setRemark(reqBo.getRemark());
        merchantInfoBo.setCreateTime(null);
        merchantInfoBo.setUpdateOperId(null);
        merchantInfoBo.setUpdateTime(null);
        return merchantInfoBo;
    }

    private Long generateMerchantId(Long merchantId) {
        try {
            if (merchantId != null || merchantId != 0L) {
                MerChantInfoPo qryMerchantReqPo = new MerChantInfoPo();
                qryMerchantReqPo.setMerchantId(merchantId);
                MerChantInfoPo merChantInfo = this.merChantInfoMapper.queryMerChantInfoById(qryMerchantReqPo);
                if (null != merChantInfo) {
                    throw new BusinessException("216031", "\u65b0\u589e\u5546\u6237\u5f02\u5e38\uff0c\u6b64\u5546\u6237ID[" + merchantId + "]\u5df2\u5b58\u5728");
                }
                return merchantId;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return PayProSequence.nextId();
    }

    private void validateArgInfo(PayProMerchantInfoReqBo reqBo) {
        MerChantInfoPo validatePo = new MerChantInfoPo();
        validatePo.setMerchantNameValidate(reqBo.getMerchantName());
        List<MerChantInfoPo> merchants = this.merChantInfoMapper.queryMerChantInfoByCondition(validatePo);
        if (!CollectionUtils.isEmpty(merchants)) {
            if (1 == reqBo.getDealType()) {
                throw new BusinessException("216031", "\u5546\u6237\u65b0\u589e\u5931\u8d25\uff0c\u5546\u6237\u540d\u79f0\uff08" + reqBo.getMerchantName() + "\uff09\u5df2\u5b58\u5728");
            }
            if (2 == reqBo.getDealType() && !reqBo.getMerchantId().equals(merchants.get(0).getMerchantId())) {
                throw new BusinessException("216031", "\u5546\u6237\u66f4\u65b0\u5931\u8d25\uff0c\u5546\u6237\u540d\u79f0\uff08" + reqBo.getMerchantName() + "\uff09\u5df2\u5b58\u5728");
            }
        }
        BusiSystemInfoPO qryReqPo = new BusiSystemInfoPO();
        qryReqPo.setBusiCode(reqBo.getBusiCode());
        List<BusiSystemInfoPO> busiSystemInfoPos = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(qryReqPo);
        if (CollectionUtils.isEmpty(busiSystemInfoPos)) {
            throw new BusinessException("218005", "\u4e1a\u52a1\u7cfb\u7edf" + reqBo.getBusiCode() + "\u4e0d\u5b58\u5728");
        }
        this.busiId = busiSystemInfoPos.get(0).getBusiId();
    }
}

