/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.UnionWapPayBusiService;
import com.tydic.payment.pay.busi.bo.UnionWapPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionWapPayBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="unionWapPayBusiService")
public class UnionWapPayBusiServiceImpl
implements UnionWapPayBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionWapPayBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Resource
    FileClient fileClient;

    public UnionWapPayBusiRspBO dealUnionWapPay(UnionWapPayBusiReqBO req) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u94f6\u8054\u624b\u673a\u7f51\u9875\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        }
        PorderPo orderInfo = this.queryOrderInfo(req.getOrderId());
        Date createTime = this.queryDBDateBusiService.getDBDate();
        String payOrderId = this.createPayTrans(orderInfo, createTime);
        this.loadProperties(req);
        Map<String, String> payReqContent = this.createPayReqContent(req, orderInfo, payOrderId, createTime);
        Map submitFromData = AcpService.sign(payReqContent, (String)"UTF-8");
        String requestFrontUrl = SdkConfig.getConfig().getFrontRequestUrl();
        String html = AcpService.createAutoFormHtml((String)requestFrontUrl, (Map)submitFromData, (String)"UTF-8");
        UnionWapPayBusiRspBO rsp = new UnionWapPayBusiRspBO();
        rsp.setRspCode("0000");
        rsp.setRspName("\u94f6\u8054\u624b\u673a\u7f51\u9875\u652f\u4ed8\u521b\u5efa\u8868\u5355\u6210\u529f\uff01");
        rsp.setPayOrderId(payOrderId);
        rsp.setAcpHtml(html);
        return rsp;
    }

    private PorderPo queryOrderInfo(String orderId) {
        return this.payOrderAtomService.queryPorderInfo(Long.valueOf(orderId));
    }

    private String createPayTrans(PorderPo orderInfo, Date createTime) {
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
        orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
        orderPayTransAtomReq.setMerchantId(orderInfo.getMerchantId());
        orderPayTransAtomReq.setPayMethod(Long.parseLong("113"));
        orderPayTransAtomReq.setOrderStatus("A00");
        orderPayTransAtomReq.setPayFee(orderInfo.getTotalFee());
        orderPayTransAtomReq.setCreateTime(createTime);
        try {
            return this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
        }
        catch (Exception e) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38", "\u521b\u5efa\u652f\u4ed8\u6d41\u6c34\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void loadProperties(UnionWapPayBusiReqBO req) {
        HashMap<String, String> payParaMap = new HashMap<String, String>(req.getParamMap().size());
        Set set = req.getParamMap().keySet();
        for (String key : set) {
            payParaMap.put(key, (String)req.getParamMap().get(key));
        }
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, payParaMap);
    }

    private Map<String, String> createPayReqContent(UnionWapPayBusiReqBO req, PorderPo orderInfo, String payOrderId, Date createTime) {
        String merId = (String)req.getParamMap().get("merId");
        HashMap<String, String> payReqContent = new HashMap<String, String>(64);
        payReqContent.put("version", SdkConfig.getConfig().getVersion());
        payReqContent.put("encoding", "UTF-8");
        payReqContent.put("signMethod", SdkConfig.getConfig().getSignMethod());
        payReqContent.put("txnType", "01");
        payReqContent.put("txnSubType", "01");
        payReqContent.put("bizType", "000201");
        payReqContent.put("channelType", "07");
        payReqContent.put("merId", merId);
        payReqContent.put("accessType", "0");
        payReqContent.put("orderId", payOrderId);
        payReqContent.put("txnTime", DateUtils.dateToStr((Date)createTime, (String)"yyyyMMddHHmmss"));
        payReqContent.put("currencyCode", "156");
        payReqContent.put("txnAmt", String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee()).longValue()));
        payReqContent.put("riskRateInfo", "{commodityName=" + orderInfo.getDetailName() + "}");
        payReqContent.put("frontUrl", SdkConfig.getConfig().getFrontUrl());
        payReqContent.put("backUrl", SdkConfig.getConfig().getBackUrl());
        payReqContent.put("payTimeout", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date().getTime() + 900000L));
        return payReqContent;
    }
}

