/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.util;

import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class PayAbleManager {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Map<Long, PayAble> payAbleMap = new ConcurrentHashMap<Long, PayAble>();

    public PayAble getPayAbleByPayMethod(Long payMethod) {
        PayAble payAble = this.payAbleMap.get(payMethod);
        if (payAble == null) {
            this.LOGGER.error("\u83b7\u53d6PayAble\u5b9e\u73b0\u7c7b\u5931\u8d25\uff0c\u652f\u4ed8\u65b9\u5f0f" + payMethod + "\u5bf9\u5e94\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728");
            throw new BusinessException("216008", "\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u65e0\u5bf9\u5e94\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff01");
        }
        return payAble;
    }

    public void registerPayAble(PayAble payAble) {
        Assert.notNull((Object)payAble, (String)"payAble can not be null");
        Assert.notNull((Object)payAble.getPayMethod(), (String)"payAble.getPayMethod can not be null");
        PayAble payAbleMethod = this.payAbleMap.get(payAble.getPayMethod());
        if (payAbleMethod != null) {
            throw new BusinessException("216008", "\u652f\u4ed8\u65b9\u5f0f(" + payAble.getPayMethod() + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        this.LOGGER.info("PayAbleManager.registerPayAble\u6ce8\u518c\u4e86\u652f\u4ed8\u65b9\u5f0f\uff1a" + payAble.getPayMethod());
        this.payAbleMap.put(payAble.getPayMethod(), payAble);
    }
}

