/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import com.tydic.payment.bill.busi.BillPaymentTransCreateBusiService;
import com.tydic.payment.bill.busi.BillWxPayTransCreateBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillPaymentTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillWxPayTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.comb.BillWxPayTransCombService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="billWxPayTransCombService")
public class BillWxPayTransCombServiceImpl
implements BillWxPayTransCombService {
    private static final String SUCCESS_CODE = "SUCCESS";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.log.isDebugEnabled();
    @Value(value="${project_name}")
    private String projectName;
    @Autowired
    private BillPaymentTransCreateBusiService billPaymentTransCreateBusiService;
    @Autowired
    private BillWxPayTransCreateBusiService billWxPayTransCreateBusiService;
    @Autowired
    private QueryRefundBusiService queryRefundBusiService;
    @Autowired
    private QueryPayTransBusiService queryPayTransBusiService;
    @Autowired
    private PaymentInsIdBusiService paymentInsIdBusiService;

    public void wxPayTrans(List<String> rows) {
        int size = rows.size();
        LocalDateTime startTime = LocalDateTime.now();
        Iterator<String> row = rows.iterator();
        while (row.hasNext()) {
            this.trans(row.next());
        }
        LocalDateTime endTime = LocalDateTime.now();
        Duration consumeTime = Duration.between(startTime, endTime);
        this.log.info("\u5fae\u4fe1\u652f\u4ed8 \u8d26\u5355\u5165\u5e93\u5b8c\u6210\u3002\u5171\u5904\u7406\u3010{}\u3011\u6761\u8bb0\u5f55\uff1b\u8017\u65f6\u3010{}\u3011\u79d2\u949f\u3002", (Object)size, (Object)consumeTime.getSeconds());
    }

    public void trans(String rows) {
        BillWxPayTransCreateReqBO wxPayTrans = this.buildWxPayTrans(rows);
        if (!wxPayTrans.getOutTradeNo().contains(this.projectName)) {
            this.log.info("\u8be5\u8ba2\u5355\u3010{}\u3011\u4e0d\u662f\u652f\u4ed8\u4e2d\u5fc3\u7684\u8ba2\u5355\uff0c\u6545\u4e0d\u8bb0\u5f55", (Object)wxPayTrans.getOutTradeNo());
            return;
        }
        BillPaymentTransCreateReqBO paymentTrans = this.buildPaymentTrans(wxPayTrans);
        this.billWxPayTransCreateBusiService.create(wxPayTrans);
        this.billPaymentTransCreateBusiService.create(paymentTrans);
    }

    private BillPaymentTransCreateReqBO buildPaymentTrans(BillWxPayTransCreateReqBO wxPayTrans) {
        BillPaymentTransCreateReqBO trans = new BillPaymentTransCreateReqBO();
        trans.setBillDate(wxPayTrans.getBillDate());
        trans.setBillFlag("0");
        trans.setPaymentMchId(wxPayTrans.getMchId());
        if (SUCCESS_CODE.equals(wxPayTrans.getResultCode())) {
            QueryPayTransRspBO payOrder = this.queryPayTransBusiService.queryByPayOrderId(wxPayTrans.getOutTradeNo());
            if (payOrder == null) {
                throw new RuntimeException("\u67e5\u627e\u652f\u4ed8\u8ba2\u5355\u5931\u8d25,\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728(" + wxPayTrans.getOutTradeNo() + ")");
            }
            wxPayTrans.setOrderId(payOrder.getOrderId());
            wxPayTrans.setBillTransId(payOrder.getOrderId() + payOrder.getPayOrderId());
            trans.setBusiId(payOrder.getBusiId());
            trans.setOrderId(payOrder.getOrderId());
            trans.setOrderType("01");
            trans.setTypeOrderId(payOrder.getPayOrderId());
            trans.setPaymentInsId(this.paymentInsIdBusiService.getPaymentInsIdByPayMethod(payOrder.getPayMethod()));
            trans.setTypeTransId(wxPayTrans.getTransactionId());
            trans.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((BigDecimal)wxPayTrans.getTotalFee()).longValue()));
            return trans;
        }
        QueryRefundRspBO refundOrder = this.queryRefundBusiService.queryByRefundOrderId(wxPayTrans.getOutRefundNo());
        if (refundOrder == null) {
            throw new RuntimeException("\u67e5\u627e\u9000\u6b3e\u8ba2\u5355\u5931\u8d25\uff1a" + wxPayTrans.toString());
        }
        wxPayTrans.setOrderId(refundOrder.getOrderId());
        wxPayTrans.setBillTransId(refundOrder.getOrderId() + refundOrder.getRefundOrderId());
        trans.setOrderId(refundOrder.getOrderId());
        trans.setBusiId(refundOrder.getBusiId());
        trans.setOrderType("02");
        trans.setTypeOrderId(refundOrder.getRefundOrderId());
        trans.setPaymentInsId(this.paymentInsIdBusiService.getPaymentInsIdByPayMethod(refundOrder.getPayMethod()));
        trans.setTypeTransId(wxPayTrans.getRefundId());
        trans.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((BigDecimal)wxPayTrans.getSettlementRefundFee()).longValue()));
        return trans;
    }

    private BillWxPayTransCreateReqBO buildWxPayTrans(String row) {
        BillWxPayTransCreateReqBO reqBO = new BillWxPayTransCreateReqBO();
        int index = 0;
        String[] columns = row.replace("`", "").split(",");
        reqBO.setTransTime(columns[index++]);
        reqBO.setAppId(columns[index++]);
        reqBO.setMchId(columns[index++]);
        reqBO.setSubMchId(columns[index++]);
        reqBO.setDeviceInfo(columns[index++]);
        reqBO.setTransactionId(columns[index++]);
        reqBO.setOutTradeNo(columns[index++]);
        reqBO.setOpenId(columns[index++]);
        reqBO.setTradeType(columns[index++]);
        reqBO.setResultCode(columns[index++]);
        reqBO.setBank(columns[index++]);
        reqBO.setFeeType(columns[index++]);
        reqBO.setTotalFee(new BigDecimal(columns[index++]));
        reqBO.setRedFee(new BigDecimal(columns[index++]));
        reqBO.setRefundId(columns[index++]);
        reqBO.setOutRefundNo(columns[index++]);
        reqBO.setSettlementRefundFee(new BigDecimal(columns[index++]));
        reqBO.setRedRefundFee(new BigDecimal(columns[index++]));
        reqBO.setRefundType(columns[index++]);
        reqBO.setRefundCode(columns[index++]);
        reqBO.setBody(columns[index++]);
        reqBO.setDetail(columns[index++]);
        reqBO.setMerFee(new BigDecimal(columns[index++]));
        reqBO.setRateFee(columns[index]);
        String billDate = reqBO.getTransTime();
        billDate = billDate.replaceAll("-", "");
        billDate = billDate.substring(0, 8);
        reqBO.setBillDate(Long.valueOf(billDate));
        reqBO.setBillCheckFlag("0");
        return reqBO;
    }
}

