/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PayProUpdateOrderTransBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiRspBo;
import com.tydic.payment.pay.comb.PayAbleQryPayStatusCombService;
import com.tydic.payment.pay.comb.bo.PayAbleQryPayStatusCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleQryPayStatusCombRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.BeanUtils;
import com.tydic.payment.pay.util.PayAbleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.comb.PayAbleQryPayStatusCombService"})
public class PayAbleQryPayStatusCombServiceImpl
implements PayAbleQryPayStatusCombService {
    private static final Logger LOG = LoggerFactory.getLogger(PayAbleQryPayStatusCombServiceImpl.class);
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayProUpdateOrderTransBusiService payProUpdateOrderTransBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    private static final String NEED_CALLBACK = "1";
    private static final String QUERY_SUCCESS = "\u67e5\u8be2\u6210\u529f";

    /*
     * Enabled aggressive block sorting
     */
    @PostMapping(value={"qryOrderStatus"})
    public PayAbleQryPayStatusCombRspBo qryOrderStatus(@RequestBody PayAbleQryPayStatusCombReqBo reqBo) {
        PayAbleQryPayStatusCombRspBo retBo = new PayAbleQryPayStatusCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("213004");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Long orderId = reqBo.getOrderId();
        PayOrderRspBo orderInfoBo = this.payOrderBusiService.selectOrderByOrderId(reqBo.getOrderId());
        if (orderInfoBo == null || !"0000".equals(orderInfoBo.getRspCode())) {
            retBo.setRespCode("213004");
            retBo.setRespDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        String payOrderId = null;
        PorderPayTransAtomRspBo transAtomRspBo = this.porderPayTransAtomService.queryLastRecordByOrderId(orderId);
        if (transAtomRspBo == null) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(QUERY_SUCCESS);
            retBo.setPayStatus("FAIL");
            retBo.setPayStatusMsg("\u8be5\u8ba2\u5355(" + orderId + ")\u8fd8\u672a\u53d1\u8d77\u652f\u4ed8");
            return retBo;
        }
        payOrderId = transAtomRspBo.getPayOrderId();
        Long payMethod = transAtomRspBo.getPayMethod();
        if ("A10".equals(orderInfoBo.getOrderStatus()) && "A10".equals(transAtomRspBo.getOrderStatus())) {
            if (NEED_CALLBACK.equals(reqBo.getNeedCallBack())) {
                CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                callBackNoticeReqBo.setOrderId(orderId);
                CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                    LOG.info("\u8ba2\u5355\uff1a" + orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                }
            }
            retBo.setRespCode("0000");
            retBo.setRespDesc(QUERY_SUCCESS);
            retBo.setPayOrderId(payOrderId);
            retBo.setTradeTime(orderInfoBo.getTradeTime());
            retBo.setPayStatus("SUCCESS");
            retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f");
            retBo.setPayNotifyTransId(orderInfoBo.getPayNotifyTransId());
            this.setProparedDate(retBo, orderInfoBo, transAtomRspBo);
            retBo.setDetailName(orderInfoBo.getDetailName());
            retBo.setRedirectUrl(orderInfoBo.getRedirectUrl());
            return retBo;
        }
        if (!NEED_CALLBACK.equals(reqBo.getRealQueryFlag())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(QUERY_SUCCESS);
            retBo.setPayStatus("FAIL");
            retBo.setPayStatusMsg("\u8be5\u8ba2\u5355(" + orderId + ")\u672a\u652f\u4ed8");
            return retBo;
        }
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
        PayProQueryPayParaBusiReqBo qryParaBo = new PayProQueryPayParaBusiReqBo();
        qryParaBo.setMerchantId(orderInfoBo.getMerchantId());
        qryParaBo.setPayMethod(payMethod);
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode("213004");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        PayAbleQryPayStatusReqBo qryPayStatusBo = new PayAbleQryPayStatusReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPayStatusBo);
        qryPayStatusBo.setOrderId(orderId);
        qryPayStatusBo.setPayOrderId(payOrderId);
        qryPayStatusBo.setParaMap(payProQueryPayParaBusiRspBo.getDetailAttrs());
        qryPayStatusBo.setTradeTime(transAtomRspBo.getTradeTime());
        qryPayStatusBo.setPayNotifyTransId(transAtomRspBo.getPayNotifyTransId());
        qryPayStatusBo.setCreateTime(transAtomRspBo.getCreateTime());
        PayAbleQryPayStatusRspBo payAbleQryPayStatusRspBo = payAble.qryPayStatus(qryPayStatusBo);
        if (!"0000".equals(payAbleQryPayStatusRspBo.getRespCode())) {
            retBo.setRespCode("213004");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u673a\u6784\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff1a" + payAbleQryPayStatusRspBo.getRespDesc());
            return retBo;
        }
        if ("SUCCESS".equals(payAbleQryPayStatusRspBo.getPayStatus()) && !"A10".equals(transAtomRspBo.getOrderStatus())) {
            String validateQueryResultStr = this.validateQueryResult(payAbleQryPayStatusRspBo, payMethod);
            if (!StringUtils.isEmpty((Object)validateQueryResultStr)) {
                LOG.error(validateQueryResultStr);
                throw new BusinessException("217001", validateQueryResultStr);
            }
            PayProUpdateOrderTransBusiReqBo updateOrderData = this.makeUpdateBo(reqBo, payAbleQryPayStatusRspBo);
            PayProUpdateOrderTransBusiRspBo payProUpdateOrderTransBusiRspBo = this.payProUpdateOrderTransBusiService.updateOrderData(updateOrderData);
            if (!"0000".equals(payProUpdateOrderTransBusiRspBo.getRespCode())) {
                retBo.setRespCode("213004");
                retBo.setRespDesc("\u67e5\u8be2\u56de\u6765\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + payProUpdateOrderTransBusiRspBo.getRespDesc());
                return retBo;
            }
            this.setRetBoData(retBo, payAbleQryPayStatusRspBo);
            this.setProparedDate(retBo, orderInfoBo, transAtomRspBo);
            return retBo;
        }
        retBo.setPayStatusMsg(payAbleQryPayStatusRspBo.getPayStatusMsg());
        retBo.setPayStatus(payAbleQryPayStatusRspBo.getPayStatus());
        retBo.setPayOrderId(payOrderId);
        retBo.setRespCode("0000");
        retBo.setRespDesc(QUERY_SUCCESS);
        retBo.setPayMethod(payMethod);
        return retBo;
    }

    private void setProparedDate(PayAbleQryPayStatusCombRspBo retBo, PayOrderRspBo orderInfoBo, PorderPayTransAtomRspBo transAtomRspBo) {
        retBo.setCreateOperId(orderInfoBo.getCreateOperId());
        retBo.setMerchantId(orderInfoBo.getMerchantId());
        retBo.setOrderId(orderInfoBo.getOrderId());
        retBo.setOutOrderId(orderInfoBo.getOutOrderId());
        retBo.setOutRemark(orderInfoBo.getOutRemark());
        retBo.setReqWay(orderInfoBo.getReqWay());
        retBo.setTotalFee(MoneyUtils.haoToFen((Long)orderInfoBo.getTotalFee()).longValue() + "");
        retBo.setPayMethod(transAtomRspBo.getPayMethod());
        if (orderInfoBo.getRefundFee() != null) {
            retBo.setRefundedFee(MoneyUtils.haoToFen((Long)orderInfoBo.getRefundFee()).longValue() + "");
        }
        retBo.setDetailName(orderInfoBo.getDetailName());
        retBo.setRedirectUrl(orderInfoBo.getRedirectUrl());
    }

    private PayProUpdateOrderTransBusiReqBo makeUpdateBo(PayAbleQryPayStatusCombReqBo reqBo, PayAbleQryPayStatusRspBo payAbleQryPayStatusRspBo) {
        PayProUpdateOrderTransBusiReqBo updateOrderData = new PayProUpdateOrderTransBusiReqBo();
        updateOrderData.setOrderId(reqBo.getOrderId());
        updateOrderData.setOrderStatus("A10");
        updateOrderData.setPayNotifyTransId(payAbleQryPayStatusRspBo.getPayNotifyTransId());
        updateOrderData.setPayOrderId(payAbleQryPayStatusRspBo.getPayOrderId());
        updateOrderData.setTradeTime(payAbleQryPayStatusRspBo.getTradeTime());
        updateOrderData.setPayNotifyCode("0");
        updateOrderData.setPayNotifyMsg("\u67e5\u8be2\u66f4\u65b0");
        updateOrderData.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
        return updateOrderData;
    }

    private void setRetBoData(PayAbleQryPayStatusCombRspBo retBo, PayAbleQryPayStatusRspBo payAbleQryPayStatusRspBo) {
        retBo.setRespCode("0000");
        retBo.setRespDesc(QUERY_SUCCESS);
        retBo.setPayOrderId(payAbleQryPayStatusRspBo.getPayOrderId());
        retBo.setPayStatus("SUCCESS");
        retBo.setPayStatusMsg(payAbleQryPayStatusRspBo.getPayStatus());
        retBo.setTradeTime(payAbleQryPayStatusRspBo.getTradeTime());
        retBo.setPayNotifyTransId(payAbleQryPayStatusRspBo.getPayNotifyTransId());
    }

    private String validateQueryResult(PayAbleQryPayStatusRspBo payBo, Long payMethod) {
        if (StringUtils.isEmpty((Object)payBo.getOrderId())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56deorderId";
        }
        if (StringUtils.isEmpty((Object)payBo.getPayNotifyTransId())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56depayNotifyTransId";
        }
        if (StringUtils.isEmpty((Object)payBo.getPayOrderId())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56depayOrderId";
        }
        if (StringUtils.isEmpty((Object)payBo.getTradeTime())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56detradeTime";
        }
        return null;
    }

    private String validateArg(PayAbleQryPayStatusCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getOrderId()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

