/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.transbo.YeePayNotifyBO;
import com.tydic.payment.pay.payable.impl.transbo.YeePayNotifyBusiDataBO;
import com.tydic.payment.pay.payable.impl.transbo.YeePayRefundNotifyBusiDataBO;
import com.yeepay.yop.sdk.service.trade.TradeClient;
import com.yeepay.yop.sdk.service.trade.TradeClientBuilder;
import com.yeepay.yop.sdk.service.trade.model.OrderQueryYopQueryOrderResDTOResult;
import com.yeepay.yop.sdk.service.trade.model.RefundResponseRefundDTOResult;
import com.yeepay.yop.sdk.service.trade.request.OrderQueryRequest;
import com.yeepay.yop.sdk.service.trade.request.RefundRequest;
import com.yeepay.yop.sdk.service.trade.response.OrderQueryResponse;
import com.yeepay.yop.sdk.service.trade.response.RefundResponse;
import com.yeepay.yop.sdk.utils.DigitalEnvelopeUtils;
import java.math.BigDecimal;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public abstract class AbstractYeePayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractYeePayAble.class);
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";
    private static final String FAILED = "FAILED";
    private static final String PROCESSING = "PROCESSING";
    private static final String CLOSE = "CLOSE";
    private static final String TIME_OUT = "TIME_OUT";
    private static final String RSA2048 = "RSA2048";
    private static final String MERCHANT_NO = "merchantNo";
    private static final String OPR00000 = "OPR00000";
    private static final TradeClient api = (TradeClient)TradeClientBuilder.builder().build();
    @Value(value="${yee.pay.platform.merchantNo}")
    private String platformMerchantNo;
    @Value(value="${yee.pay.refund.notify.url:1}")
    private String refundNotifyUrl;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        PayAbleRefundRspBo rspBO = new PayAbleRefundRspBo();
        String validateArgStr = this.validateRefundArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        Map paraMap = reqBo.getParaMap();
        String merchantNo = (String)paraMap.get(MERCHANT_NO);
        RefundRequest request = new RefundRequest();
        request.setParentMerchantNo(this.platformMerchantNo);
        request.setMerchantNo(merchantNo);
        request.setOrderId(reqBo.getPayOrderId());
        request.setRefundRequestId(reqBo.getRefundOrderId());
        request.setUniqueOrderNo(reqBo.getPayNotifyTransId());
        request.setRefundAmount(this.fen2Yuan(reqBo.getRefundFee()));
        request.setDescription(reqBo.getRefundReason());
        request.setNotifyUrl(this.refundNotifyUrl);
        log.info("\u6613\u5b9d\u652f\u4ed8\u9000\u6b3e\u8bf7\u6c42\u62a5\u6587\uff0crequest:{}", (Object)JSON.toJSONString((Object)request));
        RefundResponse response = null;
        try {
            response = api.refund(request);
            log.info("\u6613\u5b9d\u652f\u4ed8\u9000\u6b3e\u54cd\u5e94\u62a5\u6587\uff0c result:{}", (Object)JSON.toJSONString((Object)response.getResult()));
        }
        catch (Exception e) {
            log.error("Exception when calling TradeClient#refund, ex:", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6613\u5b9d\u652f\u4ed8\u9000\u6b3e\u5f02\u5e38\uff1a" + e);
            return rspBO;
        }
        if (ObjectUtils.isEmpty((Object)response)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6613\u5b9d\u652f\u4ed8\u9000\u6b3e\u5f02\u5e38\uff1a\u9000\u6b3e\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
            return rspBO;
        }
        RefundResponseRefundDTOResult result = response.getResult();
        this.sortRefundRspBO(reqBo, result, rspBO);
        return rspBO;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        log.info("\u8fdb\u5165\u6613\u5b9d\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\uff1a{}" + JSON.toJSONString((Object)reqBo));
        PayAbleCallBackRspBo rspBO = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            log.error("\u6613\u5b9d\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6613\u5b9d\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        String reqData = reqBo.getReqData();
        YeePayNotifyBO yeePayNotifyBO = (YeePayNotifyBO)JSON.parseObject((String)reqData, YeePayNotifyBO.class);
        String plaintext = DigitalEnvelopeUtils.decrypt((String)yeePayNotifyBO.getResponse(), (String)yeePayNotifyBO.getCustomerIdentification(), (String)RSA2048);
        if (reqBo.isRefund()) {
            YeePayRefundNotifyBusiDataBO yeePayRefundNotifyBusiDataBO = (YeePayRefundNotifyBusiDataBO)JSON.parseObject((String)plaintext, YeePayRefundNotifyBusiDataBO.class);
            if (SUCCESS.equals(yeePayRefundNotifyBusiDataBO.getStatus())) {
                rspBO.setRefundOrderId(yeePayRefundNotifyBusiDataBO.getRefundRequestId());
                rspBO.setRefundNotifyTransId(yeePayRefundNotifyBusiDataBO.getUniqueRefundNo());
                String tradeTime = yeePayRefundNotifyBusiDataBO.getRefundSuccessDate().replaceAll(" ", "").replaceAll("-", "").replaceAll(":", "");
                rspBO.setTradeTime(tradeTime);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
            }
            return rspBO;
        }
        YeePayNotifyBusiDataBO yeePayNotifyBusiDataBO = (YeePayNotifyBusiDataBO)JSON.parseObject((String)plaintext, YeePayNotifyBusiDataBO.class);
        log.info("\u6613\u5b9d\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u53c2\u6570\u660e\u6587\uff1a{}", (Object)JSON.toJSONString((Object)yeePayNotifyBusiDataBO));
        if (ObjectUtils.isEmpty((Object)yeePayNotifyBusiDataBO)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        if (SUCCESS.equals(yeePayNotifyBusiDataBO.getStatus())) {
            rspBO.setTradeTime(yeePayNotifyBusiDataBO.getPaySuccessDate());
            rspBO.setPayOrderId(yeePayNotifyBusiDataBO.getOrderId());
            rspBO.setPayNotifyTransId(yeePayNotifyBusiDataBO.getUniqueOrderNo());
            if ("WECHAT".equals(yeePayNotifyBusiDataBO.getChannel())) {
                rspBO.setPayMethod(Long.valueOf(611L));
            } else if ("ALIPAY".equals(yeePayNotifyBusiDataBO.getChannel())) {
                rspBO.setPayMethod(Long.valueOf(612L));
            } else {
                rspBO.setPayMethod(Long.valueOf(610L));
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("\u5931\u8d25");
        rspBO.setRespDesc("\u5931\u8d25");
        return rspBO;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo rspBo = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        Map paraMap = reqBo.getParaMap();
        String merchantNo = (String)paraMap.get(MERCHANT_NO);
        OrderQueryRequest request = new OrderQueryRequest();
        request.setParentMerchantNo(this.platformMerchantNo);
        request.setMerchantNo(merchantNo);
        request.setOrderId(reqBo.getPayOrderId());
        OrderQueryResponse response = null;
        try {
            response = api.orderQuery(request);
            log.info("\u6613\u5b9d\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0cresult:{}", (Object)JSON.toJSONString((Object)response.getResult()));
        }
        catch (Exception e) {
            log.error("\u6613\u5b9d\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        if (response == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u6613\u5b9d\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            return rspBo;
        }
        OrderQueryYopQueryOrderResDTOResult result = response.getResult();
        this.sortQryStatusRspBo(reqBo, result, rspBo);
        return rspBo;
    }

    private void sortQryStatusRspBo(PayAbleQryPayStatusReqBo reqBo, OrderQueryYopQueryOrderResDTOResult result, PayAbleQryPayStatusRspBo rspBo) {
        if (!ObjectUtils.isEmpty((Object)result) && OPR00000.equalsIgnoreCase(result.getCode())) {
            rspBo.setOrderId(reqBo.getOrderId());
            rspBo.setPayOrderId(reqBo.getPayOrderId());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
            switch (result.getStatus()) {
                case "SUCCESS": {
                    log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6613\u5b9d\u652f\u4ed8\u6210\u529f\u8ba2\u5355-----------------------------------");
                    rspBo.setTradeTime(result.getPaySuccessDate());
                    rspBo.setRealFee(this.yuan2Fen(result.getRealPayAmount()));
                    rspBo.setPayStatus(SUCCESS);
                    rspBo.setPayNotifyTransId(result.getUniqueOrderNo());
                    rspBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f");
                    break;
                }
                case "FAIL": {
                    log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6613\u5b9d\u652f\u4ed8\u5931\u8d25\u8ba2\u5355-----------------------------------");
                    rspBo.setPayStatus(FAIL);
                    rspBo.setPayStatusMsg("\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
                    break;
                }
                case "PROCESSING": {
                    log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6613\u5b9d\u652f\u4ed8\u5904\u7406\u4e2d\u8ba2\u5355-----------------------------------");
                    rspBo.setPayStatus("PAYING");
                    rspBo.setPayStatusMsg("\u7528\u6237\u652f\u4ed8\u4e2d");
                    break;
                }
                case "CLOSE": {
                    log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6613\u5b9d\u652f\u4ed8\u5df2\u5173\u95ed\u8ba2\u5355-----------------------------------");
                    rspBo.setPayStatus("CLOSED");
                    rspBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u5173\u95ed");
                    break;
                }
                case "TIME_OUT": {
                    log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6613\u5b9d\u652f\u4ed8\u5df2\u8d85\u65f6\u8ba2\u5355-----------------------------------");
                    rspBo.setPayStatus(FAIL);
                    rspBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u8d85\u65f6");
                    break;
                }
                default: {
                    log.debug("\u6613\u5b9d\u652f\u4ed8\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c-----------------------------------");
                    rspBo.setRespCode("212008");
                    rspBo.setRespDesc("\u6613\u5b9d\u652f\u4ed8\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                    rspBo.setPayStatus(FAIL);
                    break;
                }
            }
        } else {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5931\u8d25");
        }
    }

    public String validateQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private Long yuan2Fen(BigDecimal yuan) {
        Double fen = yuan.doubleValue() * 100.0;
        return fen.longValue();
    }

    private String fen2Yuan(Long fen) {
        return String.valueOf(fen.doubleValue() / 100.0);
    }

    public String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap()) || reqBo.getParaMap().isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private void sortRefundRspBO(PayAbleRefundReqBo reqBo, RefundResponseRefundDTOResult result, PayAbleRefundRspBo rspBo) {
        if (!ObjectUtils.isEmpty((Object)result) && OPR00000.equals(result.getCode())) {
            BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
            switch (result.getStatus()) {
                case "PROCESSING": {
                    rspBo.setRespCode("0000");
                    rspBo.setRespDesc("\u6210\u529f");
                    break;
                }
                case "SUCCESS": {
                    rspBo.setRefundTransId(result.getUniqueRefundNo());
                    String dateStr = new DateTime((Object)result.getRefundRequestDate()).toString("yyyyMMddHHmmss");
                    rspBo.setTradeTime(dateStr);
                    rspBo.setRespCode("0000");
                    rspBo.setRespDesc("\u6210\u529f");
                    break;
                }
                case "FAILED": {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u5931\u8d25");
                }
                default: {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u5931\u8d25");
                    break;
                }
            }
        } else {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5931\u8d25");
        }
    }
}

