/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.bo.DivideDetailDataBO;
import com.tydic.payment.pay.atom.PayProQueryPayParaAtomService;
import com.tydic.payment.pay.atom.bo.PayProQueryPayParaAtomReqBo;
import com.tydic.payment.pay.atom.bo.PayProQueryPayParaAtomRspBo;
import com.tydic.payment.pay.busi.PayDealDivideBusiService;
import com.tydic.payment.pay.busi.bo.DivideDetailBO;
import com.tydic.payment.pay.busi.bo.PayDealDivideBusiReqBO;
import com.tydic.payment.pay.busi.bo.PayDealDivideBusiRspBO;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.dao.BusiSystemInfoMapper;
import com.tydic.payment.pay.dao.PDivideDetailMapper;
import com.tydic.payment.pay.dao.PSubOrderMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PDivideDetailPO;
import com.tydic.payment.pay.dao.po.PSubOrderPO;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.yeepay.yop.sdk.service.divide.DivideClient;
import com.yeepay.yop.sdk.service.divide.DivideClientBuilder;
import com.yeepay.yop.sdk.service.divide.model.ApplyYopOrderDivideResDTOResult;
import com.yeepay.yop.sdk.service.divide.request.ApplyRequest;
import com.yeepay.yop.sdk.service.divide.response.ApplyResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="payDealDivideBusiService")
public class PayDealDivideBusiServiceImpl
implements PayDealDivideBusiService {
    private static final Logger log = LoggerFactory.getLogger(PayDealDivideBusiServiceImpl.class);
    @Autowired
    private PSubOrderMapper pSubOrderMapper;
    @Autowired
    private PDivideDetailMapper pDivideDetailMapper;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PayProQueryPayParaAtomService payProQueryPayParaAtomService;
    @Value(value="${yee.pay.platform.merchantNo:123}")
    private String platformMerchantNo;
    @Autowired
    private BusiSystemInfoMapper busiSystemInfoMapper;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    private static final String MERCHANT_NO = "merchantNo";
    private static final String A10 = "A10";
    private static final String D00 = "D00";
    private static final String DIVIDE = "DIVIDE";
    private static final String SUCCESS = "OPR00000";
    private static final String HTTP_ERROR = "5555";
    private static final DivideClient api = (DivideClient)DivideClientBuilder.builder().build();

    public PayDealDivideBusiRspBO dealDivide(PayDealDivideBusiReqBO reqBO) {
        PayDealDivideBusiRspBO rspBO = new PayDealDivideBusiRspBO();
        String checkResult = this.checkReqParam(reqBO);
        if (!StringUtils.isEmpty((Object)checkResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkResult);
            return rspBO;
        }
        BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
        busiSystemInfoPO.setBusiCode(reqBO.getBusiCode());
        List<BusiSystemInfoPO> busiSystemInfoPOS = this.busiSystemInfoMapper.queryBusiSystemIdAndName(busiSystemInfoPO);
        if (CollectionUtils.isEmpty(busiSystemInfoPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5206\u8d26\u5931\u8d25\uff0c\u68c0\u67e5\u4f20\u5165\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801");
            return rspBO;
        }
        Long busiId = busiSystemInfoPOS.get(0).getBusiId();
        PorderPo porderPo = new PorderPo();
        porderPo.setOutOrderId(reqBO.getOutOrderId());
        PorderPo orderInfo = this.porderMapper.selectPorderByOutOrderIdAndBusiId(reqBO.getOutOrderId(), busiId);
        List divideDetailList = reqBO.getDivideDetailList();
        int divideTotalAmount = 0;
        for (DivideDetailDataBO bo : divideDetailList) {
            divideTotalAmount += bo.getAmount().intValue();
        }
        int total_fee = 0;
        String payOrderId = null;
        String payNotifyTransId = null;
        String merchantId = null;
        try {
            if (StringUtils.isEmpty((Object)reqBO.getSubOrderId())) {
                total_fee = orderInfo.getTotalFee().intValue() / 100;
                PorderPayTransPo transPo = new PorderPayTransPo();
                transPo.setOrderId(orderInfo.getOrderId());
                List<PorderPayTransPo> porderPayTransPos = this.porderPayTransMapper.queryOrderPayTrans(transPo);
                List collect = porderPayTransPos.stream().filter(po -> po.getOrderStatus().equals(A10)).collect(Collectors.toList());
                PorderPayTransPo payTransPo = (PorderPayTransPo)collect.get(0);
                payOrderId = payTransPo.getPayOrderId();
                payNotifyTransId = payTransPo.getPayNotifyTransId();
                merchantId = payTransPo.getMerchantId().toString();
            } else {
                PSubOrderPO pSubOrderPO = new PSubOrderPO();
                pSubOrderPO.setSubOrderId(reqBO.getSubOrderId());
                pSubOrderPO.setOrderId(orderInfo.getOrderId().toString());
                PSubOrderPO modelBy = this.pSubOrderMapper.getModelBy(pSubOrderPO);
                total_fee = modelBy.getPayAmount().intValue();
                payOrderId = modelBy.getSubOrderId();
                payNotifyTransId = modelBy.getPayNotifyTransId();
                merchantId = modelBy.getMerchantId();
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5206\u8d26\u5904\u7406\u5f02\u5e38");
        }
        if (total_fee > divideTotalAmount) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5206\u8d26\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u603b\u91d1\u989d");
            return rspBO;
        }
        String merchantNo = this.getMerchantNo(merchantId);
        ArrayList<DivideDetailBO> yeeDivideList = new ArrayList<DivideDetailBO>();
        ArrayList<PDivideDetailPO> pDivideDetailPOS = new ArrayList<PDivideDetailPO>();
        for (DivideDetailDataBO bo : divideDetailList) {
            DivideDetailBO yeeDivide = new DivideDetailBO();
            Double amount = bo.getAmount().doubleValue() / 100.0;
            yeeDivide.setAmount(amount.toString());
            yeeDivide.setLedgerNo(this.getMerchantNo(bo.getMerchantId()));
            yeeDivideList.add(yeeDivide);
            PDivideDetailPO pDivideDetailPO = new PDivideDetailPO();
            pDivideDetailPO.setId(Long.valueOf(PayProSequence.nextId()).intValue());
            pDivideDetailPO.setOrderId(orderInfo.getOrderId().toString());
            pDivideDetailPO.setMerchantId(bo.getMerchantId());
            pDivideDetailPO.setMerchantNo(this.getMerchantNo(bo.getMerchantId()));
            pDivideDetailPO.setDivideAmount(bo.getAmount().intValue());
            pDivideDetailPO.setStatus(D00);
            pDivideDetailPO.setPayOrderId(payOrderId);
            pDivideDetailPO.setMchOrderId(payNotifyTransId);
            pDivideDetailPO.setOrderTotalAmount(orderInfo.getTotalFee().intValue() / 100);
            pDivideDetailPOS.add(pDivideDetailPO);
        }
        this.pDivideDetailMapper.insertBatch(pDivideDetailPOS);
        ApplyRequest request = new ApplyRequest();
        request.setParentMerchantNo(this.platformMerchantNo);
        request.setMerchantNo(merchantNo);
        request.setOrderId(payOrderId);
        request.setUniqueOrderNo(payNotifyTransId);
        request.setDivideRequestId(DIVIDE + reqBO.getOutOrderId());
        request.setDivideDetail(JSON.toJSONString(yeeDivideList));
        ApplyResponse response = null;
        try {
            log.info("\u6613\u5b9d\u5206\u8d26\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)request));
            response = api.apply(request);
            if (response == null) {
                rspBO.setRespCode(HTTP_ERROR);
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
            log.info("\u6613\u5b9d\u5206\u8d26\u54cd\u5e94\u62a5\u6587result:{}", (Object)response.getResult());
        }
        catch (Exception e) {
            log.error("\u6613\u5b9d\u5206\u8d26\u5f02\u5e38Exception when calling DivideClient#apply, ex:", (Throwable)e);
            rspBO.setRespCode(HTTP_ERROR);
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        ApplyYopOrderDivideResDTOResult result = response.getResult();
        if (result.getCode().equals(SUCCESS) && !StringUtils.isEmpty((Object)result.getStatus())) {
            for (PDivideDetailPO po2 : pDivideDetailPOS) {
                po2.setStatus("D10");
                this.pDivideDetailMapper.updateById(po2);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setStatus(result.getStatus());
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u5931\u8d25");
        return rspBO;
    }

    public String getMerchantNo(String merchantId) {
        PayProQueryPayParaAtomReqBo qryPayParaBo = new PayProQueryPayParaAtomReqBo();
        qryPayParaBo.setPayMethod(610L);
        qryPayParaBo.setMerchantId(Long.valueOf(merchantId));
        PayProQueryPayParaAtomRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaAtomService.queryPayPara(qryPayParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            throw new BusinessException("8888", payProQueryPayParaBusiRspBo.getRespDesc());
        }
        Map<String, String> paramMap = payProQueryPayParaBusiRspBo.getDetailAttrs();
        return paramMap.get(MERCHANT_NO);
    }

    private String checkReqParam(PayDealDivideBusiReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5b57\u6bb5\u3010busiCode\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5b57\u6bb5\u3010outOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDivideDetailList())) {
            return "\u5206\u8d26\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

