/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.tydic.payment.pay.busi.PayProCreateOrderPayTransBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PayProWxUnifiedOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiRspBo;
import com.tydic.payment.pay.comb.PayProPreparedOrderCombService;
import com.tydic.payment.pay.comb.PayProWxJsapiCombService;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProWxJsapiCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProWxJsapiCombRspBo;
import com.tydic.payment.pay.wx.util.RandomStringGenerator;
import com.tydic.payment.pay.wx.util.Signature;
import java.util.HashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.comb.PayProWxJsapiCombService"})
public class PayProWxJsapiCombbServiceImpl
implements PayProWxJsapiCombService {
    @Autowired
    private PayProCreateOrderPayTransBusiService payProCreateOrderPayTransBusiService;
    @Autowired
    private PayProPreparedOrderCombService payProPreparedOrderCombService;
    @Autowired
    private PayProWxUnifiedOrderBusiService payProWxUnifiedOrderBusiService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String MD5 = "MD5";

    @PostMapping(value={"dealOrder"})
    public PayProWxJsapiCombRspBo dealOrder(@RequestBody PayProWxJsapiCombReqBo reqBo) {
        PayProWxJsapiCombRspBo retBo = new PayProWxJsapiCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("213002");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String payMethod = this.getPayMethodByReqWay(reqBo.getReqWay());
        PayProPreparedOrderCombReqBo createOrderBo = new PayProPreparedOrderCombReqBo();
        this.sortCreateOrderBo(reqBo, createOrderBo);
        createOrderBo.setOrderType("01");
        PayProPreparedOrderCombRspBo createOrderRetBo = this.payProPreparedOrderCombService.createOrder(createOrderBo);
        if (!"0000".equals(createOrderRetBo.getRespCode())) {
            retBo.setRespCode("213002");
            retBo.setRespDesc("\u8c03\u7528\u4e0b\u5355\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff1a" + createOrderRetBo.getRespDesc());
            return retBo;
        }
        PayProCreateOrderPayTransBusiReqBo createTransBo = new PayProCreateOrderPayTransBusiReqBo();
        this.sortTransBo(reqBo, payMethod, createOrderRetBo, createTransBo);
        PayProCreateOrderPayTransBusiRspBo createTransRetBo = this.payProCreateOrderPayTransBusiService.createPayTrans(createTransBo);
        if (!"0000".equals(createTransRetBo.getRespCode())) {
            retBo.setRespCode("213002");
            retBo.setRespDesc("\u8c03\u7528\u5199trans\u8868busi\u670d\u52a1\u5931\u8d25\uff1a" + createTransRetBo.getRespDesc());
            return retBo;
        }
        PayProQueryPayParaBusiReqBo qryPayParaBo = new PayProQueryPayParaBusiReqBo();
        qryPayParaBo.setPayMethod(Long.valueOf(Long.parseLong(payMethod)));
        qryPayParaBo.setMerchantId(Long.valueOf(Long.parseLong(reqBo.getMerchantId())));
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode("213002");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        String signKey = (String)payProQueryPayParaBusiRspBo.getDetailAttrs().get("signkey");
        PayProWxUnifiedOrderBusiReqBo createUnfiedBo = new PayProWxUnifiedOrderBusiReqBo();
        this.sortUnfiedBo(reqBo, payMethod, createTransRetBo, payProQueryPayParaBusiRspBo, createUnfiedBo);
        PayProWxUnifiedOrderBusiRspBo unfiedRetBo = this.payProWxUnifiedOrderBusiService.unifiedOrder(createUnfiedBo);
        if (!"0000".equals(unfiedRetBo.getRespCode())) {
            retBo.setRespCode("213002");
            retBo.setRespDesc("\u8c03\u7528\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355busi\u670d\u52a1\u5931\u8d25\uff1a" + unfiedRetBo.getRespDesc());
            return retBo;
        }
        this.sortRetBo(reqBo, retBo, signKey, unfiedRetBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u4e0b\u5355\u6210\u529f");
        return retBo;
    }

    private void sortRetBo(PayProWxJsapiCombReqBo reqBo, PayProWxJsapiCombRspBo retBo, String signKey, PayProWxUnifiedOrderBusiRspBo unfiedRetBo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        String appId = unfiedRetBo.getAppId();
        String prepayId = unfiedRetBo.getPrepayId();
        unfiedRetBo.getCodeUrl();
        unfiedRetBo.getMwebUrl();
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String packageBody = "prepay_id=" + prepayId;
        String nonceStr = RandomStringGenerator.getRandomStringByLength((int)32);
        HashMap<String, String> signMsg = new HashMap<String, String>(16);
        signMsg.put("appId", appId);
        signMsg.put("timeStamp", timeStamp);
        signMsg.put("nonceStr", nonceStr);
        signMsg.put("package", packageBody);
        signMsg.put("signType", MD5);
        String sign = Signature.getSign(signMsg, (String)signKey);
        retBo.setAppId(appId);
        retBo.setTimeStamp(timeStamp);
        retBo.setNonceStr(nonceStr);
        retBo.setPackageBody(packageBody);
        retBo.setSignType(MD5);
        retBo.setPaySign(sign);
    }

    private void sortUnfiedBo(PayProWxJsapiCombReqBo reqBo, String payMethod, PayProCreateOrderPayTransBusiRspBo createTransRetBo, PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo, PayProWxUnifiedOrderBusiReqBo createUnfiedBo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)createUnfiedBo);
        createUnfiedBo.setPayOrderId(createTransRetBo.getPayOrderId());
        createUnfiedBo.setParaMap(payProQueryPayParaBusiRspBo.getDetailAttrs());
        createUnfiedBo.setPayMethod(payMethod);
        createUnfiedBo.setSpbillCreateIp(reqBo.getCreateIpAddress());
        createUnfiedBo.setBody(reqBo.getDetailName());
    }

    private String getPayMethodByReqWay(String reqWay) {
        String payMethodTemp = null;
        if ("2".equals(reqWay)) {
            payMethodTemp = "12";
        } else if ("4".equals(reqWay)) {
            payMethodTemp = "14";
        } else if ("5".equals(reqWay)) {
            payMethodTemp = "15";
        }
        return payMethodTemp;
    }

    private void sortTransBo(PayProWxJsapiCombReqBo reqBo, String payMethod, PayProPreparedOrderCombRspBo createOrderRetBo, PayProCreateOrderPayTransBusiReqBo createTransBo) {
        createTransBo.setOrderId(Long.valueOf(Long.parseLong(createOrderRetBo.getOrderId())));
        createTransBo.setBusiId(createOrderRetBo.getBusiId());
        createTransBo.setMerchantId(Long.valueOf(Long.parseLong(reqBo.getMerchantId())));
        createTransBo.setPayFee(Long.valueOf(Long.parseLong(reqBo.getTotalFee())));
        createTransBo.setPayMethod(Long.valueOf(Long.parseLong(payMethod)));
    }

    private void sortCreateOrderBo(PayProWxJsapiCombReqBo reqBo, PayProPreparedOrderCombReqBo createOrderBo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)createOrderBo);
    }

    private String validateArg(PayProWxJsapiCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            Long.parseLong(reqBo.getMerchantId());
        }
        catch (NumberFormatException e) {
            return "merchantId\u5fc5\u987b\u4e3a\u6570\u5b57";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "outOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "totalFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            Long.parseLong(reqBo.getTotalFee());
        }
        catch (NumberFormatException e) {
            return "totalFee\u5fc5\u987b\u4e3a\u6570\u5b57";
        }
        String reqWay = reqBo.getReqWay();
        if (StringUtils.isEmpty((Object)reqWay)) {
            return "reqWay\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String supportReqWay = "2,4,5";
        if (!("2".equals(reqWay) || "4".equals(reqWay) || "5".equals(reqWay))) {
            return "\u65e0\u6548\u7684reqWay\uff0c\u5fc5\u987b\u4e3a\uff08" + supportReqWay + "\uff09\u4e2d\u7684\u4e00\u4e2a";
        }
        if ("4".equals(reqWay) || "5".equals(reqWay)) {
            if (StringUtils.isEmpty((Object)reqBo.getCreateIpAddress())) {
                return "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\uff0c\u516c\u4f17\u53f7\u652f\u4ed8\u65f6\uff0ccreateIpAddress\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBo.getOpenId())) {
                return "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\uff0c\u516c\u4f17\u53f7\u652f\u4ed8\u65f6\uff0copenId\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if ("5".equals(reqWay) && StringUtils.isEmpty((Object)reqBo.getAppletAppId())) {
            return "\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u65f6\uff0cappletAppId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("2".equals(reqWay) && StringUtils.isEmpty((Object)reqBo.getAppPayAppId())) {
            return "APP\u652f\u4ed8\u65f6\uff0cappPayAppId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getNotifyUrl()) || reqBo.getNotifyUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getNotifyUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "notifyUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        return null;
    }
}

