/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.UnionAcpPayBusiService;
import com.tydic.payment.pay.busi.bo.UnionAcpPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionAcpPayBusiServiceImpl
implements UnionAcpPayBusiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ENCODING = "UTF-8";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Resource
    FileClient fileClient;

    public UnionAcpPayBusiRspBO dealUnionAcpPay(UnionAcpPayBusiReqBO reqBO) {
        this.logger.debug("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u5165\u53c2\uff1a{}", (Object)reqBO);
        PorderPo order = this.getOrder(reqBO.getOrderId());
        Date createTime = this.queryDBDateBusiService.getDBDate();
        String payOrderId = this.createOrderPayTrans(order, reqBO, createTime);
        this.loadProperties(reqBO);
        Map<String, String> requestData = this.buildRequestData(order, reqBO, payOrderId, createTime);
        Map submitFromData = AcpService.sign(requestData, (String)ENCODING);
        String requestFrontUrl = SdkConfig.getConfig().getFrontRequestUrl();
        String html = AcpService.createAutoFormHtml((String)requestFrontUrl, (Map)submitFromData, (String)ENCODING);
        this.logger.debug("\u6253\u5370\u8bf7\u6c42HTML\uff0c\u6b64\u4e3a\u8bf7\u6c42\u62a5\u6587\uff0c\u4e3a\u8054\u8c03\u6392\u67e5\u95ee\u9898\u7684\u4f9d\u636e\uff1a" + html);
        UnionAcpPayBusiRspBO rspBO = new UnionAcpPayBusiRspBO();
        rspBO.setAcpHtml(html);
        rspBO.setPayOrderId(payOrderId);
        rspBO.setPayStatus(order.getOrderStatus());
        rspBO.setRspCode("0000");
        rspBO.setRspName("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u4e0b\u5355\u6210\u529f\uff0c\u8bf7\u8df3\u8f6c\u5230\u94f6\u8054\u6536\u94f6\u53f0");
        return rspBO;
    }

    private Map<String, String> buildRequestData(PorderPo order, UnionAcpPayBusiReqBO reqBO, String payOrderId, Date createTime) {
        HashMap<String, String> requestData = new HashMap<String, String>(64);
        requestData.put("version", SdkConfig.getConfig().getVersion());
        requestData.put("encoding", ENCODING);
        requestData.put("signMethod", SdkConfig.getConfig().getSignMethod());
        requestData.put("txnType", "01");
        requestData.put("txnSubType", "01");
        requestData.put("bizType", "000201");
        requestData.put("channelType", "07");
        String merId = reqBO.getParamMap().get("merId").toString();
        requestData.put("merId", merId);
        requestData.put("accessType", "0");
        requestData.put("orderId", payOrderId);
        requestData.put("txnTime", DateUtils.dateToStr((Date)createTime, (String)"yyyyMMddHHmmss"));
        requestData.put("currencyCode", "156");
        requestData.put("txnAmt", MoneyUtils.haoToFen((Long)order.getTotalFee()).longValue() + "");
        requestData.put("reqReserved", "");
        requestData.put("riskRateInfo", "{commodityName=}");
        requestData.put("frontUrl", SdkConfig.getConfig().getFrontUrl());
        requestData.put("backUrl", SdkConfig.getConfig().getBackUrl());
        requestData.put("payTimeout", new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis() + 900000L));
        return requestData;
    }

    private void loadProperties(UnionAcpPayBusiReqBO reqBO) {
        Map paramMap = reqBO.getParamMap();
        HashMap<String, String> payParaMap = new HashMap<String, String>(paramMap.size());
        paramMap.forEach((key, value) -> payParaMap.put((String)key, value.toString()));
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, payParaMap);
    }

    private String createOrderPayTrans(PorderPo order, UnionAcpPayBusiReqBO reqBO, Date createTime) {
        PorderPayTransAtomReqBo createReqBO = new PorderPayTransAtomReqBo();
        createReqBO.setOrderId(order.getOrderId());
        createReqBO.setBusiId(order.getBusiId());
        createReqBO.setMerchantId(order.getMerchantId());
        createReqBO.setOrderStatus(order.getOrderStatus());
        createReqBO.setPayMethod(Long.parseLong("110"));
        createReqBO.setPayFee(order.getTotalFee());
        createReqBO.setCreateTime(createTime);
        try {
            return this.porderPayTransAtomService.createOrderPayTrans(createReqBO);
        }
        catch (Exception ex) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38", "\u521b\u5efa\u652f\u4ed8\u6d41\u6c34\u5f02\u5e38", (Throwable)ex);
        }
    }

    private PorderPo getOrder(String orderId) {
        PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(orderId));
        if (pOrder == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if ("A10".equals(pOrder.getOrderStatus())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8");
        }
        return pOrder;
    }
}

