/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractCnncCaiQiTongPayAble;
import com.tydic.payment.pay.payable.impl.transbo.CnncInstrContentBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncInstrReqBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncIssItreasuryBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncRenContentBo;
import com.tydic.payment.pay.util.XmlUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="cnncCaiQiTongRealPayAbleImpl")
public class CnncCaiQiTongRealPayAbleImpl
extends AbstractCnncCaiQiTongPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(CnncCaiQiTongRealPayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.CNNC_CQT_REAL_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        CnncRenContentBo rspContent;
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        String cnncCaiQiTongUrl = this.payPropertiesVo.getValueByKey("cnnc.caiqitong.url");
        log.debug("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u5bf9\u516c\u4ed8\u6b3e\u63a5\u53e3\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)cnncCaiQiTongUrl);
        if (StringUtils.isEmpty((Object)cnncCaiQiTongUrl)) {
            log.error("CNNC\u8d22\u4f01\u901a\u652f\u4ed8\u5730\u5740'cnnc.caiqitong.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("212058");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u652f\u4ed8\u5730\u5740'cnnc.caiqitong.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        String reqStr = this.assembleData(reqBo);
        if (StringUtils.isEmpty((Object)reqStr)) {
            log.error("CNNC\u8d22\u4f01\u901a\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            return retBo;
        }
        HashMap<String, String> reqMap = new HashMap<String, String>(1);
        reqMap.put("_USER_REQUEST_DATA", reqStr);
        String retStr = ((HttpRequest)HttpRequest.post((String)cnncCaiQiTongUrl).contentType("application/x-www-form-urlencoded;charset=GBK").charset("GBK")).form(reqMap).execute().body();
        log.debug("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u5bf9\u516c\u4ed8\u6b3e\u63a5\u53e3\u5b9e\u4ed8\u8bf7\u6c42\u7684\u54cd\u5e94\u8fd4\u56de\u7684xml\u4e3a\uff1a{}", (Object)retStr);
        try {
            CnncIssItreasuryBo cnncIssItreasuryReqBo = (CnncIssItreasuryBo)XmlUtils.xmlToObj(retStr, CnncIssItreasuryBo.class, "GBK");
            rspContent = cnncIssItreasuryReqBo.getInstrRen().getRenContent().get(0);
        }
        catch (Exception e) {
            log.error("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u5bf9\u516c\u652f\u4ed8\u63a5\u53e3\u5b9e\u4ed8\u901a\u8baf\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u4e3a\uff1a{}", (Object)e.getMessage());
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u5bf9\u516c\u652f\u4ed8\u63a5\u53e3\u5b9e\u4ed8\u901a\u8baf\u5931\u8d25");
            return retBo;
        }
        if ("02".equals(rspContent.getStatusNo())) {
            log.error("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u5bf9\u516c\u652f\u4ed8\u63a5\u53e3\u5b9e\u4ed8\u63a5\u6536\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)rspContent.getStatusDec());
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u5bf9\u516c\u652f\u4ed8\u63a5\u53e3\u5b9e\u4ed8\u63a5\u6536\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rspContent.getStatusDec());
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setPayResultCode("SUBMITTED");
        retBo.setPayResultMsg("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u5b9e\u4ed8\u63d0\u4ea4\u6210\u529f");
        return retBo;
    }

    private String assembleData(PayAbleDealPayReqBo reqBo) {
        Map paraMap = reqBo.getParaMap();
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        CnncIssItreasuryBo Iss_Itreasury = new CnncIssItreasuryBo();
        CnncInstrReqBo InstrReq = new CnncInstrReqBo();
        ArrayList<CnncInstrContentBo> InstrContent = new ArrayList<CnncInstrContentBo>();
        Iss_Itreasury.setInstrReq(InstrReq);
        InstrReq.setOperationType("1");
        InstrReq.setSystemID(CNNC_CAI_QI_TONG_SYSTEM_ID);
        String applyCode = CNNC_CAI_QI_TONG_SYSTEM_ID + reqBo.getPayOrderId();
        InstrReq.setBatchCode(applyCode);
        InstrReq.setInstrContent(InstrContent);
        CnncInstrContentBo content = new CnncInstrContentBo();
        InstrContent.add(content);
        content.setApplyCode(applyCode);
        content.setAmount(MoneyUtils.fenToYuanToString((BigDecimal)new BigDecimal(reqBo.getPayFee())));
        Date nowTime = this.payMethodMapper.getDBDate().getDate();
        DateTime nowDateTime = new DateTime((Object)nowTime);
        content.setExcuteDate(nowDateTime.toString("yyyy-MM-dd"));
        content.setClientName(reqDataBo.getCnncPayeeAcctName());
        content.setPayerAcctNo(reqDataBo.getCnncPayeeAcctNo());
        content.setPayeeAcctNo((String)paraMap.get("cnncPayeeAcctNo"));
        content.setPayeeAcctName((String)paraMap.get("cnncPayeeAcctName"));
        content.setRemitProvince((String)paraMap.get("cnncRemitProvince"));
        content.setRemitCity((String)paraMap.get("cnncRemitCity"));
        Boolean internalTransfer = content.getPayeeAcctNo().indexOf("-") == -1 || reqDataBo.getCnncPayeeAcctNo().indexOf("-") == -1;
        if (internalTransfer.booleanValue()) {
            content.setTransType("YHFK");
            content.setRemitBankName((String)paraMap.get("cnncRemitBankName"));
            content.setRemitBankCNAPS((String)paraMap.get("cnncRemitBankCNAPS"));
        } else {
            content.setTransType("NBZZ");
        }
        content.setConfirmTime(nowDateTime.toString("yyyy-MM-dd HH:mm:ss"));
        content.setConfirmUser(reqDataBo.getCnncCommitter());
        content.setNote(reqBo.getDetailName());
        log.debug("\u7ec4\u88c5\u5b8c\u6210\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)Iss_Itreasury));
        String xmlStr = null;
        try {
            xmlStr = XmlUtils.objToXml(Iss_Itreasury, "GBK");
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6cXML\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return xmlStr;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getPayFee()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        if (StringUtils.isEmpty((Object)reqDataBo.getCnncPayeeAcctNo())) {
            return "\u6269\u5c55\u5165\u53c2'busiReqData\u2018\u4e2d\u7684'cnncPayeeAcctNo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getCnncPayeeAcctName())) {
            return "\u6269\u5c55\u5165\u53c2'busiReqData\u2018\u4e2d\u7684'cnncPayeeAcctName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getCnncCommitter())) {
            return "\u6269\u5c55\u5165\u53c2'busiReqData\u2018\u4e2d\u7684'cnncCommitter'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paramMap = reqBo.getParaMap();
        if (StringUtils.isEmpty(paramMap.get("cnncCommitter"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'cnncCommitter'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return super.validateParamArgs(paramMap);
    }
}

