/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.tydic.payment.pay.atom.PayQryStayCloseTransAtomService;
import com.tydic.payment.pay.atom.bo.PayQryStayCloseTransAtomReqBO;
import com.tydic.payment.pay.atom.bo.PayQryStayCloseTransAtomRspBO;
import com.tydic.payment.pay.dao.PayProOrderQueryMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PayProOrderQueryPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.icbc.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="payQryStayCloseTransAtomService")
public class PayQryStayCloseTransAtomServiceImpl
implements PayQryStayCloseTransAtomService {
    @Resource
    private PayProOrderQueryMapper payProOrderQueryMapper;
    @Resource
    private PorderPayTransMapper porderPayTransMapper;

    @Override
    public PayQryStayCloseTransAtomRspBO qryStayClose(PayQryStayCloseTransAtomReqBO reqBO) {
        PayQryStayCloseTransAtomRspBO rspBO = new PayQryStayCloseTransAtomRspBO();
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u5931\u8d25");
        String validResult = this.validParam(reqBO);
        if (!StringUtils.isEmpty((String)validResult)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", validResult);
        }
        List<PorderPayTransPo> pOrderPayTransPos = new ArrayList<PorderPayTransPo>();
        rspBO.setTransPos(pOrderPayTransPos);
        if (!StringUtils.isEmpty((String)reqBO.getOutOrderId())) {
            PayProOrderQueryPo payProOrderQueryPo = new PayProOrderQueryPo();
            payProOrderQueryPo.setOutOrderId(reqBO.getOutOrderId());
            List<PayProOrderQueryPo> payProOrderQueryPos = this.payProOrderQueryMapper.queryOrderQueryByCondition(payProOrderQueryPo);
            if (payProOrderQueryPos.isEmpty()) {
                return rspBO;
            }
            Long orderId = payProOrderQueryPos.get(0).getOrderId();
            PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
            porderPayTransPo.setOrderId(orderId);
            pOrderPayTransPos = this.porderPayTransMapper.queryOrderPayTrans(porderPayTransPo);
        } else if (StringUtils.isEmpty((String)reqBO.getOutOrderId()) && !StringUtils.isEmpty((String)reqBO.getOrderId())) {
            PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
            porderPayTransPo.setOrderId(Long.valueOf(reqBO.getOrderId()));
            pOrderPayTransPos = this.porderPayTransMapper.getOrderPayTransByCondition(porderPayTransPo);
        }
        if (!pOrderPayTransPos.isEmpty()) {
            List<PorderPayTransPo> payingTransPos = pOrderPayTransPos.stream().filter(bo -> bo.getOrderStatus().equals("A00")).collect(Collectors.toList());
            rspBO.setTransPos(payingTransPos);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private String validParam(PayQryStayCloseTransAtomReqBO reqBO) {
        if (reqBO == null) {
            return "\u5f85\u5173\u95ed\u652f\u4ed8\u5355\u67e5\u8be2\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)reqBO.getOutOrderId()) && StringUtils.isEmpty((String)reqBO.getOrderId())) {
            return "\u5f85\u5173\u95ed\u652f\u4ed8\u5355\u67e5\u8be2\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u3010outOrderId\u3011\u548c\u3010orderId\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
        }
        return null;
    }
}

