/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayInfoContractCreateBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayInfoContractCreateBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractCreateBusiRspBo;
import com.tydic.payment.pay.dao.PayInfoContractMapper;
import com.tydic.payment.pay.dao.po.PayInfoContractPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payInfoContractCreateBusiService")
public class PayInfoContractCreateBusiServiceImpl
implements PayInfoContractCreateBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayInfoContractMapper payInfoContractMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public PayInfoContractCreateBusiRspBo crateContract(PayInfoContractCreateBusiReqBo reqBo) {
        this.LOGGER.info("\u521b\u5efa\u6263\u6b3e\u534f\u8baebusi\u670d\u52a1\uff1a" + reqBo);
        PayInfoContractCreateBusiRspBo retBo = new PayInfoContractCreateBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespDesc("212049");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        PayInfoContractPo po = new PayInfoContractPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        Date nowTime = this.queryDBDateBusiService.getDBDate();
        po.setCreateTime(nowTime);
        try {
            po.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
            po.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
            po.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
            po.setSingleAmount(Long.valueOf(reqBo.getSingleAmount()));
            po.setContractStatus(Long.valueOf(reqBo.getContractStatus()));
        }
        catch (Exception e) {
            this.LOGGER.error("\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("216032", "\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff1a" + e);
        }
        int result = this.payInfoContractMapper.insert(po);
        if (result < 1) {
            this.LOGGER.error("\u5199\u534f\u8bae\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("212049");
            retBo.setRespDesc("\u6dfb\u52a0\u534f\u8bae\u4fe1\u606f\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayInfoContractCreateBusiReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo)) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContractId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'contractId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'orderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'outOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paymentInsId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payMethod'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getProductCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'productCode'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getSingleAmount())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'singleAmount'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContractStatus())) {
            reqBo.setContractStatus("0");
        }
        return null;
    }
}

