/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.PayProProcessNotifyBusiService;
import com.tydic.payment.pay.busi.bo.PayProProcessNotifyBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProProcessNotifyBusiRspBo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payProProcessNotifyBusiService")
public class PayProProcessNotifyBusiServiceImpl
implements PayProProcessNotifyBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PorderMapper porderMapper;

    public PayProProcessNotifyBusiRspBo updateOrder(PayProProcessNotifyBusiReqBo reqBo) {
        PayProProcessNotifyBusiRspBo rspBo = new PayProProcessNotifyBusiRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("212030");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        String payOrderId = reqBo.getPayOrderId();
        orderPayTransAtomReq.setPayOrderId(payOrderId);
        List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
        if (transAtomList == null || transAtomList.isEmpty()) {
            this.LOGGER.error("\u652f\u4ed8\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010payOrderId={}\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e", (Object)payOrderId);
            rspBo.setRespCode("212030");
            rspBo.setRespDesc("\u652f\u4ed8\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010payOrderId=" + payOrderId + "\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
            return rspBo;
        }
        PorderPayTransAtomRspBo payTransPo = transAtomList.get(0);
        Long orderId = payTransPo.getOrderId();
        rspBo.setOrderId(orderId);
        if ("A10".equals(payTransPo.getOrderStatus())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u652f\u4ed8\u6210\u529f");
            return rspBo;
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (orderInfo == null) {
            this.LOGGER.info("\u652f\u4ed8\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010orderId={}\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e", (Object)orderId);
            rspBo.setRespCode("212030");
            rspBo.setRespDesc("\u652f\u4ed8\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
            return rspBo;
        }
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        orderInfo.setTradeTime(reqBo.getTradeTime());
        orderInfo.setOrderStatus("A10");
        orderInfo.setUpdateTime(dbDate);
        int updateOrderCount = this.porderMapper.update(orderInfo);
        if (updateOrderCount < 1) {
            throw new BusinessException("216028", "\u652f\u4ed8\u6210\u529f\u56de\u8c03\u5904\u7406busi\u670d\u52a1\u5f02\u5e38\uff0c\u66f4\u65b0p_order\u8fd4\u56de\u6570\u636e\u5c0f\u4e8e1");
        }
        PorderPayTransPo updateTransPo = new PorderPayTransPo();
        updateTransPo.setOrderId(orderId);
        updateTransPo.setPayOrderId(payOrderId);
        updateTransPo.setOrderStatus("A10");
        updateTransPo.setTradeTime(reqBo.getTradeTime());
        updateTransPo.setPayNotifyTransId(reqBo.getPayNotifyTransId());
        updateTransPo.setPayMethod(reqBo.getPayMethod());
        updateTransPo.setUpdateTime(dbDate);
        int updateTransCount = this.porderPayTransMapper.update(updateTransPo);
        if (updateTransCount < 1) {
            throw new BusinessException("216028", "\u652f\u4ed8\u6210\u529f\u56de\u8c03\u5904\u7406busi\u670d\u52a1\u5f02\u5e38\uff0c\u66f4\u65b0p_order_pay_trans\u8fd4\u56de\u6570\u636e\u5c0f\u4e8e1");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String validateArg(PayProProcessNotifyBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayNotifyTransId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PayNotifyTransId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PayMethod\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PayOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTradeTime())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027TradeTime\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

