/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PayQueryDivideDetailService;
import com.tydic.payment.pay.atom.bo.PayQueryDivideDetailReqBO;
import com.tydic.payment.pay.atom.bo.PayQueryDivideDetailRspBO;
import com.tydic.payment.pay.dao.PRelOrderParamMapper;
import com.tydic.payment.pay.dao.po.PRelOrderParamPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.payable.impl.transbo.DivideDataBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="payQueryDivideDetailService")
public class PayQueryDivideDetailServiceImpl
implements PayQueryDivideDetailService {
    private static final Logger log = LoggerFactory.getLogger(PayQueryDivideDetailServiceImpl.class);
    @Autowired
    private PRelOrderParamMapper pRelOrderParamMapper;
    private static final String DEAL_DIVIDE = "DEAL_DIVIDE";

    @Override
    public PayQueryDivideDetailRspBO queryDivideDetail(PayQueryDivideDetailReqBO reqBO) {
        PayQueryDivideDetailRspBO rspBO = new PayQueryDivideDetailRspBO();
        String checkResult = this.checkReqParam(reqBO);
        if (!StringUtils.isEmpty((String)checkResult)) {
            log.error("------------\u67e5\u8be2\u660e\u7ec6\u5165\u53c2\u5f02\u5e38----------------");
            throw new BusinessException("8888", checkResult);
        }
        PRelOrderParamPO relOrderParamPO = new PRelOrderParamPO();
        relOrderParamPO.setOrderId(Long.valueOf(reqBO.getOrderId()));
        relOrderParamPO.setParamKey(DEAL_DIVIDE);
        relOrderParamPO.setStatus(1);
        List<PRelOrderParamPO> list = this.pRelOrderParamMapper.getList(relOrderParamPO);
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        PRelOrderParamPO resultPo = list.get(0);
        String text = resultPo.getText();
        if (StringUtils.isEmpty((String)text)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        List divideDataBOS = JSON.parseArray((String)text, DivideDataBO.class);
        if (CollectionUtils.isEmpty((Collection)divideDataBOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        List collect = divideDataBOS.stream().filter(bo -> bo.getMerchantNo().equals(reqBO.getMerchantId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        DivideDataBO dataBO = (DivideDataBO)collect.get(0);
        BeanUtils.copyProperties((Object)dataBO, (Object)((Object)rspBO));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String checkReqParam(PayQueryDivideDetailReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)reqBO.getOrderId())) {
            return "\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)reqBO.getMerchantId())) {
            return "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

