/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayProCacheManager {
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    private Set<String> cachedSet = new CopyOnWriteArraySet<String>();
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private int cacheTime = 15;

    @PostConstruct
    public void init() {
        String cacheStr = this.payPropertiesVo.getValueByKey("pay.cache.time");
        if (cacheStr != null && !"".equals(cacheStr)) {
            this.cacheTime = Integer.parseInt(cacheStr);
        }
        if ("1".equals(this.payPropertiesVo.getValueByKey("pay.cache.enable"))) {
            this.LOGGER.debug("\u9ad8\u9891\u67e5\u8be2\uff0c\u9700\u8981\u4f7f\u7528\u7f13\u5b58");
        } else {
            this.LOGGER.debug("\u9ad8\u9891\u67e5\u8be2\uff0c\u4e0d\u9700\u8981\u4f7f\u7528\u7f13\u5b58");
        }
    }

    public <T> T get(String key, Class<T> clazz) {
        if (!"1".equals(this.payPropertiesVo.getValueByKey("pay.cache.enable"))) {
            return null;
        }
        return (T)this.cacheClient.get(key, clazz);
    }

    public void set(String key, Object obj, boolean cachedKey, Integer expireTime) {
        if ("1".equals(this.payPropertiesVo.getValueByKey("pay.cache.enable"))) {
            if (expireTime != null) {
                this.cacheClient.set(key, obj, expireTime.intValue());
            } else {
                this.cacheClient.set(key, obj, this.cacheTime * 60);
            }
            if (cachedKey) {
                this.cachedSet.add(key);
            }
            this.LOGGER.debug("PayProCacheManager.set\u65b9\u6cd5\uff0c\u7f13\u5b58\u6570\u636e\u5230redis\uff0ckey\u4e3a\uff1a" + key);
        }
    }

    public void clearCache() {
        for (String cacheKey : this.cachedSet) {
            this.cacheClient.delete(cacheKey);
        }
        this.cachedSet.clear();
    }
}

