/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.chinapay.util;

import com.tydic.payment.pay.chinapay.util.SecssConfig;
import com.tydic.payment.pay.chinapay.util.SecssConstants;
import com.tydic.payment.pay.chinapay.util.SecssUtil;
import com.tydic.payment.pay.chinapay.util.SecurityException;
import com.tydic.payment.pay.sdk.unionpay.LogUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtil {
    private KeyStore keyStore;
    private X509Certificate verifyCert;
    private PrivateKey priKey;
    private PublicKey pubKey;
    private String signCertId;
    private SecssConfig secssConfig;

    private CertUtil() {
    }

    public SecssConfig getSecssConfig() {
        return this.secssConfig;
    }

    public static synchronized CertUtil init() throws SecurityException {
        CertUtil certUtil = new CertUtil();
        certUtil.secssConfig = SecssConfig.defaultInit();
        certUtil.initSignCert();
        certUtil.initVerifyCert();
        return certUtil;
    }

    public static synchronized CertUtil init(Properties pros) throws SecurityException {
        CertUtil certUtil = new CertUtil();
        certUtil.secssConfig = SecssConfig.specifyInit(pros);
        certUtil.initSignCert();
        certUtil.initVerifyCert();
        return certUtil;
    }

    public void initSignCert() throws SecurityException {
        try {
            String signFile = this.secssConfig.getSignFile();
            if (SecssUtil.isEmpty(signFile)) {
                throw new SecurityException(SecssConstants.SIGN_CERT_ERROR);
            }
            String signFilePwd = this.secssConfig.getSignFilePwd();
            if (SecssUtil.isEmpty(signFilePwd)) {
                throw new SecurityException(SecssConstants.SIGN_CERT_PWD_ERROR);
            }
            String signCertType = this.secssConfig.getSignCertType();
            if (SecssUtil.isEmpty(signCertType)) {
                throw new SecurityException(SecssConstants.SIGN_CERT_TYPE_ERROR);
            }
            this.keyStore = this.getKeyStore(signFile, signFilePwd, signCertType);
            this.initPriKey();
        }
        catch (SecurityException var4) {
            throw var4;
        }
        catch (Exception var5) {
            LogUtil.writeErrorLog("init sign cert error", var5);
            throw new SecurityException(SecssConstants.INIT_SIGN_CERT_ERROR);
        }
    }

    public void initVerifyCert() throws SecurityException {
        String verifyFile = this.secssConfig.getVerifyFile();
        if (SecssUtil.isEmpty(verifyFile)) {
            throw new SecurityException(SecssConstants.VERIFY_CERT_ERROR);
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(verifyFile);
            this.verifyCert = (X509Certificate)cf.generateCertificate(in);
            this.pubKey = this.verifyCert.getPublicKey();
            this.initPubKey();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception var17) {
            LogUtil.writeErrorLog("\u521d\u59cb\u5316\u9a8c\u7b7e\u8bc1\u4e66\u5f02\u5e38", var17);
            throw new SecurityException(SecssConstants.INIT_VERIFY_CERT_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void reloadSignCert(String certPath, String pass) throws SecurityException {
        try {
            String signCertType = this.secssConfig.getSignCertType();
            if (SecssUtil.isEmpty(signCertType)) {
                throw new SecurityException(SecssConstants.SIGN_CERT_TYPE_ERROR);
            }
            this.keyStore = this.getKeyStore(certPath, pass, signCertType);
        }
        catch (SecurityException var4) {
            throw var4;
        }
        catch (Exception var5) {
            throw new SecurityException(SecssConstants.RELOADSC_GOES_WRONG);
        }
    }

    public KeyStore getKeyStore(String signFile, String signFilePwd, String signFileType) throws SecurityException, Exception {
        try {
            LogUtil.writeLog(String.format("signFile=%s,signFileType=%s", signFile, signFileType));
            KeyStore ks = null;
            if ("JKS".equals(signFileType)) {
                ks = KeyStore.getInstance(signFileType, "SUN");
            } else {
                if (!"PKCS12".equals(signFileType)) {
                    throw new SecurityException(SecssConstants.SIGN_CERT_TYPE_ERROR);
                }
                Security.addProvider((Provider)new BouncyCastleProvider());
                ks = KeyStore.getInstance(signFileType);
            }
            FileInputStream fis = new FileInputStream(signFile);
            char[] nPassword = null;
            nPassword = SecssUtil.isEmpty(signFilePwd) ? null : signFilePwd.toCharArray();
            ks.load(fis, nPassword);
            fis.close();
            return ks;
        }
        catch (SecurityException var7) {
            throw var7;
        }
        catch (Exception var8) {
            if (var8 instanceof KeyStoreException && "PKCS12".equals(signFileType)) {
                Security.removeProvider("BC");
            }
            throw var8;
        }
    }

    protected void initPriKey() throws SecurityException {
        try {
            Enumeration<String> aliasenum = this.keyStore.aliases();
            String keyAlias = null;
            while (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
                LogUtil.writeLog(String.format("keyAlias=%s", keyAlias));
                if (!keyAlias.equals(this.secssConfig.getSignFileAlias())) {
                    this.priKey = (PrivateKey)this.keyStore.getKey(keyAlias, this.secssConfig.getSignFilePwd().toCharArray());
                    if (this.priKey == null) continue;
                }
                break;
            }
        }
        catch (Exception var3) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u79c1\u94a5\u5f02\u5e38", var3);
            throw new SecurityException(SecssConstants.GET_PRI_KEY_ERROR);
        }
    }

    public String getSignCertId() throws SecurityException {
        try {
            Enumeration<String> aliasenum = this.keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(keyAlias);
            this.signCertId = cert.getSerialNumber().toString();
            return this.signCertId;
        }
        catch (Exception var4) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u8bc1\u4e66\u7f16\u53f7\u5f02\u5e38", var4);
            throw new SecurityException(SecssConstants.GET_CERT_ID_ERROR);
        }
    }

    protected void initPubKey() {
        this.pubKey = this.verifyCert.getPublicKey();
    }

    public PrivateKey getPriKey() {
        return this.priKey;
    }

    public PublicKey getPubKey() {
        return this.pubKey;
    }
}

