/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.common.util;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bo.ParseAbliyRspBo;
import com.tydic.payment.pay.common.util.ParseInfo;
import com.tydic.payment.pay.common.util.Utils;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ParseAbilityResponse {
    private static final String SUCCESS = "00000";
    private static final Logger log = LoggerFactory.getLogger(ParseAbilityResponse.class);

    public static ParseInfo getRspBodyInfo(String reqStr, String node) {
        log.info("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\uff1a" + reqStr);
        ParseInfo parseInfo = new ParseInfo();
        if (StringUtils.isEmpty((Object)reqStr)) {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg("\u5fae\u4fe1\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
            return parseInfo;
        }
        JSONObject resultObj = JSONObject.parseObject((String)reqStr);
        JSONObject rspHeadInfo = resultObj.getJSONObject("UNI_BSS_HEAD");
        if (rspHeadInfo == null) {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_HEAD\u3011\u8282\u70b9\u4e3a\u7a7a");
            return parseInfo;
        }
        String rsp_code = rspHeadInfo.getString("RESP_CODE");
        if (rsp_code == null) {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u5934\u90e8\u4e2d\u7684\u54cd\u5e94\u7f16\u7801\u3010RESP_CODE\u3011\u8282\u70b9\u4e3a\u7a7a");
            return parseInfo;
        }
        if (!SUCCESS.equals(rsp_code)) {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg(rspHeadInfo.getString("RESP_DESC"));
            return parseInfo;
        }
        JSONObject rspBodyInfo = resultObj.getJSONObject("UNI_BSS_BODY");
        if (rspBodyInfo == null) {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_BODY\u3011\u8282\u70b9\u4e3a\u7a7a");
            return parseInfo;
        }
        JSONObject infoDetail = rspBodyInfo.getJSONObject(node);
        if (infoDetail == null) {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010" + node + "\u3011\u8282\u70b9\u4e3a\u7a7a");
            return parseInfo;
        }
        parseInfo.setJsonInfo(infoDetail);
        String return_code = infoDetail.getString("RETURN_CODE");
        if (StringUtils.isEmpty((Object)return_code) || !"SUCCESS".equals(return_code)) {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg(infoDetail.getString("RETURN_MSG"));
            return parseInfo;
        }
        String result_code = infoDetail.getString("RESULT_CODE");
        if (!StringUtils.isEmpty((Object)result_code) && "SUCCESS".equals(result_code)) {
            parseInfo.setRsp_code("0000");
            parseInfo.setRsp_msg("\u6210\u529f");
        } else {
            parseInfo.setRsp_code("8888");
            parseInfo.setRsp_msg(infoDetail.getString("ERR_CODE_DES"));
        }
        return parseInfo;
    }

    public static ParseAbliyRspBo parseRspBodyInfo(String reqStr, String node) {
        ParseAbliyRspBo retBo = new ParseAbliyRspBo();
        if (StringUtils.isEmpty((Object)reqStr)) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            return retBo;
        }
        JSONObject resultObj = JSONObject.parseObject((String)reqStr);
        JSONObject rspHeadInfo = resultObj.getJSONObject("UNI_BSS_HEAD");
        if (rspHeadInfo == null) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_HEAD\u3011\u8282\u70b9\u4e3a\u7a7a");
            return retBo;
        }
        String rsp_code = rspHeadInfo.getString("RESP_CODE");
        if (rsp_code == null) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u5934\u90e8\u4e2d\u7684\u54cd\u5e94\u7f16\u7801\u3010RESP_CODE\u3011\u8282\u70b9\u4e3a\u7a7a");
            return retBo;
        }
        if (!SUCCESS.equals(rsp_code)) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff1a" + rspHeadInfo.getString("RESP_DESC"));
            return retBo;
        }
        JSONObject rspBodyInfo = resultObj.getJSONObject("UNI_BSS_BODY");
        if (rspBodyInfo == null) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_BODY\u3011\u8282\u70b9\u4e3a\u7a7a");
            return retBo;
        }
        JSONObject infoDetail = rspBodyInfo.getJSONObject(node);
        if (infoDetail == null) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010" + node + "\u3011\u8282\u70b9\u4e3a\u7a7a");
            return retBo;
        }
        retBo.setRspCode("0000");
        retBo.setRspName("\u89e3\u6790\u6210\u529f");
        retBo.setRetData(infoDetail);
        return retBo;
    }

    public static <T> T parseAbilityRspToBean(String reqStr, String node, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)reqStr)) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        JSONObject resultObj = JSONObject.parseObject((String)reqStr);
        JSONObject rspHeadInfo = resultObj.getJSONObject("UNI_BSS_HEAD");
        if (rspHeadInfo == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_HEAD\u3011\u8282\u70b9\u4e3a\u7a7a");
        }
        String rsp_code = rspHeadInfo.getString("RESP_CODE");
        if (rsp_code == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u5934\u90e8\u4e2d\u7684\u54cd\u5e94\u7f16\u7801\u3010RESP_CODE\u3011\u8282\u70b9\u4e3a\u7a7a");
        }
        if (!SUCCESS.equals(rsp_code)) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff1a" + rspHeadInfo.getString("RESP_DESC"));
        }
        JSONObject rspBodyInfo = resultObj.getJSONObject("UNI_BSS_BODY");
        if (rspBodyInfo == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_BODY\u3011\u8282\u70b9\u4e3a\u7a7a");
        }
        JSONObject infoDetail = rspBodyInfo.getJSONObject(node);
        if (infoDetail == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010" + node + "\u3011\u8282\u70b9\u4e3a\u7a7a");
        }
        try {
            Map<String, Object> map = Utils.createHumpMap((Map<String, Object>)infoDetail);
            T bean = clazz.newInstance();
            BeanUtils.populate(bean, map);
            log.info("\u8f6c\u6210\u7684bean\uff1a" + bean);
            return bean;
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
    }

    public static <T> T parseJsonToMap(JSONObject jsonObject, Class<T> clazz, boolean keyToLowerCaseFlag) throws Exception {
        Object map = new HashMap();
        map = keyToLowerCaseFlag ? Utils.mapKeytoLowerCase((Map<String, Object>)jsonObject) : jsonObject;
        T bean = clazz.newInstance();
        BeanUtils.populate(bean, (Map)map);
        log.info("\u8f6c\u6210\u7684bean\uff1a" + bean);
        return bean;
    }
}

