/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.wopay.util;

import ccit.security.bssp.CAUtility;
import ccit.security.bssp.util.Resource;
import com.tydic.payment.pay.wopay.util.Constants;
import com.tydic.payment.pay.wopay.util.RequestBaseBean;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniPaySignUtilsCer {
    private static Logger logger = LoggerFactory.getLogger(UniPaySignUtilsCer.class);

    public static String merSign(Map<String, String> reqMap, String signType, boolean isIssue) {
        String signResult = null;
        if (!Constants.SIGN_TYPE_DICT.contains(signType)) {
            logger.info("\u4e0d\u652f\u6301\u6b64\u7b7e\u540d\u7c7b\u578b:" + signType);
        } else if ("RSA_SHA256".equals(signType) || "SM2_SM3".equals(signType)) {
            try {
                signResult = UniPaySignUtilsCer.rsaOrSm2Sign(UniPaySignUtilsCer.getSignSourMsg(reqMap, isIssue), signType);
            }
            catch (Exception e) {
                logger.error("\u5546\u6237\u7528\u975e\u5bf9\u79f0\u52a0\u5bc6\u65b9\u5f0f\u7b7e\u540d-\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            }
        }
        return signResult;
    }

    public static String merSign(Map<String, String> reqMap, String signType) {
        return UniPaySignUtilsCer.merSign(reqMap, signType, false);
    }

    public static String merSign(Map<String, String> reqMap, String signType, boolean isIssue, byte[] P12cert, String pincode) {
        String signResult = null;
        if (!Constants.SIGN_TYPE_DICT.contains(signType)) {
            logger.info("\u4e0d\u652f\u6301\u6b64\u7b7e\u540d\u7c7b\u578b:" + signType);
        } else if ("RSA_SHA256".equals(signType) || "SM2_SM3".equals(signType)) {
            try {
                signResult = UniPaySignUtilsCer.rsaOrSm2SignFile(UniPaySignUtilsCer.getSignSourMsg(reqMap, isIssue), signType, P12cert, pincode);
            }
            catch (Exception e) {
                logger.error("\u5546\u6237\u7528\u975e\u5bf9\u79f0\u52a0\u5bc6\u65b9\u5f0f\u7b7e\u540d-\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            }
        }
        return signResult;
    }

    public static boolean merVerify(Map<String, String> reqMap, String signType, String signMsg, String cert, boolean isIssue) {
        if (!Constants.SIGN_TYPE_DICT.contains(signType)) {
            logger.info("\u4e0d\u652f\u6301\u6b64\u7b7e\u540d\u7c7b\u578b:" + signType);
            return false;
        }
        try {
            return UniPaySignUtilsCer.rsaOrSm2Verify(UniPaySignUtilsCer.getSignSourMsg(reqMap, isIssue), signMsg, signType, cert);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean merVerify(Map<String, String> reqMap, String signType, String signMsg, String cert) {
        return UniPaySignUtilsCer.merVerify(reqMap, signType, signMsg, cert, false);
    }

    private static String getSignSourMsg(Map<String, String> params, boolean isIssue) {
        params = UniPaySignUtilsCer.filterNoParams(params);
        String signSource = UniPaySignUtilsCer.createLinkString(params, isIssue);
        logger.info("\u5f85\u7b7e\u540d\u53c2\u6570\u4e32\uff1a" + signSource);
        System.out.println("\u5f85\u7b7e\u540d\u53c2\u6570\u4e32\uff1a" + signSource);
        return signSource;
    }

    private static Map<String, String> filterNoParams(Map<String, String> params) {
        HashMap<String, String> newParam = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("signMsg".equalsIgnoreCase(key) || "cert".equalsIgnoreCase(key) || "hmac".equalsIgnoreCase(key) || value == null || value.length() == 0 || "null".equals(value) || "NULL".equals(value)) continue;
            newParam.put(key, value);
        }
        return newParam;
    }

    private static String createLinkString(Map<String, String> params, boolean isIssue) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            prestr.append(key).append("=").append(params.get(key)).append("|");
        }
        if (isIssue) {
            return prestr.toString();
        }
        return prestr.substring(0, prestr.length() - 1);
    }

    private static boolean rsaOrSm2Verify(String originalData, String signMsg, String algorithm, String cert) throws Exception {
        byte[] indata = originalData.getBytes("UTF-8");
        byte[] certbytes = cert.getBytes("UTF-8");
        byte[] signMsgbytes = signMsg.getBytes("UTF-8");
        logger.info("\u539f\u6570\u636e:[" + originalData + "]");
        logger.info("\u652f\u4ed8\u516c\u53f8\u56de\u8c03\u516c\u94a5:[" + cert + "]");
        logger.info("\u652f\u4ed8\u516c\u53f8\u8fd4\u56de\u7b7e\u540d\u4e32:[" + signMsg + "]");
        int verifyWithCert = 1;
        if ("RSA_SHA256".equalsIgnoreCase(algorithm)) {
            verifyWithCert = CAUtility.verifyWithCert((int)261, (byte[])certbytes, (byte[])indata, (byte[])signMsgbytes);
        } else if ("SM2_SM3".equalsIgnoreCase(algorithm)) {
            verifyWithCert = CAUtility.EccVerifySignByCert((int)260, (byte[])certbytes, (byte[])indata, (byte[])signMsgbytes);
        }
        return verifyWithCert == 0;
    }

    private static String rsaOrSm2Sign(String originalData, String algorithm) throws Exception {
        byte[] indata = originalData.getBytes("UTF-8");
        byte[] signBytes = null;
        signBytes = CAUtility.RsaSignByP12((int)261, (byte[])indata);
        return new String(CAUtility.base64Encode((byte[])signBytes));
    }

    private static String rsaOrSm2SignFile(String originalData, String algorithm, byte[] P12cert, String pincode) throws Exception {
        byte[] indata = originalData.getBytes("UTF-8");
        byte[] signBytes = null;
        signBytes = CAUtility.RsaSignByP12Cert((int)261, (byte[])indata, (byte[])P12cert, (String)pincode);
        return new String(CAUtility.base64Encode((byte[])signBytes));
    }

    public static String toHexString(String s) {
        try {
            byte[] b = s.getBytes();
            String str = " ";
            for (int i = 0; i < b.length; ++i) {
                Integer I = new Integer(b[i]);
                String strTmp = Integer.toHexString(b[i]);
                if (strTmp.length() > 2) {
                    strTmp = strTmp.substring(strTmp.length() - 2);
                }
                str = str + strTmp;
            }
            System.out.println(str);
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        UniPaySignUtilsCer.merSignTest();
    }

    private static void merVerifyTest() {
        String cert = "MIICljCCAYCgAwIBAgIEATb+cTALBgkqhkiG9w0BAQswLzELMAkGA1UEBhMCQ04xIDAeBgNVBAMMF0NISU5BIFVOSUNPTSBDTEFTUzEgQ0ExMB4XDTE2MTIyMTA5NTYzNFoXDTE2MTIyNDA5NTYzNFowJDELMAkGA1UEBhMCQ04xFTATBgNVBAMMDOS9oOWlvVJTQTExMTCBnTALBgkqhkiG9w0BAQEDgY0AMIGJAoGBAKxeaim0jaSqo2KS7KU6lHsVUPGOzC7V7yZoTNYsGzjwy/c/kQLkbU1/MeTnIXPjtkFwyWmZXL2drFbUxZ6eSPRd69OzGfG8dpqEw53wLE5BI0xTLv/wQZyMVcoXAsjX5VYa5IlYDAZhPp5IogtMT9BxtYukeP9o+dXglXEylzrDAgMBAAGjTzBNMB8GA1UdIwQYMBaAFKt7hVVYh97I/vJ2QAPvDBz6gj4vMAsGA1UdDwQEAwIHgDAdBgNVHQ4EFgQUp7Om18jYq6TrNUYiFPChtOl5Z0IwCwYJKoZIhvcNAQELA4IBAQBu+Na/ltAA1lxeG8Q2g+7XeipEwFwpFNu+YLswJqXZbFgT7UbsU5ycpDjmcaAoaAiTdfkG08D9JTsaNOAE+J/6iqN0TLb7/HvV5G3SODPYV9iuoLNNOlWnj6UFoat8rhpHzFcMRlcFdM/jOKU3AK7ze06O5zadjPQq5/1k2BPCaNYb9Umy00J9fSuDmvD6RQt3wL/kY3lQR1yEm5amIUQ2j0ujw9F3wc8A1lmRHw5plVhhkJaLZ/+nMmYEYpv4Cf9Kh7z3lu0fL0dlEf+uWLe8A42tsQOfdjekKqXD9YXNUbM9s6d27DsIfY/8c4LodqPq+Y7FiC3UO28JigNO6FEe";
        String str = "interfaceVersion=1.0.0.0&tranType=DF02&merNo=301100710007122&orderNo=15071519&amount=0&orderDate=20171221&reqTime=20171221140653&transRst=5&transDis=\u65e0\u6b64\u8ba2\u5355&bncCode=&bncDis=&woType=&bncType=&payTime=&payJnlno=&bizCode=&payeeAcc=&payeeBankCode=&payeeBankAcc=&payeeName=&payeeBankBranch=&merExtend=&signType=RSA_SHA256&signMsg=hOCUmiNHnNy/mSKX4CpELKTRMiKY7lm0pe2mnA7CsFinl8IETitVzodYrWhSe9t/m0WO+SnmWaoipIkpSHPI845QYVAXY22zj+y6Yt53X6bwgQ/jmEvxAYQbDeHluEjTwRt7chtp5qzh5SLy/x0Z+GS8BRpKkfDFWCL1mrNn9jA=";
        Map<String, String> map = UniPaySignUtilsCer.rep2Map(str, "\\&", "\\=");
        Boolean re = UniPaySignUtilsCer.merVerify(map, "RSA_SHA256", map.get("signMsg"), cert, true);
        System.out.println("\u9a8c\u7b7e\u7ed3\u679c\uff1a" + re);
    }

    private static void merSignTest() {
        try {
            int len;
            String str = "amount=1|bizCode=017|callbackUrl=http://hb.ly169.cn/daifu/notify.html|interfaceVersion=1.0.0.1|merNo=301100710007122|orderDate=20190121|orderNo=DF20190121144004902|payeeAcc=18500817010|reqIp=127.0.0.1|reqTime=20190121102319|signType=RSA_SHA256|tranType=DF01|woType=3";
            Map<String, String> map = UniPaySignUtilsCer.rep2Map(str, "\\|", "\\=");
            String merNo = map.get("merno") == null ? map.get("merNo") : map.get("merno");
            String filepath = Resource.getValue((String)(merNo != null ? merNo + "_" + ccit.security.bssp.util.Constants.P12_CERT : ccit.security.bssp.util.Constants.P12_CERT));
            String p12pincode = Resource.getValue((String)(merNo != null ? merNo + "_" + ccit.security.bssp.util.Constants.P12_PINCODE : ccit.security.bssp.util.Constants.P12_PINCODE));
            FileInputStream fis = new FileInputStream(UniPaySignUtilsCer.class.getResource(filepath).getFile());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bb = new byte[4096];
            while ((len = fis.read(bb)) != -1) {
                baos.write(bb, 0, len);
            }
            fis.close();
            String signMsg = UniPaySignUtilsCer.merSign(map, map.get("signtype") == null ? map.get("signType") : map.get("signtype"), true, baos.toByteArray(), p12pincode);
            baos.close();
            System.out.println("\u7b7e\u540d\uff1a" + signMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> rep2Map(String str, String dataSplit, String valueSplit) {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        String[] parameters = str.split(dataSplit);
        for (int i = 0; i < parameters.length; ++i) {
            String[] values = parameters[i].split(valueSplit, 2);
            String key = values[0];
            String value = values.length > 1 ? values[1] : "";
            reqMap.put(key, value);
        }
        return reqMap;
    }

    public static String merSign(RequestBaseBean requesBean) throws FileNotFoundException, IOException {
        int len;
        String merNo = requesBean.getMerNo();
        String filepath = "";
        String p12pincode = "";
        FileInputStream fis = new FileInputStream(UniPaySignUtilsCer.class.getResource(filepath).getFile());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bb = new byte[4096];
        while ((len = fis.read(bb)) != -1) {
            baos.write(bb, 0, len);
        }
        fis.close();
        String signMsg = UniPaySignUtilsCer.merSign(UniPaySignUtilsCer.obj2LowerMap(requesBean), requesBean.getSignType(), false, baos.toByteArray(), p12pincode);
        baos.close();
        return signMsg;
    }

    public static Map<String, String> obj2NormalMap(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Class<?> tempClass = obj.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
                fields.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            }
            for (Field filed : fields) {
                filed.setAccessible(true);
                String filedName = filed.getName();
                String filedValue = filed.get(obj) == null ? "" : filed.get(obj).toString();
                String value = (String)map.get(filedName);
                if (value != null && value.length() >= 1) continue;
                map.put(filedName, filedValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
        return map;
    }

    public static Map<String, String> obj2LowerMap(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Class<?> tempClass = obj.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
                fields.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            }
            for (Field filed : fields) {
                filed.setAccessible(true);
                String filedName = filed.getName();
                String filedValue = filed.get(obj) == null ? "" : filed.get(obj).toString();
                String value = (String)map.get(filedName);
                if (value != null && value.length() >= 1) continue;
                map.put(filedName.toLowerCase(), filedValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
        return map;
    }

    public static Map<String, String> obj2MapKeytoLowerCase(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Field[] fields;
            for (Field filed : fields = obj.getClass().getDeclaredFields()) {
                filed.setAccessible(true);
                String filedName = filed.getName();
                String filedValue = filed.get(obj) == null ? "" : filed.get(obj).toString();
                map.put(filedName.toLowerCase(), filedValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
        return map;
    }
}

