/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.wopay.util;

import com.alibaba.fastjson.JSON;
import com.sinovatech.unicom.util.sign.CryptUtil;
import com.tydic.payment.pay.common.util.HttpClientUtils;
import com.tydic.payment.pay.wopay.util.SSLClient;
import com.tydic.payment.pay.wopay.util.SingleOrderRefund;
import com.tydic.payment.pay.wopay.util.UniPaySignUtilsCer;
import com.tydic.payment.pay.wopay.util.WopayPayMobileRequestBean;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.joda.time.DateTime;

public class WopayTest {
    public static void main(String[] args) throws IOException {
        String payOrderId = "PAYPROTEST12235";
        String merNo = "301100710007142";
        String payJournl = "20210707020154496102";
        String orderDate = "20190718";
        SingleOrderRefund refund = new SingleOrderRefund();
        String dateStr = new DateTime().toString("yyyyMMddHHmmss");
        refund.setRefundReqJournl(dateStr);
        refund.setMerNo(merNo);
        refund.setOrderNo(payOrderId);
        refund.setOrderDate(orderDate);
        refund.setPayJournl(payJournl);
        refund.setMerReqTime(dateStr);
        refund.setAmount(1);
        refund.setReason("\u9000\u6b3e");
        refund.setSignType("RSA_SHA256");
        System.out.println("\u6253\u5370\u53c2\u6570");
        System.out.println(JSON.toJSONString((Object)refund));
        String signMsg = WopayTest.refundCerMerSign(refund);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundReqJournl", refund.getRefundReqJournl());
        map.put("merNo", refund.getMerNo());
        map.put("orderNo", refund.getOrderNo());
        map.put("orderDate", refund.getOrderDate());
        map.put("payJournl", refund.getPayJournl());
        map.put("merReqTime", refund.getMerReqTime());
        map.put("amount", refund.getAmount().toString());
        map.put("reason", refund.getReason());
        map.put("signType", refund.getSignType());
        map.put("signMsg", signMsg);
        String url = "https://mertest.unicompayment.com:8443/CashierWeb/trade/singleRefund.htm?reqCharSet=UTF-8";
        System.out.println(JSON.toJSONString(map));
        String s = SSLClient.doPost(url, map);
        System.out.println("\u8bf7\u6c42\u6253\u5370\u7ed3\u679c");
        System.out.println(s);
    }

    private static void refund(String payOrderId) throws IOException {
        SingleOrderRefund refund = new SingleOrderRefund();
        refund.setMerNo("301100710007142");
        refund.setOrderNo(payOrderId);
        refund.setOrderDate("20190717");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signMsg", "lSqcX9bTAQvmVo7h+NqsSn29nTLSUcHZIolrgPo08YP5Ahwo8B2ipO5QZu8gx9RWn7xe7W/T7bv5Zzie6yaMQ/kfY7UB6MOCXqbts/+GiYGVong5wuKO5XfeIxepNKnUtBxNqsLKtzQE/PnXhIqXOBePYf79kudCRjl56QfNL65CHgN+7UFsiKyuqdNZi3D7vR6Tj6a0lRn0gdNdgG71U4qTxrneXAt5+ScAiuftEDJm2ttuB11FFTE+qKPQ7tw8DK7V0IeJhnhL/NLFPXIrBF3n21gZBAP+XrNcEUP+XHcelzn/gcm9fBsBJX5ZYWr1MfRS8S1R1MqWDPKvFmq+RQ==");
        String result = HttpClientUtils.doGetSSL("https://mertest.unicompayment.com:8443/CashierWeb/trade/singleRefund.htm?reqCharSet=UTF-8", map);
        System.out.println(result);
    }

    private static void order() throws IOException {
        WopayPayMobileRequestBean bean = WopayTest.getBean();
        String s = WopayTest.cerMerSign(bean);
        System.out.println("\u52a0\u5bc6\u4e32\uff1a" + s);
        bean.setSignMsg(s);
        String s1 = CryptUtil.encryptBeanNokey((Object)bean);
        System.out.println("\u9700\u8981\u53d1\u9001\u7684\u53c2\u6570\uff1a" + bean.getMerNo() + s1);
    }

    private static String refundCerMerSign(SingleOrderRefund requesBean) throws FileNotFoundException, IOException {
        int len;
        String merNo = requesBean.getMerNo();
        String p12pincode = "unicom001";
        FileInputStream fis = new FileInputStream("E:\\cq_doc\\01-\u652f\u4ed8\u4e2d\u5fc3\\3\u3001\u63a5\u53e3\u89c4\u8303\\\u6c83\u652f\u4ed8\u5bf9\u63a5\u76f8\u5173\u6587\u6863\\WAP\u6536\u94f6\u53f0\\WAP\u6536\u94f6\u53f0\\301100710007142.pfx");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bb = new byte[4096];
        while ((len = fis.read(bb)) != -1) {
            baos.write(bb, 0, len);
        }
        fis.close();
        String signMsg = UniPaySignUtilsCer.merSign(UniPaySignUtilsCer.obj2NormalMap(requesBean), requesBean.getSignType(), false, baos.toByteArray(), p12pincode);
        baos.close();
        return signMsg;
    }

    private static String cerMerSign(WopayPayMobileRequestBean requesBean) throws FileNotFoundException, IOException {
        int len;
        String merNo = requesBean.getMerNo();
        String p12pincode = "unicom001";
        FileInputStream fis = new FileInputStream("E:\\cq_doc\\01-\u652f\u4ed8\u4e2d\u5fc3\\3\u3001\u63a5\u53e3\u89c4\u8303\\\u6c83\u652f\u4ed8\u5bf9\u63a5\u76f8\u5173\u6587\u6863\\WAP\u6536\u94f6\u53f0\\WAP\u6536\u94f6\u53f0\\301100710007142.pfx");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bb = new byte[4096];
        while ((len = fis.read(bb)) != -1) {
            baos.write(bb, 0, len);
        }
        fis.close();
        String signMsg = UniPaySignUtilsCer.merSign(UniPaySignUtilsCer.obj2LowerMap(requesBean), requesBean.getSignType(), false, baos.toByteArray(), p12pincode);
        baos.close();
        return signMsg;
    }

    public static WopayPayMobileRequestBean getBean() {
        WopayPayMobileRequestBean wopayBean = new WopayPayMobileRequestBean();
        wopayBean.setPayBalance("1000");
        wopayBean.setStoreOrderId("wsy20190715173920end");
        wopayBean.setCallbackUrl("http://localhost:8081/page/wap/callBackUrlQm.jsp");
        wopayBean.setCallbackUrl("https://www.jd.com");
        wopayBean.setServerCallUrl("http://localhost:8081//servlet/WapPayCallbackServlet");
        wopayBean.setMerNo("301100710007142");
        wopayBean.setTradeMode("0001");
        wopayBean.setSignType("RSA_SHA256");
        wopayBean.setWostoreTime(new DateTime().toString("yyyyMMddHHmmss"));
        wopayBean.setVersion("2.2.4");
        wopayBean.setOrderBalance("1000");
        wopayBean.setRespMode("1");
        wopayBean.setStoreName("\u6d4b\u8bd5");
        wopayBean.setStoreIndex("http://www.baidu.com");
        wopayBean.setGoodsName("\u6d4b\u8bd5\u5546\u54c11");
        wopayBean.setUsefulTime("30");
        return wopayBean;
    }
}

