/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.chinabankpay.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;

public class PKCSTool {
    private static final int SIGNER = 1;
    private static final int VERIFIER = 2;
    private int mode = 0;
    private String digestAlgorithm = "SHA1";
    private String signingAlgorithm = "SHA1withRSA";
    private Certificate[] certificates = null;
    private PrivateKey privateKey = null;
    private Certificate rootCertificate = null;
    private static char jvm = '\u0000';
    private static Class algorithmId = null;
    private static Class derValue = null;
    private static Class objectIdentifier = null;
    private static Class x500Name = null;
    private static boolean debug = false;

    private PKCSTool(int mode) {
        this.mode = mode;
    }

    private static void init() {
        if (jvm != '\u0000') {
            return;
        }
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor == null) {
            vendor = "";
        }
        String vendorUC = vendor.toUpperCase();
        try {
            if (vendorUC.indexOf("IBM") >= 0) {
                jvm = (char)73;
                algorithmId = Class.forName("com.ibm.security.x509.AlgorithmId");
                derValue = Class.forName("com.ibm.security.util.DerValue");
                objectIdentifier = Class.forName("com.ibm.security.util.ObjectIdentifier");
                x500Name = Class.forName("com.ibm.security.x509.X500Name");
            } else if (vendorUC.indexOf("ORACLE CORPORATION") >= 0) {
                jvm = (char)83;
                algorithmId = Class.forName("sun.security.x509.AlgorithmId");
                derValue = Class.forName("sun.security.util.DerValue");
                objectIdentifier = Class.forName("sun.security.util.ObjectIdentifier");
                x500Name = Class.forName("sun.security.x509.X500Name");
            } else {
                jvm = (char)83;
                algorithmId = Class.forName("sun.security.x509.AlgorithmId");
                derValue = Class.forName("sun.security.util.DerValue");
                objectIdentifier = Class.forName("sun.security.util.ObjectIdentifier");
                x500Name = Class.forName("sun.security.x509.X500Name");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.out.println("Not support JRE: " + vendor);
            throw new RuntimeException(e);
        }
    }

    private static boolean matchUsage(boolean[] keyUsage, int usage) {
        if (usage == 0 || keyUsage == null) {
            return true;
        }
        for (int i = 0; i < Math.min(keyUsage.length, 32); ++i) {
            if ((usage & 1 << i) == 0 || keyUsage[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKCSTool getSigner(String keyStorePath, String keyStorePassword, String keyPassword, String pkcsType) throws GeneralSecurityException, IOException {
        PKCSTool.init();
        KeyStore keyStore = null;
        try (FileInputStream fis = null;){
            if (keyStorePath.toLowerCase().endsWith(".pfx")) {
                keyStore = KeyStore.getInstance("PKCS12");
            }
            fis = new FileInputStream(keyStorePath);
            keyStore.load(fis, keyStorePassword.toCharArray());
        }
        Enumeration<String> aliases = keyStore.aliases();
        String keyAlias = null;
        if (aliases != null) {
            while (aliases.hasMoreElements()) {
                X509Certificate cert;
                keyAlias = aliases.nextElement();
                Certificate[] certs = keyStore.getCertificateChain(keyAlias);
                if (certs == null || certs.length == 0 || !PKCSTool.matchUsage((cert = (X509Certificate)certs[0]).getKeyUsage(), 1)) continue;
                try {
                    cert.checkValidity();
                    break;
                }
                catch (CertificateException e) {
                }
            }
        }
        if (keyAlias == null) {
            throw new GeneralSecurityException("None certificate for sign in this keystore");
        }
        PKCSTool tool = new PKCSTool(1);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
        if (privateKey == null) {
            throw new GeneralSecurityException(keyAlias + " could not be accessed");
        }
        tool.privateKey = privateKey;
        if ("PKCS7".equals(pkcsType)) {
            X509Certificate[] certificates = null;
            if (keyStore.isKeyEntry(keyAlias)) {
                int i;
                Certificate[] certs = keyStore.getCertificateChain(keyAlias);
                for (i = 0; i < certs.length; ++i) {
                    if (certs[i] instanceof X509Certificate) continue;
                    throw new GeneralSecurityException("Certificate[" + i + "] in chain '" + keyAlias + "' is not a X509Certificate.");
                }
                certificates = new X509Certificate[certs.length];
                for (i = 0; i < certs.length; ++i) {
                    certificates[i] = (X509Certificate)certs[i];
                }
            } else if (keyStore.isCertificateEntry(keyAlias)) {
                Certificate cert = keyStore.getCertificate(keyAlias);
                if (cert instanceof X509Certificate) {
                    certificates = new X509Certificate[]{(X509Certificate)cert};
                }
            } else {
                throw new GeneralSecurityException(keyAlias + " is unknown to this keystore");
            }
            tool.certificates = certificates;
        }
        return tool;
    }

    public String p1Sign(byte[] data) throws Exception {
        if (this.mode != 1) {
            throw new IllegalStateException("call a PKCS1Tool instance not for signature.");
        }
        Signature signer = Signature.getInstance(this.signingAlgorithm);
        signer.initSign(this.privateKey);
        signer.update(data, 0, data.length);
        byte[] signedAttributes = signer.sign();
        return new BASE64Encoder().encode(signedAttributes);
    }

    public String p7Sign(byte[] data) throws Exception {
        if (this.mode != 1) {
            throw new IllegalStateException("call a PKCS7Tool instance not for signature.");
        }
        Signature signer = Signature.getInstance(this.signingAlgorithm);
        signer.initSign(this.privateKey);
        signer.update(data, 0, data.length);
        byte[] signedAttributes = signer.sign();
        ContentInfo contentInfo = null;
        Field data_oidField = ContentInfo.class.getField("DATA_OID");
        Object data_oid = data_oidField.get(null);
        Constructor contentInfoConstructor = ContentInfo.class.getConstructor(data_oid.getClass(), derValue);
        contentInfo = (ContentInfo)contentInfoConstructor.newInstance(data_oid, null);
        X509Certificate x509 = (X509Certificate)this.certificates[this.certificates.length - 1];
        BigInteger serial = x509.getSerialNumber();
        Constructor x500NameConstructor = x500Name.getConstructor(String.class);
        Object x500NameObject = x500NameConstructor.newInstance(x509.getIssuerDN().getName());
        Method algorithmIdGet = algorithmId.getMethod("get", String.class);
        Object digestAlgorithmId = algorithmIdGet.invoke(null, this.digestAlgorithm);
        Field algorithmIdfield = algorithmId.getField("RSAEncryption_oid");
        Object rsaOid = algorithmIdfield.get(null);
        Constructor algorithmConstructor = algorithmId.getConstructor(objectIdentifier);
        Object algorithmRsaOid = algorithmConstructor.newInstance(rsaOid);
        Constructor signerInfoConstructor = SignerInfo.class.getConstructor(x500Name, BigInteger.class, algorithmId, PKCS9Attributes.class, algorithmId, byte[].class, PKCS9Attributes.class);
        SignerInfo si = (SignerInfo)signerInfoConstructor.newInstance(x500NameObject, serial, digestAlgorithmId, null, algorithmRsaOid, signedAttributes, null);
        SignerInfo[] signerInfos = new SignerInfo[]{si};
        Object digestAlgorithmIds = Array.newInstance(algorithmId, 1);
        Array.set(digestAlgorithmIds, 0, digestAlgorithmId);
        Constructor pkcs7Constructor = PKCS7.class.getConstructor(digestAlgorithmIds.getClass(), ContentInfo.class, X509Certificate[].class, signerInfos.getClass());
        PKCS7 p7 = (PKCS7)pkcs7Constructor.newInstance(digestAlgorithmIds, contentInfo, this.certificates, signerInfos);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        p7.encodeSignedData(baout);
        return new BASE64Encoder().encode(baout.toByteArray());
    }

    public static PKCSTool getVerifier(InputStream rootCertStream, InputStream verifyCertStream) throws GeneralSecurityException, IOException {
        Certificate[] verifyCertificates;
        Certificate[] rootCertificates;
        block7: {
            PKCSTool.init();
            rootCertificates = null;
            verifyCertificates = null;
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            try {
                if (verifyCertStream != null) {
                    verifyCertificates = new Certificate[]{certificatefactory.generateCertificate(verifyCertStream)};
                }
                if (rootCertStream != null) {
                    rootCertificates = new Certificate[]{certificatefactory.generateCertificate(rootCertStream)};
                }
            }
            catch (Exception exception) {
                if (debug) {
                    exception.printStackTrace();
                }
                if (rootCertStream != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(rootCertStream));
                    rootCertificates = new Certificate[]{certificatefactory.generateCertificate(is)};
                }
                if (verifyCertStream == null) break block7;
                ByteArrayInputStream signIs = new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(verifyCertStream));
                verifyCertificates = new Certificate[]{certificatefactory.generateCertificate(signIs)};
            }
        }
        PKCSTool tool = new PKCSTool(2);
        if (rootCertStream != null) {
            tool.rootCertificate = rootCertificates[0];
        }
        tool.certificates = verifyCertificates;
        return tool;
    }

    public void p1Verify(String signature, byte[] data) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, CertificateException, NoSuchProviderException {
        if (this.mode != 2) {
            throw new IllegalStateException("call a PKCS1Tool instance not for verify.");
        }
        byte[] sign = new BASE64Decoder().decodeBuffer(signature);
        Signature verify = Signature.getInstance(this.signingAlgorithm);
        verify.initVerify(this.certificates[0]);
        verify.update(data);
        boolean result = verify.verify(sign, 0, sign.length);
        if (!result) {
            throw new SignatureException("Verify fail.");
        }
        X509Certificate cert = (X509Certificate)this.certificates[0];
        cert.checkValidity();
        if (cert.equals(this.rootCertificate)) {
            cert.verify(this.rootCertificate.getPublicKey());
        }
    }

    public void p7Verify(String signature, byte[] data) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, CertificateException, NoSuchProviderException {
        SignerInfo[] sis;
        if (this.mode != 2) {
            throw new IllegalStateException("call a PKCS7Tool instance not for verify.");
        }
        byte[] sign = new BASE64Decoder().decodeBuffer(signature);
        PKCS7 p7 = new PKCS7(sign);
        X509Certificate[] certs = p7.getCertificates();
        if (debug) {
            for (int i = 0; i < certs.length; ++i) {
                X509Certificate cert = certs[i];
                System.out.println("SIGNER " + i + "=\n" + cert);
                System.out.println("SIGNER " + i + "=\n" + new BASE64Encoder().encode(cert.getEncoded()));
            }
        }
        if ((sis = p7.verify(data)) == null) {
            throw new SignatureException("Signature failed verification, data has been tampered");
        }
        for (int i = 0; i < sis.length; ++i) {
            SignerInfo si = sis[i];
            X509Certificate cert = si.getCertificate(p7);
            cert.checkValidity();
            if (cert.equals(this.rootCertificate)) continue;
            cert.verify(this.rootCertificate.getPublicKey());
        }
    }
}

