/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.chinapay.util;

import com.tydic.payment.pay.chinapay.util.SecssConstants;
import com.tydic.payment.pay.chinapay.util.SecssUtil;
import com.tydic.payment.pay.chinapay.util.SecurityException;
import com.tydic.payment.pay.sdk.unionpay.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SecssConfig {
    private static String FILE_NAME = "security.properties";
    private String signFile;
    private String signFileAlias;
    private String signFilePwd;
    private String signCertType;
    private String verifyFile;
    private String signFieldName;
    private List invalidFileds;

    private SecssConfig() {
    }

    public static SecssConfig defaultInit() throws SecurityException {
        SecssConfig secssConfig = null;
        Properties pros = SecssConfig.loadPropertiesFromSrc();
        if (SecssConfig.checkPros(pros)) {
            secssConfig = new SecssConfig();
            secssConfig.loadProperties(pros);
        }
        return secssConfig;
    }

    public static SecssConfig specifyInit(Properties pros) throws SecurityException {
        SecssConfig secssConfig = null;
        if (SecssConfig.checkPros(pros)) {
            secssConfig = new SecssConfig();
            secssConfig.loadProperties(pros);
        }
        return secssConfig;
    }

    private static Properties loadPropertiesFromSrc() throws SecurityException {
        Properties var5;
        InputStream in = null;
        Properties properties = null;
        try {
            in = SecssConfig.class.getClassLoader().getResourceAsStream(FILE_NAME);
            if (in != null) {
                properties = new Properties();
                properties.load(in);
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var17) {
                    // empty catch block
                }
            }
            var5 = properties;
        }
        catch (IOException var18) {
            LogUtil.writeErrorLog("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff01", var18);
            throw new SecurityException(SecssConstants.LOAD_CONFIG_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return var5;
    }

    public void loadProperties(Properties pro) {
        String localValue;
        String[] values;
        String value = pro.getProperty(SecssConstants.SIGN_FILE);
        if (!SecssUtil.isEmpty(value)) {
            this.signFile = value.trim();
        }
        if (!SecssUtil.isEmpty(value = pro.getProperty(SecssConstants.SIGN_FILE_ALIAS))) {
            this.signFileAlias = value.trim();
        }
        if (!SecssUtil.isEmpty(value = pro.getProperty(SecssConstants.SIGN_FILE_PW))) {
            this.signFilePwd = value.trim();
        }
        if (!SecssUtil.isEmpty(value = pro.getProperty(SecssConstants.VERIFY_FILE))) {
            this.verifyFile = value.trim();
        }
        if (!SecssUtil.isEmpty(value = pro.getProperty(SecssConstants.SIGN_CERT_TYPE))) {
            this.signCertType = value.trim();
        }
        if (!SecssUtil.isEmpty(value = pro.getProperty(SecssConstants.SIGNATURE_FIELD))) {
            this.signFieldName = value.trim();
        }
        if (!SecssUtil.isEmpty(value = pro.getProperty(SecssConstants.SIGN_INVALID_FIELDS)) && (values = (localValue = value.trim()).split(",")) != null && values.length > 0) {
            this.invalidFileds = new ArrayList();
            for (int i = 0; i < values.length; ++i) {
                this.invalidFileds.add(values[i].trim());
            }
        }
    }

    private static boolean checkPros(Properties pro) throws SecurityException {
        if (SecssUtil.isEmpty(pro.getProperty(SecssConstants.SIGN_FILE))) {
            throw new SecurityException(SecssConstants.CONFIG_WRONG);
        }
        if (SecssUtil.isEmpty(pro.getProperty(SecssConstants.SIGN_FILE_PW))) {
            throw new SecurityException(SecssConstants.CONFIG_WRONG);
        }
        if (SecssUtil.isEmpty(pro.getProperty(SecssConstants.VERIFY_FILE))) {
            throw new SecurityException(SecssConstants.CONFIG_WRONG);
        }
        if (SecssUtil.isEmpty(pro.getProperty(SecssConstants.SIGN_CERT_TYPE))) {
            throw new SecurityException(SecssConstants.CONFIG_WRONG);
        }
        if (SecssUtil.isEmpty(pro.getProperty(SecssConstants.SIGNATURE_FIELD))) {
            throw new SecurityException(SecssConstants.CONFIG_WRONG);
        }
        return true;
    }

    public String getSignFile() {
        return this.signFile;
    }

    public String getSignFilePwd() {
        return this.signFilePwd;
    }

    public String getVerifyFile() {
        return this.verifyFile;
    }

    public String getSignCertType() {
        return this.signCertType;
    }

    public String getSignFieldName() {
        return this.signFieldName;
    }

    public List getInvalidFileds() {
        return this.invalidFileds;
    }

    public String getSignFileAlias() {
        return this.signFileAlias;
    }
}

