/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.chinapay.util;

import com.tydic.payment.pay.chinapay.util.SecssConstants;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESUtil {
    private static final String AES = "AES";
    public static final int DefaultKeySize = 256;

    public static byte[] genAESKey(int initKeySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(AES);
            kg.init(initKeySize);
            SecretKey sk = kg.generateKey();
            byte[] bytes = sk.getEncoded();
            return bytes;
        }
        catch (Exception var4) {
            throw new RuntimeException(var4);
        }
    }

    public static String genAESKeyForBase64() {
        try {
            byte[] bytes = AESUtil.genAESKey(256);
            return new String(Base64.encodeBase64((byte[])bytes), SecssConstants.CHARSET_COMM);
        }
        catch (Exception var1) {
            throw new RuntimeException(var1);
        }
    }

    public static byte[] encrypt(byte[] byteKey, byte[] byteContent) {
        try {
            SecretKeySpec key = new SecretKeySpec(byteKey, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (InvalidKeyException var5) {
            throw new RuntimeException(var5);
        }
        catch (NoSuchAlgorithmException var6) {
            throw new RuntimeException(var6);
        }
        catch (NoSuchPaddingException var7) {
            throw new RuntimeException(var7);
        }
        catch (IllegalBlockSizeException var8) {
            throw new RuntimeException(var8);
        }
        catch (BadPaddingException var9) {
            throw new RuntimeException(var9);
        }
    }

    public static byte[] decrypt(byte[] byteKey, byte[] byteContent) {
        try {
            SecretKeySpec key = new SecretKeySpec(byteKey, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(2, key);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (InvalidKeyException var5) {
            throw new RuntimeException(var5);
        }
        catch (NoSuchAlgorithmException var6) {
            throw new RuntimeException(var6);
        }
        catch (NoSuchPaddingException var7) {
            throw new RuntimeException(var7);
        }
        catch (IllegalBlockSizeException var8) {
            throw new RuntimeException(var8);
        }
        catch (BadPaddingException var9) {
            throw new RuntimeException(var9);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(AESUtil.genAESKey(256));
        System.out.println(AESUtil.genAESKey(256));
        System.out.println(AESUtil.genAESKey(256));
        System.out.println(AESUtil.genAESKey(256));
        byte[] key = AESUtil.genAESKey(256);
        byte[] inputByte = "test\u7b2c\u4e09\u65b9test\u7b2c\u4e09\u65b9test\u7b2c\u4e09\u65b9".getBytes(SecssConstants.CHARSET_COMM);
        byte[] zipByte = AESUtil.encrypt(key, inputByte);
        System.out.println(String.format("encrypt length = %s", zipByte.length));
        byte[] outputByte = AESUtil.decrypt(key, zipByte);
        System.out.println(String.format("output length = %s", outputByte.length));
        System.out.println(new String(outputByte, SecssConstants.CHARSET_COMM));
    }
}

