/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.common.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityConvertUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityConvertUtils.class);

    public static Map<String, String> entityToMap(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : object.getClass().getDeclaredFields()) {
            try {
                boolean flag = field.isAccessible();
                field.setAccessible(true);
                Object o = field.get(object);
                if (o != null) {
                    map.put(field.getName(), String.valueOf(o));
                }
                field.setAccessible(flag);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public static <T> T mapToEntity(Map<String, Object> map, Class<T> entity) {
        T t = null;
        try {
            t = entity.newInstance();
            for (Field field : entity.getDeclaredFields()) {
                if (!map.containsKey(field.getName())) continue;
                boolean flag = field.isAccessible();
                field.setAccessible(true);
                Object object = map.get(field.getName());
                if (object != null && field.getType().isAssignableFrom(object.getClass())) {
                    field.set(t, object);
                }
                field.setAccessible(flag);
            }
            return t;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return t;
        }
    }
}

