/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.icbc.util;

import com.tydic.payment.pay.icbc.IcbcApiException;
import com.tydic.payment.pay.icbc.util.HttpClientUtils;
import com.tydic.payment.pay.icbc.util.IcbcHashMap;
import com.tydic.payment.pay.icbc.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class WebUtils {
    private static final Log logger = LogFactory.getLog(WebUtils.class);
    private static String CHARSET_UTF8 = "UTF-8";
    private static Pattern CHARSET_PATTERN = Pattern.compile(".*charset=(.+)");
    private static String version = "v2_20190522";

    public static void doPost(String url, Map<String, String> params, String charset, IcbcApiFutureCallback<String> callback) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        WebUtils.doPost(url, params, (Map<String, String>)headers, charset, callback);
    }

    public static void doGet(String url, Map<String, String> params, String charset, IcbcApiFutureCallback<String> callback) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        WebUtils.doGet(url, params, headers, charset, callback);
    }

    public static void doPost(String url, Map<String, String> params, Map<String, String> headers, String charset, IcbcApiFutureCallback<String> callback) throws IcbcApiException {
        WebUtils.doPost(url, WebUtils.buildPostHttpEntity(params, charset), headers, charset, callback);
    }

    public static void doPost(String url, HttpEntity entity, Map<String, String> headers, String charset, IcbcApiFutureCallback<String> callback) throws IcbcApiException {
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity(entity);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)httppost, headers);
        }
        WebUtils.execute((HttpRequestBase)httppost, callback);
    }

    public static void doGet(String url, Map<String, String> params, Map<String, String> headers, String charset, IcbcApiFutureCallback<String> callback) throws IcbcApiException {
        String getUrl = WebUtils.buildGetUrl(url, params, charset);
        HttpGet request = new HttpGet(getUrl);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)request, headers);
        }
        WebUtils.execute((HttpRequestBase)request, callback);
    }

    public static void execute(final HttpRequestBase request, final IcbcApiFutureCallback<String> callback) throws IcbcApiException {
        HttpClientUtils.getAsyncHttpClient().execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                int statusCode = response.getStatusLine().getStatusCode();
                try {
                    HttpEntity httpEntity = response.getEntity();
                    try {
                        String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)WebUtils.getResponseEncoding(httpEntity));
                        if (statusCode != 200) {
                            throw new IcbcApiException("response status code is not valid. status code: " + statusCode + " resp is:" + respStr);
                        }
                        callback.completed(respStr);
                    }
                    catch (ParseException e) {
                        throw new IcbcApiException("parse respose exception.", e);
                    }
                    catch (IOException e) {
                        throw new IcbcApiException("io exception.", e);
                    }
                }
                catch (IcbcApiException e) {
                    callback.failed(e);
                }
                finally {
                    org.apache.http.client.utils.HttpClientUtils.closeQuietly((HttpResponse)response);
                }
            }

            public void failed(Exception ex) {
                try {
                    callback.failed(new IcbcApiException("async http client execute failed.", ex));
                }
                finally {
                    request.releaseConnection();
                }
            }

            public void cancelled() {
                try {
                    callback.failed(new IcbcApiException("async http client execute has been cancelled."));
                }
                finally {
                    request.releaseConnection();
                }
            }
        });
    }

    public static String doPost(String url, Map<String, String> params, String charset) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        headers.put("Request-Type", "3");
        return WebUtils.doPost(url, params, (Map<String, String>)headers, charset);
    }

    public static String doGet(String url, Map<String, String> params, String charset) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        return WebUtils.doGet(url, params, headers, charset);
    }

    public static String doPost(String url, Map<String, String> params, String charset, Map<String, String> headerParams) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        Set<Map.Entry<String, String>> entries = headerParams.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            try {
                headers.put(entry.getKey(), URLEncoder.encode(entry.getValue(), charset));
            }
            catch (UnsupportedEncodingException e) {
                throw new IcbcApiException(e);
            }
        }
        return WebUtils.doPost(url, params, (Map<String, String>)headers, charset);
    }

    public static String doGet(String url, Map<String, String> params, String charset, Map<String, String> headerParams) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        Set<Map.Entry<String, String>> entries = headerParams.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            try {
                headers.put(entry.getKey(), URLEncoder.encode(entry.getValue(), charset));
            }
            catch (UnsupportedEncodingException e) {
                throw new IcbcApiException(e);
            }
        }
        return WebUtils.doGet(url, params, headers, charset);
    }

    public static String doPost(String url, Map<String, String> params, String charset, String zoneNo) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        headers.put("Zone-No", zoneNo);
        return WebUtils.doPost(url, params, (Map<String, String>)headers, charset);
    }

    public static String doGet(String url, Map<String, String> params, String charset, String zoneNo) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        headers.put("Zone-No", zoneNo);
        return WebUtils.doGet(url, params, headers, charset);
    }

    public static String doPost(String url, String postJson, String charset) throws IcbcApiException {
        IcbcHashMap headers = new IcbcHashMap();
        headers.put("APIGW-VERSION", version);
        return WebUtils.doPost(url, postJson, (Map<String, String>)headers, charset);
    }

    public static String doPost(String url, String postJson, Map<String, String> headers, String charset) throws IcbcApiException {
        StringEntity httpEntity = new StringEntity(postJson, charset);
        return WebUtils.doPost(url, (HttpEntity)httpEntity, headers, charset);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, String> headers, String charset) throws IcbcApiException {
        return WebUtils.doPost(url, WebUtils.buildPostHttpEntity(params, charset), headers, charset);
    }

    public static String doPost(String url, HttpEntity entity, Map<String, String> headers, String charset) throws IcbcApiException {
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity(entity);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)httppost, headers);
        }
        return WebUtils.execute((HttpUriRequest)httppost);
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers, String charset) throws IcbcApiException {
        String getUrl = WebUtils.buildGetUrl(url, params, charset);
        HttpGet request = new HttpGet(getUrl);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)request, headers);
        }
        return WebUtils.execute((HttpUriRequest)request);
    }

    public static String execute(HttpUriRequest request) throws IcbcApiException {
        HttpResponse resp;
        try {
            resp = HttpClientUtils.getSyncHttpClient().execute(request);
        }
        catch (ClientProtocolException e) {
            logger.error((Object)"execute request exception.", (Throwable)e);
            throw new IcbcApiException("execute request exception.", e);
        }
        catch (IOException e) {
            logger.error((Object)"execute request exception.", (Throwable)e);
            throw new IcbcApiException("execute request exception.", e);
        }
        int statusCode = resp.getStatusLine().getStatusCode();
        HttpEntity httpEntity = resp.getEntity();
        try {
            String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)WebUtils.getResponseEncoding(httpEntity));
            if (statusCode != 200) {
                logger.error((Object)("response status code is not valid. status code: " + statusCode));
                throw new IcbcApiException("response status code is not valid. status code: " + statusCode + " resp is:" + respStr);
            }
            return respStr;
        }
        catch (ParseException e) {
            logger.error((Object)"parse respose exception.", (Throwable)e);
            throw new IcbcApiException("parse respose exception.", e);
        }
        catch (IOException e) {
            logger.error((Object)"io exception.", (Throwable)e);
            throw new IcbcApiException("io exception.", e);
        }
    }

    public static String getResponseEncoding(HttpEntity httpEntity) {
        String value;
        Matcher matcher;
        Header contentTypeHeader = httpEntity.getContentType();
        if (contentTypeHeader != null && (matcher = CHARSET_PATTERN.matcher(value = contentTypeHeader.getValue().replace(" ", ""))).find()) {
            return matcher.group(1);
        }
        return CHARSET_UTF8;
    }

    public static HttpEntity buildPostHttpEntity(Map<String, String> params, String charset) throws IcbcApiException {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            return new UrlEncodedFormEntity(list, charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"urlencode post request exception.", (Throwable)e);
            throw new IcbcApiException("urlencode post request exception.", e);
        }
    }

    public static String buildGetUrl(String strUrl, Map<String, String> params, String charset) throws IcbcApiException {
        if (params == null || params.size() == 0) {
            return strUrl;
        }
        StringBuilder sb = new StringBuilder(strUrl);
        try {
            if (StringUtils.isEmpty(new URL(strUrl).getQuery()) && !strUrl.endsWith("?")) {
                sb.append('?');
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)("url exception. url: " + strUrl), (Throwable)e);
            throw new IcbcApiException("url exception. url: " + strUrl, e);
        }
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        boolean shouldAddAnd = strUrl.contains("?") ? !strUrl.endsWith("&") : false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                sb.append("&");
            } else {
                if (shouldAddAnd) {
                    sb.append("&");
                }
                hasParam = true;
            }
            try {
                sb.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)("param urlencode exception. value: " + value), (Throwable)e);
                throw new IcbcApiException("param urlencode exception. value: " + value, e);
            }
        }
        return sb.toString();
    }

    public static String buildOrderedSignStr(String path, Map<String, String> params) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.putAll(params);
        Set entries = sortedMap.entrySet();
        boolean hasParam = false;
        StringBuilder sb = new StringBuilder(path);
        sb.append("?");
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.areNotEmpty(name, value)) continue;
            if (hasParam) {
                sb.append("&");
            } else {
                hasParam = true;
            }
            sb.append(name).append("=").append(value);
        }
        return sb.toString();
    }

    private WebUtils() {
    }

    public static String buildForm(String baseUrl, Map<String, String> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<form name=\"auto_submit_form\" method=\"post\" action=\"");
        sb.append(baseUrl);
        sb.append("\">\n");
        sb.append(WebUtils.buildHiddenFields(parameters));
        sb.append("<input type=\"submit\" value=\"\u7acb\u523b\u63d0\u4ea4\" style=\"display:none\" >\n");
        sb.append("</form>\n");
        sb.append("<script>document.forms[0].submit();</script>");
        String form = sb.toString();
        return form;
    }

    private static String buildHiddenFields(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            String value = parameters.get(key);
            if (key == null || value == null) continue;
            sb.append(WebUtils.buildHiddenField(key, value));
        }
        String result = sb.toString();
        return result;
    }

    private static String buildHiddenField(String key, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(key);
        sb.append("\" value=\"");
        String a = value.replace("\"", "&quot;");
        sb.append(a).append("\">\n");
        return sb.toString();
    }

    private static void addHeaders(HttpUriRequest request, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.areNotEmpty(name, value)) continue;
            request.addHeader(name, value);
        }
    }

    public static interface IcbcApiFutureCallback<T> {
        public void completed(T var1);

        public void failed(IcbcApiException var1);
    }
}

