/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.sdk.unionpay;

import com.tydic.payment.pay.sdk.unionpay.LogUtil;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.sdk.unionpay.SdkUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtil {
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static PublicKey encryptTrackKey = null;
    private static X509Certificate validateCert = null;
    private static X509Certificate middleCert = null;
    private static X509Certificate rootCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap<String, X509Certificate>();
    private static final Map<String, KeyStore> KEY_STORE_MAP = new ConcurrentHashMap<String, KeyStore>(16);

    private static void init() {
        try {
            CertUtil.addProvider();
            CertUtil.initSignCert();
            CertUtil.initMiddleCert();
            CertUtil.initRootCert();
            CertUtil.initEncryptCert();
            CertUtil.initTrackKey();
            CertUtil.initValidateCertFromDir();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("init\u5931\u8d25\u3002\uff08\u5982\u679c\u662f\u7528\u5bf9\u79f0\u5bc6\u94a5\u7b7e\u540d\u7684\u53ef\u65e0\u89c6\u6b64\u5f02\u5e38\u3002\uff09", e);
        }
    }

    private static void addProvider() {
        String name = "BC";
        if (Security.getProvider(name) == null) {
            LogUtil.writeLog("add BC provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider(name);
            Security.addProvider((Provider)new BouncyCastleProvider());
            LogUtil.writeLog("re-add BC provider");
        }
        CertUtil.printSysInfo();
    }

    private static void initSignCert() {
        if (!"01".equals(SdkConfig.getConfig().getSignMethod())) {
            LogUtil.writeLog("\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u3002");
            return;
        }
        if (SdkConfig.getConfig().getSignCertPath() == null || SdkConfig.getConfig().getSignCertPwd() == null || SdkConfig.getConfig().getSignCertType() == null) {
            LogUtil.writeErrorLog("WARN: acpsdk.signCert.path\u6216acpsdk.signCert.pwd\u6216acpsdk.signCert.type\u4e3a\u7a7a\u3002 \u505c\u6b62\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u3002");
            return;
        }
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo(SdkConfig.getConfig().getSignCertPath(), SdkConfig.getConfig().getSignCertPwd(), SdkConfig.getConfig().getSignCertType());
            LogUtil.writeLog("InitSignCert Successful. CertId=[" + CertUtil.getSignCertId() + "]");
        }
        catch (IOException e) {
            LogUtil.writeErrorLog("InitSignCert Error", e);
        }
    }

    private static void initMiddleCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u4e2d\u7ea7\u8bc1\u4e66==>" + SdkConfig.getConfig().getMiddleCertPath());
        if (!SdkUtil.isEmpty(SdkConfig.getConfig().getMiddleCertPath())) {
            middleCert = CertUtil.initCert(SdkConfig.getConfig().getMiddleCertPath());
            LogUtil.writeLog("Load MiddleCert Successful");
        } else {
            LogUtil.writeLog("WARN: acpsdk.middle.path is empty");
        }
    }

    private static void initRootCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u6839\u8bc1\u4e66==>" + SdkConfig.getConfig().getRootCertPath());
        if (!SdkUtil.isEmpty(SdkConfig.getConfig().getRootCertPath())) {
            rootCert = CertUtil.initCert(SdkConfig.getConfig().getRootCertPath());
            LogUtil.writeLog("Load RootCert Successful");
        } else {
            LogUtil.writeLog("WARN: acpsdk.rootCert.path is empty");
        }
    }

    private static void initEncryptCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u8bc1\u4e66==>" + SdkConfig.getConfig().getEncryptCertPath());
        if (!SdkUtil.isEmpty(SdkConfig.getConfig().getEncryptCertPath())) {
            encryptCert = CertUtil.initCert(SdkConfig.getConfig().getEncryptCertPath());
            LogUtil.writeLog("Load EncryptCert Successful");
        } else {
            LogUtil.writeLog("WARN: acpsdk.encryptCert.path is empty");
        }
    }

    private static void initTrackKey() {
        if (!SdkUtil.isEmpty(SdkConfig.getConfig().getEncryptTrackKeyModulus()) && !SdkUtil.isEmpty(SdkConfig.getConfig().getEncryptTrackKeyExponent())) {
            encryptTrackKey = CertUtil.getPublicKey(SdkConfig.getConfig().getEncryptTrackKeyModulus(), SdkConfig.getConfig().getEncryptTrackKeyExponent());
            LogUtil.writeLog("LoadEncryptTrackKey Successful");
        } else {
            LogUtil.writeLog("WARN: acpsdk.encryptTrackKey.modulus or acpsdk.encryptTrackKey.exponent is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initValidateCertFromDir() {
        if (!"01".equals(SdkConfig.getConfig().getSignMethod())) {
            LogUtil.writeLog("\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u9a8c\u7b7e\u8bc1\u4e66\u3002");
            return;
        }
        certMap.clear();
        String dir = SdkConfig.getConfig().getValidateCertDir();
        LogUtil.writeLog("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u76ee\u5f55==>" + dir + " \u6ce8\uff1a\u5982\u679c\u8bf7\u6c42\u62a5\u6587\u4e2dversion=5.1.0\u90a3\u4e48\u6b64\u9a8c\u7b7e\u8bc1\u4e66\u76ee\u5f55\u4f7f\u7528\u4e0d\u5230\uff0c\u53ef\u4ee5\u4e0d\u9700\u8981\u8bbe\u7f6e\uff08version=5.0.0\u5fc5\u987b\u8bbe\u7f6e\uff09\u3002");
        if (SdkUtil.isEmpty(dir)) {
            LogUtil.writeErrorLog("WARN: acpsdk.validateCert.dir is empty");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            LogUtil.writeErrorLog("LoadVerifyCert Error: No BC Provider", e);
            return;
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("LoadVerifyCert Error", e);
            return;
        }
        File fileDir = new File(dir);
        File[] files = fileDir.listFiles(new CerFilter());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                if (validateCert == null) {
                    LogUtil.writeErrorLog("Load verify cert error, " + file.getAbsolutePath() + " has error cert content.");
                    continue;
                }
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                LogUtil.writeLog("[" + file.getAbsolutePath() + "][CertId=" + validateCert.getSerialNumber().toString() + "]");
                continue;
            }
            catch (CertificateException e) {
                LogUtil.writeErrorLog("LoadVerifyCert Error", e);
                continue;
            }
            catch (FileNotFoundException e) {
                LogUtil.writeErrorLog("LoadVerifyCert Error File Not Found", e);
                continue;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LogUtil.writeErrorLog(e.toString());
                    }
                }
            }
        }
        LogUtil.writeLog("LoadVerifyCert Finish");
    }

    private static void loadSignCert(String certFilePath, String certPwd) {
        KeyStore keyStore = null;
        try {
            keyStore = CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12");
            KEY_STORE_MAP.put(certFilePath, keyStore);
            LogUtil.writeLog("LoadRsaCert Successful");
        }
        catch (IOException e) {
            LogUtil.writeErrorLog("LoadRsaCert Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            in = new FileInputStream(path);
            encryptCertTemp = (X509Certificate)cf.generateCertificate(in);
            LogUtil.writeLog("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]");
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("InitCert Error", e);
            throw new IllegalArgumentException("CertificateException");
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog("InitCert Error File Not Found", e);
        }
        catch (NoSuchProviderException e) {
            LogUtil.writeErrorLog("LoadVerifyCert Error No BC Provider", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
        return encryptCertTemp;
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, SdkConfig.getConfig().getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKey Error", e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKey Error", e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKey Error", e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String certPwd) {
        if (!KEY_STORE_MAP.containsKey(certPath)) {
            CertUtil.loadSignCert(certPath, certPwd);
        }
        try {
            Enumeration<String> aliasenum = KEY_STORE_MAP.get(certPath).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)KEY_STORE_MAP.get(certPath).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKeyByStoreMap Error", e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKeyByStoreMap Error", e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKeyByStoreMap Error", e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        if (null == encryptCert) {
            String path = SdkConfig.getConfig().getEncryptCertPath();
            if (!SdkUtil.isEmpty(path)) {
                encryptCert = CertUtil.initCert(path);
                if (encryptCert != null) {
                    return encryptCert.getPublicKey();
                }
                throw new NullPointerException("initCert \u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            }
            LogUtil.writeErrorLog("acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getPublicKey();
    }

    public static void resetEncryptCertPublicKey() {
        encryptCert = null;
    }

    public static PublicKey getEncryptTrackPublicKey() {
        if (null == encryptTrackKey) {
            CertUtil.initTrackKey();
        }
        return encryptTrackKey;
    }

    public static PublicKey getValidatePublicKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        LogUtil.writeErrorLog("\u7f3a\u5c11certId=[" + certId + "]\u5bf9\u5e94\u7684\u9a8c\u7b7e\u8bc1\u4e66.");
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("getSignCertId Error", e);
            return null;
        }
    }

    public static String getEncryptCertId() {
        if (null == encryptCert) {
            String path = SdkConfig.getConfig().getEncryptCertPath();
            if (!SdkUtil.isEmpty(path)) {
                encryptCert = CertUtil.initCert(path);
                if (encryptCert != null) {
                    return encryptCert.getSerialNumber().toString();
                }
                throw new NullPointerException("initCert \u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            }
            LogUtil.writeErrorLog("acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getSerialNumber().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        LogUtil.writeLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + pfxkeyfile);
        FileInputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance(type, "BC");
            LogUtil.writeLog("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "],type=[" + type + "]");
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("getKeyInfo Error", e);
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    public static String getCertIdByKeyStoreMap(String certPath, String certPwd) {
        if (!KEY_STORE_MAP.containsKey(certPath)) {
            CertUtil.loadSignCert(certPath, certPwd);
        }
        return CertUtil.getCertIdIdByStore(KEY_STORE_MAP.get(certPath));
    }

    private static String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog("getCertIdIdByStore Error", e);
            return null;
        }
    }

    private static PublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u6784\u9020RSA\u516c\u94a5\u5931\u8d25\uff1a" + e);
            return null;
        }
    }

    public static X509Certificate genCertificateByStr(String x509CertString) {
        X509Certificate x509Cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream tIn = new ByteArrayInputStream(x509CertString.getBytes("ISO-8859-1"));
            x509Cert = (X509Certificate)cf.generateCertificate(tIn);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("gen certificate error", e);
        }
        return x509Cert;
    }

    public static X509Certificate getMiddleCert() {
        if (null == middleCert) {
            String path = SdkConfig.getConfig().getMiddleCertPath();
            if (!SdkUtil.isEmpty(path)) {
                CertUtil.initMiddleCert();
            } else {
                LogUtil.writeErrorLog("acpsdk.middleCert.path not set in acp_sdk.properties");
                return null;
            }
        }
        return middleCert;
    }

    public static X509Certificate getRootCert() {
        if (null == rootCert) {
            String path = SdkConfig.getConfig().getRootCertPath();
            if (!SdkUtil.isEmpty(path)) {
                CertUtil.initRootCert();
            } else {
                LogUtil.writeErrorLog("acpsdk.rootCert.path not set in acp_sdk.properties");
                return null;
            }
        }
        return rootCert;
    }

    private static String getIdentitiesFromCertficate(X509Certificate aCert) {
        String tDN = aCert.getSubjectDN().toString();
        String tPart = "";
        if (tDN != null) {
            String[] tSplitStr = tDN.substring(tDN.indexOf("CN=")).split("@");
            int length = 2;
            if (tSplitStr != null && tSplitStr.length > length && tSplitStr[2] != null) {
                tPart = tSplitStr[2];
            }
        }
        return tPart;
    }

    private static boolean verifyCertificateChain(X509Certificate cert) {
        if (null == cert) {
            LogUtil.writeErrorLog("cert must Not null");
            return false;
        }
        X509Certificate middleCert = CertUtil.getMiddleCert();
        if (null == middleCert) {
            LogUtil.writeErrorLog("middleCert must Not null");
            return false;
        }
        X509Certificate rootCert = CertUtil.getRootCert();
        if (null == rootCert) {
            LogUtil.writeErrorLog("rootCert or cert must Not null");
            return false;
        }
        try {
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(cert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            trustAnchors.add(new TrustAnchor(rootCert, null));
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            intermediateCerts.add(rootCert);
            intermediateCerts.add(middleCert);
            intermediateCerts.add(cert);
            pkixParams.setRevocationEnabled(false);
            CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(intermediateCerts), "BC");
            pkixParams.addCertStore(intermediateCertStore);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(pkixParams);
            LogUtil.writeLog("verify certificate chain succeed.");
            return true;
        }
        catch (CertPathBuilderException e) {
            LogUtil.writeErrorLog("verify certificate chain fail.", e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("verify certificate chain exception: ", e);
        }
        return false;
    }

    public static boolean verifyCertificate(X509Certificate cert) {
        if (null == cert) {
            LogUtil.writeErrorLog("cert must Not null");
            return false;
        }
        try {
            cert.checkValidity();
            if (!CertUtil.verifyCertificateChain(cert)) {
                return false;
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("verifyCertificate fail", e);
            return false;
        }
        if (SdkConfig.getConfig().isIfValidateCNName()) {
            if (!"\u4e2d\u56fd\u94f6\u8054\u80a1\u4efd\u6709\u9650\u516c\u53f8".equals(CertUtil.getIdentitiesFromCertficate(cert))) {
                LogUtil.writeErrorLog("cer owner is not CUP:" + CertUtil.getIdentitiesFromCertficate(cert));
                return false;
            }
        } else if (!"\u4e2d\u56fd\u94f6\u8054\u80a1\u4efd\u6709\u9650\u516c\u53f8".equals(CertUtil.getIdentitiesFromCertficate(cert)) && !"00040000:SIGN".equals(CertUtil.getIdentitiesFromCertficate(cert))) {
            LogUtil.writeErrorLog("cer owner is not CUP:" + CertUtil.getIdentitiesFromCertficate(cert));
            return false;
        }
        return true;
    }

    private static void printSysInfo() {
        LogUtil.writeLog("================= SYS INFO begin====================");
        LogUtil.writeLog("os_name:" + System.getProperty("os.name"));
        LogUtil.writeLog("os_arch:" + System.getProperty("os.arch"));
        LogUtil.writeLog("os_version:" + System.getProperty("os.version"));
        LogUtil.writeLog("java_vm_specification_version:" + System.getProperty("java.vm.specification.version"));
        LogUtil.writeLog("java_vm_specification_vendor:" + System.getProperty("java.vm.specification.vendor"));
        LogUtil.writeLog("java_vm_specification_name:" + System.getProperty("java.vm.specification.name"));
        LogUtil.writeLog("java_vm_version:" + System.getProperty("java.vm.version"));
        LogUtil.writeLog("java_vm_name:" + System.getProperty("java.vm.name"));
        LogUtil.writeLog("java.version:" + System.getProperty("java.version"));
        LogUtil.writeLog("java.vm.vendor=[" + System.getProperty("java.vm.vendor") + "]");
        LogUtil.writeLog("java.version=[" + System.getProperty("java.version") + "]");
        CertUtil.printProviders();
        LogUtil.writeLog("================= SYS INFO end=====================");
    }

    private static void printProviders() {
        LogUtil.writeLog("Providers List:");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            LogUtil.writeLog(i + 1 + "." + providers[i].getName());
        }
    }

    static {
        CertUtil.init();
    }

    static class CerFilter
    implements FilenameFilter {
        CerFilter() {
        }

        public boolean isCer(String name) {
            String suffix = ".cer";
            return name.toLowerCase().endsWith(suffix);
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.isCer(name);
        }
    }
}

