/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HttpClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final CloseableHttpClient httpClient;
    public static final String CHARSET = "UTF-8";

    public static String doGet(String url, Map<String, String> params) {
        return HttpClientUtils.doGet(url, params, CHARSET);
    }

    public static String doGetOnlyUrl(String url) {
        return HttpClientUtils.doGet(url, null, CHARSET);
    }

    public static String doGetSSL(String url, Map<String, String> params) {
        return HttpClientUtils.doGetSSL(url, params, CHARSET);
    }

    public static String doPost(String url, Map<String, String> params) throws IOException {
        return HttpClientUtils.doPost(url, params, CHARSET);
    }

    public static String doGet(String url, Map<String, String> params, String charset) {
        Assert.notNull((Object)url, (String)(HttpClientUtils.class.getSimpleName() + "\uff1a\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("http\u8bf7\u6c42\u5730\u5740\u5fc5\u987b\u662fhttp\u6216\u8005https\u5f00\u5934");
        }
        try {
            url = HttpClientUtils.sortGetUrl(url, params, charset);
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                String result = null;
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                }
                EntityUtils.consume((HttpEntity)entity);
                response.close();
                return result;
            }
            httpGet.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String doPost(String url, Map<String, String> params, String charset) throws IOException {
        Assert.notNull((Object)url, (String)(HttpClientUtils.class.getSimpleName() + "\uff1a\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("http\u8bf7\u6c42\u5730\u5740\u5fc5\u987b\u662fhttp\u6216\u8005https\u5f00\u5934");
        }
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                pairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }
        HttpPost httpPost = new HttpPost(url);
        if (!pairs.isEmpty()) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
        }
        try (CloseableHttpResponse response = null;){
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                String result = null;
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                }
                EntityUtils.consume((HttpEntity)entity);
                String string = result;
                return string;
            }
            httpPost.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
    }

    public static String doGetSSL(String url, Map<String, String> params, String charset) {
        Assert.notNull((Object)url, (String)(HttpClientUtils.class.getSimpleName() + "\uff1a\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("http\u8bf7\u6c42\u5730\u5740\u5fc5\u987b\u662fhttp\u6216\u8005https\u5f00\u5934");
        }
        try {
            url = HttpClientUtils.sortGetUrl(url, params, charset);
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpClient httpsClient = HttpClientUtils.createSSLClientDefault();
            CloseableHttpResponse response = httpsClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)charset);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String sortGetUrl(String url, Map<String, String> params, String charset) throws IOException {
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                pairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
            url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
        }
        return url;
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return HttpClients.createDefault();
    }

    public static String downloadFileWithGet(String downloadUrl, String filePath) throws IOException {
        return HttpClientUtils.download(downloadUrl, filePath, "GET");
    }

    public static String downloadFileWithPost(String downloadUrl, String filePath) throws IOException {
        return HttpClientUtils.download(downloadUrl, filePath, "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String download(String downloadUrl, String filePath, String method) throws IOException {
        boolean newFile;
        URL url = new URL(downloadUrl);
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        httpUrlConnection.setConnectTimeout(5000);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setRequestMethod(method);
        httpUrlConnection.setRequestProperty("CHARSET", CHARSET);
        httpUrlConnection.connect();
        InputStream fileInputStream = httpUrlConnection.getInputStream();
        File file = new File(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            file.deleteOnExit();
        }
        if (newFile = file.createNewFile()) {
            LOGGER.info("\u6587\u4ef6\u521b\u5efa\u6210\u529f");
        }
        byte[] buffer = new byte[1024];
        FileOutputStream out = new FileOutputStream(file);
        try {
            int byteRead = -1;
            while ((byteRead = fileInputStream.read(buffer)) != -1) {
                out.write(buffer, 0, byteRead);
            }
        }
        finally {
            out.close();
            fileInputStream.close();
        }
        out.close();
        httpUrlConnection.disconnect();
        return filePath;
    }

    static {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }
}

