/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.bestpay.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.sinovatech.unicom.util.sign.exception.CryptException;
import com.tydic.payment.pay.bestpay.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.util.StringUtils;

public class BestPaySign {
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String VERIFY_SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static String sortDataMap(Map<String, String> data) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> treeMap = new TreeMap<String, String>(data);
        for (Map.Entry<String, String> ent : treeMap.entrySet()) {
            String name = ent.getKey();
            if ("sign".equals(name)) continue;
            sb.append(name).append('=').append(ent.getValue()).append('&');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getSign(Map<String, String> signMap, InputStream priKeyFile, String keyPassword) {
        String content = BestPaySign.sortDataMap(signMap);
        System.out.println("\u6392\u5e8f\u540e\u7684\u5f85\u7b7e\u6570\u636e\uff1a" + content);
        RSAPrivateCrtKey privateKey = BestPaySign.getPriKey(priKeyFile, keyPassword);
        return BestPaySign.sign(privateKey, content);
    }

    private static String sign(RSAPrivateCrtKey priKey, String tobeSigned) throws CryptException {
        try {
            Signature sign = Signature.getInstance(SIGNATURE_ALGORITHM);
            sign.initSign(priKey);
            sign.update(tobeSigned.getBytes(StandardCharsets.UTF_8));
            byte[] signed = sign.sign();
            return Base64.encodeAsString(signed);
        }
        catch (Exception e) {
            throw new CryptException("\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private static RSAPrivateCrtKey getPriKey(InputStream priKey, String keyPassword) throws CryptException {
        RSAPrivateCrtKey rsaPrikey = null;
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(priKey, keyPassword.toCharArray());
            Enumeration<String> myEnum = ks.aliases();
            while (myEnum.hasMoreElements()) {
                String keyAlias = myEnum.nextElement();
                if (!ks.isKeyEntry(keyAlias)) continue;
                rsaPrikey = (RSAPrivateCrtKey)ks.getKey(keyAlias, keyPassword.toCharArray());
                break;
            }
        }
        catch (Exception e) {
            if (priKey != null) {
                try {
                    priKey.close();
                }
                catch (IOException e1) {
                    throw new CryptException("\u6d41\u5173\u95ed\u5f02\u5e38", (Exception)e1);
                }
            }
            throw new CryptException("\u52a0\u8f7d\u79c1\u94a5\u5931\u8d25", e);
        }
        if (rsaPrikey == null) {
            throw new CryptException("\u79c1\u94a5\u4e0d\u5b58\u5728");
        }
        return rsaPrikey;
    }

    public static boolean validateSign(String responseData, InputStream publicKeyStream) throws Exception {
        if (StringUtils.isEmpty((Object)responseData)) {
            System.out.println("\u5f85\u9a8c\u7b7e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        responseData = responseData.replace(":null", ":\"null\"");
        JSONObject mapTypes = JSON.parseObject((String)responseData, (Feature[])new Feature[]{Feature.OrderedField});
        Map<String, Object> data = BestPaySign.translateResultData((Map<String, Object>)mapTypes);
        String checkSign = String.valueOf(mapTypes.get("sign"));
        if (StringUtils.isEmpty((Object)checkSign) || "null".equals(checkSign)) {
            System.out.println("\u9a8c\u7b7e\u65f6\uff0c\u672a\u83b7\u53d6\u5230sign");
            return false;
        }
        String checkContent = BestPaySign.assembelSignaturingData(data);
        checkContent = checkContent.replace(":\"null\"", ":null");
        System.out.println("checkContent:" + checkContent);
        return BestPaySign.verifySign(checkSign, checkContent, publicKeyStream);
    }

    private static Map<String, Object> translateResultData(Map<String, Object> res) {
        TreeMap<String, Object> resultDataMap = new TreeMap<String, Object>();
        Set<Map.Entry<String, Object>> set = res.entrySet();
        Map.Entry<String, Object> entry2 = null;
        for (Map.Entry<String, Object> entry2 : set) {
            String key = entry2.getKey();
            Object value = entry2.getValue();
            if (value instanceof String[] || value instanceof Map) {
                resultDataMap.put(key, JSON.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.UseISO8601DateFormat}));
                continue;
            }
            resultDataMap.put(key, value);
        }
        return resultDataMap;
    }

    private static String assembelSignaturingData(Map<String, Object> data) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(data);
        for (Map.Entry<String, Object> ent : treeMap.entrySet()) {
            String name = ent.getKey();
            if ("sign".equals(name)) continue;
            sb.append(name).append('=').append(ent.getValue()).append('&');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static boolean verifySign(String checkSign, String checkContent, InputStream publicKeyStream) {
        X509Certificate pubKey = BestPaySign.getPublicKey(publicKeyStream);
        boolean flag = false;
        try {
            Signature verify = Signature.getInstance(VERIFY_SIGNATURE_ALGORITHM);
            verify.initVerify(pubKey);
            verify.update(checkContent.getBytes(StandardCharsets.UTF_8));
            return verify.verify(Base64.decode(checkSign));
        }
        catch (Exception e) {
            throw new CryptException("\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    private static X509Certificate getPublicKey(InputStream pubKey) throws CryptException {
        X509Certificate x509cert;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509cert = (X509Certificate)cf.generateCertificate(pubKey);
        }
        catch (CertificateException e) {
            if (pubKey != null) {
                try {
                    pubKey.close();
                }
                catch (IOException e1) {
                    throw new CryptException("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38", (Exception)e1);
                }
            }
            throw new CryptException("\u521d\u59cb\u5316\u516c\u94a5\u5f02\u5e38", (Exception)e);
        }
        return x509cert;
    }
}

