/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.chinapay.util;

import com.tydic.payment.pay.chinapay.util.AESUtil;
import com.tydic.payment.pay.chinapay.util.CPEncryptAndDecrypt;
import com.tydic.payment.pay.chinapay.util.CertUtil;
import com.tydic.payment.pay.chinapay.util.SecssConstants;
import com.tydic.payment.pay.chinapay.util.SecureUtil;
import com.tydic.payment.pay.chinapay.util.SecurityException;
import com.tydic.payment.pay.chinapay.util.ZipUtil;
import com.tydic.payment.pay.sdk.unionpay.LogUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecssUtil {
    private static final String SPLIT_CHAR = "|";
    private static final char CHAR_RTN_N = '\n';
    private static final char CHAR_RTN_R = '\r';
    private static final int BUFFER_SIZE = 4096;
    private String sign;
    private String encPin;
    private String encValue;
    private String decValue;
    private String certId;
    private String errCode;
    private String errMsg;
    private boolean initFlag1 = false;
    private boolean initFlag2 = false;
    private long hashLength = 40960L;
    private CertUtil certUtil;
    private static Map<String, CertUtil> certUtilMap = new HashMap<String, CertUtil>();
    private static String CERTUTILMAP_DEFAULT_KEY = "DEFAULT";
    private boolean ignoreCache = false;
    private final Logger Logger = LoggerFactory.getLogger(this.getClass());

    public SecssUtil() {
        this(false);
    }

    public SecssUtil(boolean ignoreCertCache) {
        this.ignoreCache = ignoreCertCache;
    }

    public synchronized boolean init() {
        if (this.initFlag1) {
            LogUtil.writeLog("\u5df2\u7ecf\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u8fc7\u5b89\u5168\u63a7\u4ef6\uff0c\u4e0d\u518d\u4f5c\u91cd\u590d\u521d\u59cb\u5316\u5de5\u4f5c.");
            return true;
        }
        LogUtil.writeLog("\u5f00\u59cb\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6.");
        try {
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            this.loadCertUtil(null);
            this.initFlag1 = true;
            this.initFlag2 = false;
            this.errCode = SecssConstants.SUCCESS;
            boolean bl = true;
            return bl;
        }
        catch (SecurityException var6) {
            LogUtil.writeErrorLog("\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", var6);
            this.errCode = var6.getErrCode();
            this.initFlag1 = false;
            boolean bl = false;
            return bl;
        }
        catch (Exception var7) {
            LogUtil.writeErrorLog("\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", var7);
            this.errCode = SecssConstants.DEFAULTINIT_GOES_WRONG;
            this.initFlag1 = false;
        }
        finally {
            LogUtil.writeLog("\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u7ed3\u675f.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean init(String propPath) {
        LogUtil.writeLog("\u5f00\u59cb\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6.");
        try {
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            this.loadCertUtil(propPath);
            this.initFlag2 = true;
            this.initFlag1 = false;
            this.errCode = SecssConstants.SUCCESS;
            boolean bl = true;
            return bl;
        }
        catch (SecurityException var7) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", var7);
            this.errCode = var7.getErrCode();
            this.initFlag2 = false;
            boolean bl = false;
            return bl;
        }
        catch (Exception var8) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", var8);
            this.errCode = SecssConstants.SPECIFYINIT_GOES_WRONG;
            this.initFlag2 = false;
        }
        finally {
            LogUtil.writeLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u7ed3\u675f.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean init(Properties props) {
        LogUtil.writeLog("\u5f00\u59cb\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6.");
        try {
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            this.certUtil = CertUtil.init(props);
            this.initFlag2 = true;
            this.initFlag1 = false;
            this.errCode = SecssConstants.SUCCESS;
            boolean bl = true;
            return bl;
        }
        catch (SecurityException var7) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", var7);
            this.errCode = var7.getErrCode();
            this.initFlag2 = false;
        }
        catch (Exception var8) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", var8);
            this.errCode = SecssConstants.SPECIFYINIT_GOES_WRONG;
            this.initFlag2 = false;
            boolean bl = false;
            return bl;
        }
        finally {
            LogUtil.writeLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u7ed3\u675f.");
        }
        return false;
    }

    public void clearCert() {
        certUtilMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertUtil(String path) throws SecurityException {
        boolean isPathEmpty;
        String key = null;
        boolean bl = isPathEmpty = path == null || path.trim().length() == 0;
        if (this.ignoreCache) {
            if (isPathEmpty) {
                this.certUtil = CertUtil.init();
            } else {
                Properties pros = this.loadProp(path);
                this.certUtil = CertUtil.init(pros);
            }
        } else {
            key = isPathEmpty ? CERTUTILMAP_DEFAULT_KEY : path;
            this.certUtil = certUtilMap.get(key);
            if (this.certUtil == null) {
                Map<String, CertUtil> map = certUtilMap;
                synchronized (map) {
                    this.certUtil = certUtilMap.get(key);
                    if (this.certUtil == null) {
                        if (isPathEmpty) {
                            this.certUtil = CertUtil.init();
                        } else {
                            Properties pros = this.loadProp(path);
                            this.certUtil = CertUtil.init(pros);
                        }
                        certUtilMap.put(key, this.certUtil);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProp(String propPath) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(propPath);
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (Exception var13) {
            LogUtil.writeErrorLog("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", var13);
            this.errCode = SecssConstants.SPECIFYINIT_GOES_WRONG;
            this.initFlag2 = false;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadSignCert(String certPath, String pass) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u4e4b\u524d\uff0c\u8bf7\u5148\u786e\u4fdd\u5df2\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u8fc7\u63a7\u4ef6");
            return false;
        }
        LogUtil.writeLog("\u5f00\u59cb\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66.");
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            this.certUtil.reloadSignCert(certPath, pass);
            boolean bl = true;
            return bl;
        }
        catch (SecurityException var8) {
            LogUtil.writeErrorLog("\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5f02\u5e38", var8);
            this.errCode = var8.getErrCode();
        }
        catch (Exception var9) {
            LogUtil.writeErrorLog("\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5f02\u5e38", var9);
            this.errCode = SecssConstants.RELOADSC_GOES_WRONG;
            boolean bl = false;
            return bl;
        }
        finally {
            LogUtil.writeLog("\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
        }
        return false;
    }

    public String encodeEnvelope(byte[] dataBytes) {
        return this.encodeEnvelope(dataBytes, true);
    }

    public String encodeEnvelope(byte[] dataBytes, boolean isZip) {
        try {
            if (dataBytes != null && dataBytes.length != 0) {
                if (isZip) {
                    dataBytes = ZipUtil.deflater(dataBytes);
                }
                byte[] key = AESUtil.genAESKey(256);
                byte[] byteContent = AESUtil.encrypt(key, dataBytes);
                StringBuilder sb = new StringBuilder();
                String encryptKey = this.encryptDataLocal(Base64.encodeBase64((byte[])key));
                sb.append(encryptKey);
                sb.append(SPLIT_CHAR);
                sb.append(Base64.encodeBase64String((byte[])byteContent));
                return sb.toString();
            }
            return "";
        }
        catch (Exception var7) {
            throw new RuntimeException(var7);
        }
    }

    public byte[] decodeEnvelope(String envelopeContent) {
        return this.decodeEnvelope(envelopeContent, true);
    }

    public byte[] decodeEnvelope(String envelopeContent, boolean isUnZip) {
        try {
            if (envelopeContent != null && envelopeContent.trim().length() != 0) {
                String[] strs = envelopeContent.split(String.format("[%s]", SPLIT_CHAR), -1);
                String key = strs[0];
                byte[] keyBytes = this.decryptDataLocal(key);
                keyBytes = Base64.decodeBase64((byte[])keyBytes);
                String content = strs[1];
                byte[] byteContent = AESUtil.decrypt(keyBytes, Base64.decodeBase64((String)content));
                if (isUnZip) {
                    byteContent = ZipUtil.inflater(byteContent);
                }
                return byteContent;
            }
            return null;
        }
        catch (Exception var8) {
            throw new RuntimeException(var8);
        }
    }

    public void sign(Map map) {
        this.sign(map, SecssConstants.SIGN512_ALGNAME);
    }

    public void sign(Map map, String signAlg) {
        this.sign(map, signAlg, SecssConstants.SIGN512, this.hashLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sign(Map map, String signAlg, String hashAlg, long hashLength) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u5f00\u59cb.");
            this.sign = null;
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            try {
                PrivateKey priKey;
                String dataStr = this.getSignStr(map, this.certUtil.getSecssConfig().getInvalidFileds(), true);
                LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u524d\u7684\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[" + dataStr + "]");
                byte[] dataBytes = dataStr.getBytes(SecssConstants.CHARSET_COMM);
                if (hashAlg != null && hashAlg.trim().length() > 0 && (long)dataBytes.length > hashLength) {
                    dataBytes = this.hashBytes(hashAlg, dataBytes);
                }
                if ((priKey = this.certUtil.getPriKey()) == null) {
                    throw new Exception("\u83b7\u53d6\u5230\u7684\u79c1\u94a5\u4e3a\u7a7a");
                }
                byte[] signBytes = null;
                signBytes = SecureUtil.sign(dataBytes, priKey, signAlg);
                this.sign = new String(Base64.encodeBase64((byte[])signBytes), SecssConstants.CHARSET_COMM);
                LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u540e\u7684\u5b57\u7b26\u4e32=[" + this.sign + "]");
                this.certId = this.certUtil.getSignCertId();
                LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID=[" + this.certId + "]");
                this.errCode = SecssConstants.SUCCESS;
                return;
            }
            catch (SecurityException var14) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", var14);
                this.errCode = var14.getErrCode();
                return;
            }
            catch (Exception var15) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", var15);
                this.errCode = SecssConstants.SIGN_GOES_WRONG;
            }
            finally {
                LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
            }
        }
    }

    public void signBatch(Map map) {
        this.signBatch(map, SecssConstants.SIGN512_ALGNAME);
    }

    public void signBatch(Map map, String signAlg) {
        this.signBatch(map, signAlg, SecssConstants.SIGN512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signBatch(Map map, String signAlg, String hashAlg) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            LogUtil.writeLog("\u6279\u91cf\u7b7e\u540d\u5904\u7406\u5f00\u59cb.");
            this.sign = null;
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            try {
                PrivateKey priKey;
                String dataStr = this.getSignStr(map, this.certUtil.getSecssConfig().getInvalidFileds(), true);
                LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u524d\u7684\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[" + dataStr + "]");
                byte[] dataBytes = dataStr.getBytes(SecssConstants.CHARSET_COMM);
                if (hashAlg != null && hashAlg.trim().length() > 0) {
                    dataBytes = this.hashBytes(hashAlg, dataBytes);
                }
                if ((priKey = this.certUtil.getPriKey()) == null) {
                    throw new Exception("\u83b7\u53d6\u5230\u7684\u79c1\u94a5\u4e3a\u7a7a");
                }
                byte[] signBytes = null;
                signBytes = SecureUtil.sign(dataBytes, priKey, signAlg);
                this.sign = new String(Base64.encodeBase64((byte[])signBytes), SecssConstants.CHARSET_COMM);
                LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u540e\u7684\u5b57\u7b26\u4e32=[" + this.sign + "]");
                this.certId = this.certUtil.getSignCertId();
                LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID=[" + this.certId + "]");
                this.errCode = SecssConstants.SUCCESS;
                return;
            }
            catch (SecurityException var12) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", var12);
                this.errCode = var12.getErrCode();
                return;
            }
            catch (Exception var13) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", var13);
                this.errCode = SecssConstants.SIGN_GOES_WRONG;
            }
            finally {
                LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
            }
        }
    }

    public void verify(Map map) {
        this.verify(map, SecssConstants.SIGN512_ALGNAME);
    }

    public void verify(Map map, String verifyAlg) {
        this.verify(map, verifyAlg, SecssConstants.SIGN512, this.hashLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verify(Map map, String verifyAlg, String hashAlg, long hashLength) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u9a8c\u7b7e\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            LogUtil.writeLog("\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb.");
            boolean result = false;
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            try {
                String signFieldName = this.certUtil.getSecssConfig().getSignFieldName();
                if (SecssUtil.isEmpty(signFieldName)) {
                    this.errCode = SecssConstants.SIGN_FIELD_NULL;
                    return;
                }
                String signStr = (String)map.get(signFieldName);
                LogUtil.writeLog("\u7b7e\u540d\u4e32=[" + signStr + "]");
                if (!SecssUtil.isEmpty(signStr)) {
                    PublicKey pubKey;
                    List invalidFields = this.certUtil.getSecssConfig().getInvalidFileds();
                    String dataStr = this.getSignStr(map, invalidFields, true);
                    LogUtil.writeLog("\u539f\u62a5\u6587\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[" + dataStr + "]");
                    byte[] dataBytes = dataStr.getBytes(SecssConstants.CHARSET_COMM);
                    if (hashAlg != null && hashAlg.trim().length() > 0 && (long)dataBytes.length > hashLength) {
                        dataBytes = this.hashBytes(hashAlg, dataBytes);
                    }
                    if ((pubKey = this.certUtil.getPubKey()) == null) {
                        throw new Exception("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
                    }
                    byte[] signBytes = Base64.decodeBase64((byte[])signStr.getBytes(SecssConstants.CHARSET_COMM));
                    result = SecureUtil.verify(dataBytes, signBytes, pubKey, verifyAlg);
                    this.errCode = result ? SecssConstants.SUCCESS : SecssConstants.VERIFY_FAILED;
                    LogUtil.writeLog("\u9a8c\u7b7e\u7ed3\u679c=[" + SecssConstants.SUCCESS.equals(this.errCode) + "]");
                    return;
                }
                this.errCode = SecssConstants.SIGN_VALUE_NULL;
                return;
            }
            catch (SecurityException var18) {
                LogUtil.writeErrorLog("\u9a8c\u7b7e\u5f02\u5e38", var18);
                this.errCode = var18.getErrCode();
                return;
            }
            catch (Exception var19) {
                LogUtil.writeErrorLog("\u9a8c\u7b7e\u5f02\u5e38", var19);
                this.errCode = SecssConstants.VERIFY_GOES_WRONG;
            }
            finally {
                LogUtil.writeLog("\u9a8c\u7b7e\u5904\u7406\u7ed3\u675f.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptPin(String pin, String card) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884cPin\u52a0\u5bc6\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            LogUtil.writeLog("Pin\u52a0\u5bc6\u5904\u7406\u5f00\u59cb.");
            this.encPin = null;
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            try {
                byte[] pinBlock = SecureUtil.pin2PinBlockWithCardNO(pin, card);
                if (SecssUtil.isEmpty(pinBlock)) {
                    throw new Exception("\u8ba1\u7b97\u5f97\u5230\u7684PinBlock\u4e3a\u7a7a");
                }
                this.encPin = this.encryptDataLocal(pinBlock);
                this.errCode = SecssConstants.SUCCESS;
                LogUtil.writeLog("Pin\u52a0\u5bc6\u7ed3\u679c=[" + this.encPin + "]");
                return;
            }
            catch (SecurityException var8) {
                LogUtil.writeErrorLog("Pin\u52a0\u5bc6\u5f02\u5e38", var8);
                this.errCode = var8.getErrCode();
                return;
            }
            catch (Exception var9) {
                LogUtil.writeErrorLog("Pin\u52a0\u5bc6\u5f02\u5e38", var9);
                this.errCode = SecssConstants.ENCPIN_GOES_WRONG;
            }
            finally {
                LogUtil.writeLog("Pin\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
            }
        }
    }

    public void encryptData(String data) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u52a0\u5bc6\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            LogUtil.writeLog("\u6570\u636e\u52a0\u5bc6\u5904\u7406\u5f00\u59cb.");
            this.encValue = null;
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            try {
                this.encValue = this.encryptDataLocal(data.getBytes(SecssConstants.CHARSET_COMM));
                this.errCode = SecssConstants.SUCCESS;
                LogUtil.writeLog("\u6570\u636e\u52a0\u5bc6\u7ed3\u679c=[" + this.encValue + "]");
                return;
            }
            catch (SecurityException var7) {
                LogUtil.writeErrorLog("\u6570\u636e\u52a0\u5bc6\u5f02\u5e38", var7);
                this.errCode = var7.getErrCode();
            }
            catch (Exception var8) {
                LogUtil.writeErrorLog("\u6570\u636e\u52a0\u5bc6\u5f02\u5e38", var8);
                this.errCode = SecssConstants.ENCDATA_GOES_WRONG;
                return;
            }
            finally {
                LogUtil.writeLog("\u6570\u636e\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
            }
        }
    }

    public void decryptData(String data) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u89e3\u5bc6\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            LogUtil.writeLog("\u6570\u636e\u89e3\u5bc6\u5904\u7406\u5f00\u59cb.");
            this.decValue = null;
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            try {
                LogUtil.writeLog("\u89e3\u5bc6\u524d\u6570\u636e=[" + data + "]");
                this.decValue = new String(this.decryptDataLocal(data), SecssConstants.CHARSET_COMM);
                this.errCode = SecssConstants.SUCCESS;
                LogUtil.writeLog("\u6570\u636e\u89e3\u5bc6\u7ed3\u679c=[" + this.decValue + "]");
                return;
            }
            catch (SecurityException var7) {
                LogUtil.writeErrorLog("\u6570\u636e\u89e3\u5bc6\u5f02\u5e38", var7);
                this.errCode = var7.getErrCode();
            }
            catch (Exception var8) {
                LogUtil.writeErrorLog("\u6570\u636e\u89e3\u5bc6\u5f02\u5e38", var8);
                this.errCode = SecssConstants.DECDATA_GOES_WRONG;
                return;
            }
            finally {
                LogUtil.writeLog("\u6570\u636e\u89e3\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
            }
        }
    }

    public void getSignCertId() {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u5f00\u59cb.");
            this.certId = null;
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            try {
                this.certId = this.certUtil.getSignCertId();
                LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID=[" + this.certId + "]");
                this.errCode = SecssConstants.SUCCESS;
                return;
            }
            catch (SecurityException var6) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u5f02\u5e38", var6);
                this.errCode = var6.getErrCode();
                return;
            }
            catch (Exception var7) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u5f02\u5e38", var7);
                this.errCode = SecssConstants.GET_CERT_ID_ERROR;
            }
            finally {
                LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u7ed3\u675f.");
            }
        }
    }

    private String encryptDataLocal(byte[] dataBytes) throws SecurityException, Exception {
        PublicKey pubKey = this.certUtil.getPubKey();
        if (pubKey == null) {
            throw new Exception("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
        }
        byte[] encBytes = SecureUtil.encryptData(dataBytes, pubKey.getEncoded());
        return new String(Base64.encodeBase64((byte[])encBytes), SecssConstants.CHARSET_COMM);
    }

    private byte[] decryptDataLocal(String base64Data) throws SecurityException, Exception {
        PrivateKey priKey = this.certUtil.getPriKey();
        if (priKey == null) {
            throw new Exception("\u83b7\u53d6\u5230\u7684\u79c1\u94a5\u4e3a\u7a7a");
        }
        byte[] dataBytes = Base64.decodeBase64((String)base64Data);
        byte[] decBytes = SecureUtil.decryptData(dataBytes, priKey.getEncoded());
        return decBytes;
    }

    private String getSignStr(Map map, List invalidFields, boolean isSort) throws SecurityException {
        StringBuffer param = null;
        ArrayList<String> msgList = null;
        if (map != null && map.size() != 0) {
            try {
                param = new StringBuffer();
                msgList = new ArrayList<String>();
                Iterator it = map.keySet().iterator();
                while (true) {
                    String msg;
                    if (!it.hasNext()) {
                        if (isSort) {
                            Collections.sort(msgList);
                        }
                        for (int i = 0; i < msgList.size(); ++i) {
                            msg = (String)msgList.get(i);
                            if (i > 0) {
                                param.append(SecssConstants.MESSAGE_CONNECT);
                            }
                            param.append(msg);
                        }
                        return param.toString();
                    }
                    msg = (String)it.next();
                    if (invalidFields != null && invalidFields.contains(msg)) continue;
                    String value = (String)map.get(msg);
                    msgList.add(msg + SecssConstants.KEY_VALUE_CONNECT + value);
                }
            }
            catch (Exception var9) {
                LogUtil.writeErrorLog("\u6784\u5efa\u7b7e\u540d\u5b57\u7b26\u4e32\u5f02\u5e38", var9);
                throw new SecurityException(SecssConstants.GET_SIGN_STRING_ERROR);
            }
        }
        throw new SecurityException(SecssConstants.GET_SIGN_STRING_ERROR);
    }

    public static String cpEncryptData(String src) throws Exception {
        CPEncryptAndDecrypt ced = new CPEncryptAndDecrypt();
        byte[] resultData = null;
        try {
            resultData = ced.encryptPassword(src.getBytes(SecssConstants.CHARSET_COMM));
        }
        catch (UnsupportedEncodingException var4) {
            LogUtil.writeErrorLog("\u7f16\u7801\u5f02\u5e38", var4);
        }
        catch (Exception var5) {
            LogUtil.writeErrorLog("\u52a0\u5bc6\u5f02\u5e38", var5);
        }
        if (resultData == null) {
            LogUtil.writeLog("\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
            return null;
        }
        return Base64.encodeBase64String((byte[])resultData);
    }

    public static String cpDecryptData(String str) throws Exception {
        CPEncryptAndDecrypt ced = new CPEncryptAndDecrypt();
        byte[] resultData = null;
        try {
            resultData = ced.decryptPassword(Base64.decodeBase64((String)str));
        }
        catch (UnsupportedEncodingException var4) {
            LogUtil.writeErrorLog("\u7f16\u7801\u5f02\u5e38", var4);
        }
        catch (Exception var5) {
            LogUtil.writeErrorLog("\u89e3\u5bc6\u5f02\u5e38", var5);
        }
        if (resultData == null) {
            LogUtil.writeLog("\u89e3\u5bc6\u6570\u636e\u5931\u8d25");
            return null;
        }
        return new String(resultData, SecssConstants.CHARSET_COMM);
    }

    public void signFile(String filePath) {
        this.signFile(filePath, SecssConstants.SIGN512_ALGNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void signFile(String filePath, String sigAlgName) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            File f = new File(filePath);
            if (f != null && f.exists()) {
                byte[] sha512Bytes;
                block43: {
                    sha512Bytes = null;
                    BufferedInputStream is = null;
                    try {
                        MessageDigest digest = MessageDigest.getInstance(SecssConstants.SIGN512);
                        is = new BufferedInputStream(new FileInputStream(f));
                        byte[] buffer = new byte[4096];
                        int readCount = is.read(buffer, 0, 4096);
                        int startPos = 0;
                        while (readCount != -1) {
                            int i;
                            for (i = 0; i < readCount; ++i) {
                                if (buffer[i] != 13 && buffer[i] != 10) continue;
                                if (i - startPos > 0) {
                                    digest.update(buffer, startPos, i - startPos);
                                }
                                startPos = i + 1;
                            }
                            if (i - startPos > 0) {
                                digest.update(buffer, startPos, i - startPos);
                            }
                            startPos = 0;
                            readCount = is.read(buffer, 0, 4096);
                        }
                        sha512Bytes = digest.digest();
                        if (this.Logger.isDebugEnabled()) {
                            String base64 = Base64.encodeBase64String((byte[])sha512Bytes);
                            LogUtil.writeLog("middle sign = " + base64);
                        }
                        break block43;
                    }
                    catch (FileNotFoundException var42) {
                        LogUtil.writeErrorLog("\u6587\u4ef6\u4e0d\u5b58\u5728", var42);
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                    }
                    catch (NoSuchAlgorithmException var43) {
                        LogUtil.writeErrorLog("\u7b97\u6cd5\u4e0d\u5b58\u5728", var43);
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                        return;
                    }
                    catch (UnsupportedEncodingException var44) {
                        LogUtil.writeErrorLog("\u4e0d\u652f\u6301\u7684\u7f16\u7801", var44);
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                        return;
                    }
                    catch (IOException var45) {
                        LogUtil.writeErrorLog("io\u5f02\u5e38", var45);
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException var42) {}
                        }
                    }
                    return;
                }
                if (sha512Bytes == null) {
                    LogUtil.writeErrorLog("\u7b7e\u540d\u5931\u8d25");
                    this.errCode = SecssConstants.SIGN_GOES_WRONG;
                } else {
                    String sign = this.signDataBytes(sha512Bytes, sigAlgName);
                    if (sign != null && sign.trim().length() > 0) {
                        try (PrintWriter writer = null;){
                            writer = new PrintWriter(new FileWriter(f, true));
                            writer.print(SecssConstants.RETURN_LINE);
                            writer.print(sign);
                            this.errCode = SecssConstants.SUCCESS;
                        }
                    } else {
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                    }
                }
            } else {
                LogUtil.writeErrorLog("\u6587\u4ef6\u4e0d\u5b58\u5728");
                this.errCode = SecssConstants.VERIFY_FAILED;
            }
        }
    }

    private String signDataBytes(byte[] dataBytes, String sigAlgName) {
        String sign = null;
        try {
            PrivateKey priKey = this.certUtil.getPriKey();
            if (priKey == null) {
                LogUtil.writeErrorLog("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
                this.errCode = SecssConstants.SIGN_GOES_WRONG;
                return null;
            }
            Signature signature = Signature.getInstance(sigAlgName);
            signature.initSign(priKey);
            signature.update(dataBytes);
            sign = new String(Base64.encodeBase64((byte[])signature.sign()));
            return sign;
        }
        catch (InvalidKeyException var6) {
            LogUtil.writeErrorLog("\u79d8\u94a5\u4e0d\u6b63\u786e", var6);
            this.errCode = SecssConstants.SIGN_GOES_WRONG;
            return null;
        }
        catch (NoSuchAlgorithmException var7) {
            LogUtil.writeErrorLog("\u7b97\u6cd5\u4e0d\u5b58\u5728", var7);
            this.errCode = SecssConstants.SIGN_GOES_WRONG;
            return null;
        }
        catch (SignatureException var8) {
            LogUtil.writeErrorLog("\u9a8c\u7b7e\u5931\u8d25", var8);
            this.errCode = SecssConstants.SIGN_GOES_WRONG;
            return null;
        }
    }

    public void verifyFile(String filePath) {
        this.verifyFile(filePath, SecssConstants.SIGN512_ALGNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void verifyFile(String filePath, String sigAlgName) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
        } else {
            File f = new File(filePath);
            if (f != null && f.exists()) {
                int signLenth;
                byte[] signBytes;
                block55: {
                    signBytes = null;
                    RandomAccessFile raf = null;
                    boolean var6 = true;
                    try {
                        long filePos;
                        raf = new RandomAccessFile(f, "r");
                        for (filePos = f.length(); filePos >= 0L; --filePos) {
                            raf.seek(filePos - 1L);
                            byte b = (byte)raf.read();
                            if (b == 13 || b == 10) break;
                        }
                        signLenth = (int)(raf.length() - filePos);
                        byte[] temp = new byte[signLenth];
                        raf.read(temp, 0, signLenth);
                        if (this.Logger.isDebugEnabled()) {
                            LogUtil.writeLog("sign = " + new String(temp));
                        }
                        signBytes = Base64.decodeBase64((byte[])temp);
                        break block55;
                    }
                    catch (FileNotFoundException var56) {
                        LogUtil.writeErrorLog("\u6587\u4ef6\u4e0d\u5b58\u5728", var56);
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                        return;
                    }
                    catch (IOException var57) {
                        LogUtil.writeErrorLog("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", var57);
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                    }
                    finally {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    return;
                }
                if (signBytes == null) {
                    LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u5931\u8d25");
                    this.errCode = SecssConstants.SIGN_GOES_WRONG;
                } else {
                    byte[] sha512Bytes;
                    block57: {
                        sha512Bytes = null;
                        long leftLenth = f.length();
                        BufferedInputStream is = null;
                        try {
                            MessageDigest digest = MessageDigest.getInstance(SecssConstants.SIGN512);
                            is = new BufferedInputStream(new FileInputStream(f));
                            byte[] buffer = new byte[4096];
                            int readCount = is.read(buffer, 0, 4096);
                            int startPos = 0;
                            while (readCount != -1) {
                                int i;
                                for (i = 0; i < readCount && leftLenth > (long)signLenth; ++i, --leftLenth) {
                                    if (buffer[i] != 13 && buffer[i] != 10) continue;
                                    if (i - startPos > 0) {
                                        digest.update(buffer, startPos, i - startPos);
                                    }
                                    startPos = i + 1;
                                }
                                if (i - startPos > 0) {
                                    digest.update(buffer, startPos, i - startPos);
                                }
                                if (leftLenth <= (long)signLenth) break;
                                startPos = 0;
                                readCount = is.read(buffer, 0, 4096);
                            }
                            sha512Bytes = digest.digest();
                            if (this.Logger.isDebugEnabled()) {
                                String base64 = Base64.encodeBase64String((byte[])sha512Bytes);
                                LogUtil.writeLog("middle sign = " + base64);
                            }
                            break block57;
                        }
                        catch (FileNotFoundException var51) {
                            LogUtil.writeErrorLog("\u6587\u4ef6\u4e0d\u5b58\u5728", var51);
                            this.errCode = SecssConstants.SIGN_GOES_WRONG;
                        }
                        catch (NoSuchAlgorithmException var52) {
                            LogUtil.writeErrorLog("\u7b97\u6cd5\u4e0d\u5b58\u5728", var52);
                            this.errCode = SecssConstants.SIGN_GOES_WRONG;
                            return;
                        }
                        catch (UnsupportedEncodingException var53) {
                            LogUtil.writeErrorLog("\u4e0d\u652f\u6301\u7684\u7f16\u7801", var53);
                            this.errCode = SecssConstants.SIGN_GOES_WRONG;
                            return;
                        }
                        catch (IOException var54) {
                            LogUtil.writeErrorLog("io\u5f02\u5e38", var54);
                            this.errCode = SecssConstants.SIGN_GOES_WRONG;
                            return;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException var51) {}
                            }
                        }
                        return;
                    }
                    if (sha512Bytes == null) {
                        LogUtil.writeErrorLog("\u7b7e\u540d\u5931\u8d25");
                        this.errCode = SecssConstants.SIGN_GOES_WRONG;
                    } else {
                        boolean result = this.verifyFile(sha512Bytes, signBytes, sigAlgName);
                        this.errCode = result ? SecssConstants.SUCCESS : SecssConstants.VERIFY_FAILED;
                    }
                }
            } else {
                LogUtil.writeErrorLog("\u6587\u4ef6\u4e0d\u5b58\u5728");
                this.errCode = SecssConstants.VERIFY_FAILED;
            }
        }
    }

    private boolean verifyFile(byte[] dataBytes, byte[] signBytes, String sigAlgName) {
        boolean isSucess = false;
        try {
            PublicKey pubKey = this.certUtil.getPubKey();
            if (pubKey == null) {
                LogUtil.writeErrorLog("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
                this.errCode = SecssConstants.VERIFY_FAILED;
                return false;
            }
            Signature signature = Signature.getInstance(sigAlgName);
            signature.initVerify(pubKey);
            signature.update(dataBytes);
            isSucess = signature.verify(signBytes);
        }
        catch (InvalidKeyException var7) {
            LogUtil.writeErrorLog("\u79d8\u94a5\u4e0d\u6b63\u786e", var7);
            this.errCode = SecssConstants.VERIFY_FAILED;
            isSucess = false;
        }
        catch (NoSuchAlgorithmException var8) {
            LogUtil.writeErrorLog("\u7b97\u6cd5\u4e0d\u5b58\u5728", var8);
            this.errCode = SecssConstants.VERIFY_FAILED;
            isSucess = false;
        }
        catch (SignatureException var9) {
            LogUtil.writeErrorLog("\u9a8c\u7b7e\u5931\u8d25", var9);
            this.errCode = SecssConstants.VERIFY_FAILED;
            isSucess = false;
        }
        return isSucess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] hashBytes(String hashAlg, byte[] dataBytes) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(hashAlg.trim());
        ByteArrayInputStream is = null;
        try {
            byte[] var9;
            is = new ByteArrayInputStream(dataBytes);
            byte[] buffer = new byte[4096];
            int readCount = is.read(buffer, 0, 4096);
            while (readCount != -1) {
                digest.update(buffer, 0, readCount);
                readCount = is.read(buffer, 0, 4096);
            }
            dataBytes = digest.digest();
            String base64 = Base64.encodeBase64String((byte[])dataBytes);
            LogUtil.writeLog("hash = " + base64);
            byte[] byArray = var9 = dataBytes;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public static boolean isEmpty(byte[] b) {
        return b == null || b.length < 1;
    }

    public String getSign() {
        return this.sign;
    }

    public String getEncPin() {
        return this.encPin;
    }

    public String getEncValue() {
        return this.encValue;
    }

    public String getDecValue() {
        return this.decValue;
    }

    public String getCertId() {
        return this.certId;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        this.errMsg = SecssUtil.isEmpty(this.errCode) ? (String)SecssConstants.ERRMAP.get(SecssConstants.UNKNOWN_WRONG) : (String)SecssConstants.ERRMAP.get(this.errCode);
        if (SecssUtil.isEmpty(this.errMsg)) {
            this.errMsg = (String)SecssConstants.ERRMAP.get(SecssConstants.UNKNOWN_WRONG);
        }
        return this.errMsg;
    }

    public long getHashLength() {
        return this.hashLength;
    }

    public void setHashLength(long hashLength) {
        this.hashLength = hashLength;
    }

    public static void main(String[] args) throws Exception {
        String str = "\u4f60\u597d";
        String enStr = SecssUtil.cpEncryptData(str);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u6570\u636e\uff1a" + enStr);
        String decStr = SecssUtil.cpDecryptData(enStr);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u6570\u636e:" + decStr);
    }
}

