/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.chinapay.util;

import com.tydic.payment.pay.chinapay.util.SecssConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZipUtil {
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflater(byte[] inputByte) {
        Deflater compresser = new Deflater();
        compresser.setInput(inputByte);
        compresser.finish();
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            byte[] result = new byte[1024];
            while (!compresser.finished()) {
                int compressedDataLength = compresser.deflate(result);
                bos.write(result, 0, compressedDataLength);
            }
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
        compresser.end();
        return bos.toByteArray();
    }

    public static byte[] inflater(byte[] inputByte) {
        Inflater compresser = new Inflater();
        compresser.setInput(inputByte);
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream(inputByte.length);
            byte[] result = new byte[1024];
            while (!compresser.finished()) {
                int compressedDataLength = compresser.inflate(result);
                bos.write(result, 0, compressedDataLength);
            }
        }
        catch (DataFormatException var12) {
            throw new RuntimeException(var12);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bos.toByteArray();
    }

    public static void main(String[] args) throws IOException {
        byte[] inputByte = "test\u7b2c\u4e09\u65b9test\u7b2c\u4e09\u65b9test\u7b2c\u4e09\u65b9".getBytes(SecssConstants.CHARSET_COMM);
        System.out.println(String.format("input length = %s", inputByte.length));
        byte[] zipByte = ZipUtil.deflater(inputByte);
        System.out.println(String.format("zip length = %s", zipByte.length));
        byte[] outputByte = ZipUtil.inflater(zipByte);
        System.out.println(String.format("output length = %s", outputByte.length));
        System.out.println(new String(outputByte, SecssConstants.CHARSET_COMM));
    }
}

