/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.icbc;

import com.tydic.payment.pay.icbc.IcbcApiException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AES {
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = AES.initIv("AES/CBC/PKCS5Padding");
    private static final String CHARSET_UTF8 = "UTF-8";

    public static String aesEncrypt(String content, String aesKey) throws IcbcApiException {
        return AES.aesEncrypt(content, aesKey, CHARSET_UTF8);
    }

    public static String aesEncrypt(String content, String aesKey, String charset) throws IcbcApiException {
        try {
            return new String(AES.aesEncrypt(content.getBytes(charset), aesKey));
        }
        catch (Exception e) {
            throw new IcbcApiException("AES\u52a0\u5bc6\u5931\u8d25\uff1aAescontent = " + content + "; charset = " + charset, e);
        }
    }

    public static byte[] aesEncrypt(byte[] content, String aesKey) throws IcbcApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(1, (Key)new SecretKeySpec(Base64.decodeBase64((String)aesKey), AES_ALG), iv);
            byte[] encryptBytes = cipher.doFinal(content);
            return Base64.encodeBase64((byte[])encryptBytes);
        }
        catch (Exception e) {
            throw new IcbcApiException("AES\u52a0\u5bc6\u5931\u8d25\uff1aAescontent = " + content, e);
        }
    }

    public static String aesDecrypt(String content, String aesKey) throws IcbcApiException {
        return AES.aesDecrypt(content, aesKey, CHARSET_UTF8);
    }

    public static byte[] aesDecrypt(byte[] content, String aesKey) throws IcbcApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(2, (Key)new SecretKeySpec(Base64.decodeBase64((String)aesKey), AES_ALG), iv);
            return cipher.doFinal(Base64.decodeBase64((byte[])content));
        }
        catch (Exception e) {
            throw new IcbcApiException("AES\u89e3\u5bc6\u5931\u8d25\uff1aAescontent = " + content, e);
        }
    }

    public static String aesDecrypt(String content, String aesKey, String charset) throws IcbcApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(2, (Key)new SecretKeySpec(Base64.decodeBase64((String)aesKey), AES_ALG), iv);
            byte[] cleanBytes = cipher.doFinal(Base64.decodeBase64((String)content));
            return new String(cleanBytes, charset);
        }
        catch (Exception e) {
            throw new IcbcApiException("AES\u89e3\u5bc6\u5931\u8d25\uff1aAescontent = " + content + "; charset = " + charset, e);
        }
    }

    private static byte[] initIv(String fullAlg) {
        try {
            Cipher cipher = Cipher.getInstance(fullAlg);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }
}

