/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.wx.req.bo;

import com.tydic.payment.pay.wx.util.RandomStringGenerator;
import com.tydic.payment.pay.wx.util.Signature;
import com.tydic.payment.pay.wx.util.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class WXApiMicroPayReqBO {
    private static final int expireTime = 3;
    private String appid;
    private String sub_appid;
    private String mch_id;
    private String sub_mch_id;
    private String device_info;
    private String nonce_str;
    private String sign;
    private String body;
    private String detail;
    private String attach;
    private String out_trade_no;
    private int total_fee;
    private String fee_type;
    private String spbill_create_ip;
    private String goods_tag;
    private String limit_pay;
    private String time_start;
    private String time_expire;
    private String auth_code;
    private String scene_info;
    private String key = "";

    public WXApiMicroPayReqBO setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public WXApiMicroPayReqBO setSub_appid(String sub_appid) {
        this.sub_appid = sub_appid;
        return this;
    }

    public WXApiMicroPayReqBO setMch_id(String mch_id) {
        this.mch_id = mch_id;
        return this;
    }

    public WXApiMicroPayReqBO setSub_mch_id(String sub_mch_id) {
        this.sub_mch_id = sub_mch_id;
        return this;
    }

    public WXApiMicroPayReqBO setDevice_info(String device_info) {
        this.device_info = device_info;
        return this;
    }

    public WXApiMicroPayReqBO setNonce_str(String nonce_str) {
        this.nonce_str = StringUtils.isNotEmpty((String)nonce_str) ? nonce_str : RandomStringGenerator.getRandomStringByLength(32);
        return this;
    }

    public WXApiMicroPayReqBO setBody(String body) {
        this.body = body;
        return this;
    }

    public WXApiMicroPayReqBO setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public WXApiMicroPayReqBO setAttach(String attach) {
        this.attach = attach;
        return this;
    }

    public WXApiMicroPayReqBO setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
        return this;
    }

    public WXApiMicroPayReqBO setTotal_fee(int total_fee) {
        this.total_fee = total_fee;
        return this;
    }

    public WXApiMicroPayReqBO setFee_type(String fee_type) {
        this.fee_type = fee_type;
        return this;
    }

    public WXApiMicroPayReqBO setSpbill_create_ip(String spbill_create_ip) {
        this.spbill_create_ip = spbill_create_ip;
        return this;
    }

    public WXApiMicroPayReqBO setGoods_tag(String goods_tag) {
        this.goods_tag = goods_tag;
        return this;
    }

    public WXApiMicroPayReqBO setLimit_pay(String limit_pay) {
        this.limit_pay = limit_pay;
        return this;
    }

    public WXApiMicroPayReqBO setTime_start(Date time_start) {
        this.time_start = new SimpleDateFormat("yyyyMMddHHmmss").format(time_start.getTime());
        return this;
    }

    public WXApiMicroPayReqBO setTime_expire(Date time_expire) throws ParseException {
        this.time_expire = time_expire != null ? new SimpleDateFormat("yyyyMMddHHmmss").format(time_expire.getTime()) : new SimpleDateFormat("yyyyMMddHHmmss").format(new SimpleDateFormat("yyyyMMddHHmmss").parse(this.getTime_start()).getTime() + 180000L);
        return this;
    }

    public WXApiMicroPayReqBO setAuth_code(String auth_code) {
        this.auth_code = auth_code;
        return this;
    }

    public WXApiMicroPayReqBO setScene_info(String scene_info) {
        this.scene_info = scene_info;
        return this;
    }

    public WXApiMicroPayReqBO setKey(String key) {
        this.sign = Signature.getSign(Util.beanToMapForWxSign(this), key);
        this.key = key;
        return this;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getSub_appid() {
        return this.sub_appid;
    }

    public String getMch_id() {
        return this.mch_id;
    }

    public String getSub_mch_id() {
        return this.sub_mch_id;
    }

    public String getDevice_info() {
        return this.device_info;
    }

    public String getNonce_str() {
        return this.nonce_str;
    }

    public String getSign() {
        return this.sign;
    }

    public String getBody() {
        return this.body;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getAttach() {
        return this.attach;
    }

    public String getOut_trade_no() {
        return this.out_trade_no;
    }

    public int getTotal_fee() {
        return this.total_fee;
    }

    public String getFee_type() {
        return this.fee_type;
    }

    public String getSpbill_create_ip() {
        return this.spbill_create_ip;
    }

    public String getGoods_tag() {
        return this.goods_tag;
    }

    public String getLimit_pay() {
        return this.limit_pay;
    }

    public String getTime_start() {
        return this.time_start;
    }

    public String getTime_expire() {
        return this.time_expire;
    }

    public String getAuth_code() {
        return this.auth_code;
    }

    public String getScene_info() {
        return this.scene_info;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return "WXApiMicroPayReqBO [appid=" + this.appid + ", sub_appid=" + this.sub_appid + ", mch_id=" + this.mch_id + ", sub_mch_id=" + this.sub_mch_id + ", device_info=" + this.device_info + ", nonce_str=" + this.nonce_str + ", sign=" + this.sign + ", body=" + this.body + ", detail=" + this.detail + ", attach=" + this.attach + ", out_trade_no=" + this.out_trade_no + ", total_fee=" + this.total_fee + ", fee_type=" + this.fee_type + ", spbill_create_ip=" + this.spbill_create_ip + ", goods_tag=" + this.goods_tag + ", limit_pay=" + this.limit_pay + ", time_start=" + this.time_start + ", time_expire=" + this.time_expire + ", auth_code=" + this.auth_code + ", scene_info=" + this.scene_info + ", toString()=" + super.toString() + "]";
    }
}

