/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.AutoWithdrawRuleSetRequest;
import java.util.Map;
import java.util.UUID;

public class AutoWithdrawRuleSetRequestMarshaller
implements RequestMarshaller<AutoWithdrawRuleSetRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/auto-withdraw-rule/set";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<AutoWithdrawRuleSetRequest> marshall(AutoWithdrawRuleSetRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/auto-withdraw-rule/set");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getBindId() != null) {
            internalRequest.addParameter("bindId", PrimitiveMarshallerUtils.marshalling((Object)request.getBindId(), (String)"String"));
        }
        if (request.getBankAccountNo() != null) {
            internalRequest.addParameter("bankAccountNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBankAccountNo(), (String)"String"));
        }
        if (request.getReceiveType() != null) {
            internalRequest.addParameter("receiveType", PrimitiveMarshallerUtils.marshalling((Object)request.getReceiveType(), (String)"String"));
        }
        if (request.getTriggerTime() != null) {
            internalRequest.addParameter("triggerTime", PrimitiveMarshallerUtils.marshalling((Object)request.getTriggerTime(), (String)"String"));
        }
        if (request.getRemainAmount() != null) {
            internalRequest.addParameter("remainAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getRemainAmount(), (String)"BigDecimal"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling((Object)request.getRemark(), (String)"String"));
        }
        if (request.getNotifyAddress() != null) {
            internalRequest.addParameter("notifyAddress", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyAddress(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static AutoWithdrawRuleSetRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static AutoWithdrawRuleSetRequestMarshaller INSTANCE = new AutoWithdrawRuleSetRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

