/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.nccashierapi.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.nccashierapi.request.ApiPayRequest;
import java.util.Map;
import java.util.UUID;

public class ApiPayRequestMarshaller
implements RequestMarshaller<ApiPayRequest> {
    private final String serviceName = "Nccashierapi";
    private final String resourcePath = "/rest/v1.0/nccashierapi/api/pay";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<ApiPayRequest> marshall(ApiPayRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Nccashierapi");
        internalRequest.setResourcePath("/rest/v1.0/nccashierapi/api/pay");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getPayTool() != null) {
            internalRequest.addParameter("payTool", PrimitiveMarshallerUtils.marshalling((Object)request.getPayTool(), (String)"String"));
        }
        if (request.getPayType() != null) {
            internalRequest.addParameter("payType", PrimitiveMarshallerUtils.marshalling((Object)request.getPayType(), (String)"String"));
        }
        if (request.getToken() != null) {
            internalRequest.addParameter("token", PrimitiveMarshallerUtils.marshalling((Object)request.getToken(), (String)"String"));
        }
        if (request.getAppId() != null) {
            internalRequest.addParameter("appId", PrimitiveMarshallerUtils.marshalling((Object)request.getAppId(), (String)"String"));
        }
        if (request.getOpenId() != null) {
            internalRequest.addParameter("openId", PrimitiveMarshallerUtils.marshalling((Object)request.getOpenId(), (String)"String"));
        }
        if (request.getVersion() != null) {
            internalRequest.addParameter("version", PrimitiveMarshallerUtils.marshalling((Object)request.getVersion(), (String)"String"));
        }
        if (request.getPayEmpowerNo() != null) {
            internalRequest.addParameter("payEmpowerNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayEmpowerNo(), (String)"String"));
        }
        if (request.getMerchantTerminalId() != null) {
            internalRequest.addParameter("merchantTerminalId", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantTerminalId(), (String)"String"));
        }
        if (request.getMerchantStoreNo() != null) {
            internalRequest.addParameter("merchantStoreNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantStoreNo(), (String)"String"));
        }
        if (request.getUserIp() != null) {
            internalRequest.addParameter("userIp", PrimitiveMarshallerUtils.marshalling((Object)request.getUserIp(), (String)"String"));
        }
        if (request.getExtParamMap() != null) {
            internalRequest.addParameter("extParamMap", PrimitiveMarshallerUtils.marshalling((Object)request.getExtParamMap(), (String)"String"));
        }
        if (request.getUserNo() != null) {
            internalRequest.addParameter("userNo", PrimitiveMarshallerUtils.marshalling((Object)request.getUserNo(), (String)"String"));
        }
        if (request.getUserType() != null) {
            internalRequest.addParameter("userType", PrimitiveMarshallerUtils.marshalling((Object)request.getUserType(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static ApiPayRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static ApiPayRequestMarshaller INSTANCE = new ApiPayRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

