/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.std.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.std.request.CertOrderRequest;
import java.util.Map;
import java.util.UUID;

public class CertOrderRequestMarshaller
implements RequestMarshaller<CertOrderRequest> {
    private final String serviceName = "Std";
    private final String resourcePath = "/rest/v1.0/std/cert/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<CertOrderRequest> marshall(CertOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Std");
        internalRequest.setResourcePath("/rest/v1.0/std/cert/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getAuthType() != null) {
            internalRequest.addParameter("authType", PrimitiveMarshallerUtils.marshalling((Object)request.getAuthType(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getIdCardNo() != null) {
            internalRequest.addParameter("idCardNo", PrimitiveMarshallerUtils.marshalling((Object)request.getIdCardNo(), (String)"String"));
        }
        if (request.getUserName() != null) {
            internalRequest.addParameter("userName", PrimitiveMarshallerUtils.marshalling((Object)request.getUserName(), (String)"String"));
        }
        if (request.getBankCardNo() != null) {
            internalRequest.addParameter("bankCardNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCardNo(), (String)"String"));
        }
        if (request.getRequestTime() != null) {
            internalRequest.addParameter("requestTime", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestTime(), (String)"String"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling((Object)request.getRemark(), (String)"String"));
        }
        if (request.getMobilePhone() != null) {
            internalRequest.addParameter("mobilePhone", PrimitiveMarshallerUtils.marshalling((Object)request.getMobilePhone(), (String)"String"));
        }
        if (request.getIdCardType() != null) {
            internalRequest.addParameter("idCardType", PrimitiveMarshallerUtils.marshalling((Object)request.getIdCardType(), (String)"String"));
        }
        if (request.getClientSource() != null) {
            internalRequest.addParameter("clientSource", PrimitiveMarshallerUtils.marshalling((Object)request.getClientSource(), (String)"String"));
        }
        if (request.getExtMap() != null) {
            internalRequest.addParameter("extMap", PrimitiveMarshallerUtils.marshalling((Object)request.getExtMap(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static CertOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static CertOrderRequestMarshaller INSTANCE = new CertOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

