/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.sys.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.sys.request.TradeOrderRequest;
import java.util.Map;
import java.util.UUID;

public class TradeOrderRequestMarshaller
implements RequestMarshaller<TradeOrderRequest> {
    private final String serviceName = "Sys";
    private final String resourcePath = "/rest/v1.0/sys/trade/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<TradeOrderRequest> marshall(TradeOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Sys");
        internalRequest.setResourcePath("/rest/v1.0/sys/trade/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"String"));
        }
        if (request.getTimeoutExpress() != null) {
            internalRequest.addParameter("timeoutExpress", PrimitiveMarshallerUtils.marshalling((Object)request.getTimeoutExpress(), (String)"Integer"));
        }
        if (request.getTimeoutExpressType() != null) {
            internalRequest.addParameter("timeoutExpressType", PrimitiveMarshallerUtils.marshalling((Object)request.getTimeoutExpressType(), (String)"String"));
        }
        if (request.getRequestDate() != null) {
            internalRequest.addParameter("requestDate", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestDate(), (String)"String"));
        }
        if (request.getRedirectUrl() != null) {
            internalRequest.addParameter("redirectUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getRedirectUrl(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getAssureType() != null) {
            internalRequest.addParameter("assureType", PrimitiveMarshallerUtils.marshalling((Object)request.getAssureType(), (String)"String"));
        }
        if (request.getAssurePeriod() != null) {
            internalRequest.addParameter("assurePeriod", PrimitiveMarshallerUtils.marshalling((Object)request.getAssurePeriod(), (String)"String"));
        }
        if (request.getGoodsParamExt() != null) {
            internalRequest.addParameter("goodsParamExt", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsParamExt(), (String)"String"));
        }
        if (request.getPaymentParamExt() != null) {
            internalRequest.addParameter("paymentParamExt", PrimitiveMarshallerUtils.marshalling((Object)request.getPaymentParamExt(), (String)"String"));
        }
        if (request.getIndustryParamExt() != null) {
            internalRequest.addParameter("industryParamExt", PrimitiveMarshallerUtils.marshalling((Object)request.getIndustryParamExt(), (String)"String"));
        }
        if (request.getRiskParamExt() != null) {
            internalRequest.addParameter("riskParamExt", PrimitiveMarshallerUtils.marshalling((Object)request.getRiskParamExt(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getHmac() != null) {
            internalRequest.addParameter("hmac", PrimitiveMarshallerUtils.marshalling((Object)request.getHmac(), (String)"String"));
        }
        if (request.getDivideDetail() != null) {
            internalRequest.addParameter("divideDetail", PrimitiveMarshallerUtils.marshalling((Object)request.getDivideDetail(), (String)"String"));
        }
        if (request.getCsUrl() != null) {
            internalRequest.addParameter("csUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCsUrl(), (String)"String"));
        }
        if (request.getDivideNotifyUrl() != null) {
            internalRequest.addParameter("divideNotifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getDivideNotifyUrl(), (String)"String"));
        }
        if (request.getTimeoutNotifyUrl() != null) {
            internalRequest.addParameter("timeoutNotifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getTimeoutNotifyUrl(), (String)"String"));
        }
        if (request.getSiSubsidyMerchantAmout() != null) {
            internalRequest.addParameter("siSubsidyMerchantAmout", PrimitiveMarshallerUtils.marshalling((Object)request.getSiSubsidyMerchantAmout(), (String)"String"));
        }
        if (request.getQueryParamsExt() != null) {
            internalRequest.addParameter("queryParamsExt", PrimitiveMarshallerUtils.marshalling((Object)request.getQueryParamsExt(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static TradeOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static TradeOrderRequestMarshaller INSTANCE = new TradeOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

