/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.sys.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.sys.request.TradeRefundRequest;
import java.util.Map;
import java.util.UUID;

public class TradeRefundRequestMarshaller
implements RequestMarshaller<TradeRefundRequest> {
    private final String serviceName = "Sys";
    private final String resourcePath = "/rest/v1.0/sys/trade/refund";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<TradeRefundRequest> marshall(TradeRefundRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Sys");
        internalRequest.setResourcePath("/rest/v1.0/sys/trade/refund");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getRefundRequestId() != null) {
            internalRequest.addParameter("refundRequestId", PrimitiveMarshallerUtils.marshalling((Object)request.getRefundRequestId(), (String)"String"));
        }
        if (request.getUniqueOrderNo() != null) {
            internalRequest.addParameter("uniqueOrderNo", PrimitiveMarshallerUtils.marshalling((Object)request.getUniqueOrderNo(), (String)"String"));
        }
        if (request.getRefundAmount() != null) {
            internalRequest.addParameter("refundAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getRefundAmount(), (String)"String"));
        }
        if (request.getAccountDivided() != null) {
            internalRequest.addParameter("accountDivided", PrimitiveMarshallerUtils.marshalling((Object)request.getAccountDivided(), (String)"String"));
        }
        if (request.getDescription() != null) {
            internalRequest.addParameter("description", PrimitiveMarshallerUtils.marshalling((Object)request.getDescription(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getHmac() != null) {
            internalRequest.addParameter("hmac", PrimitiveMarshallerUtils.marshalling((Object)request.getHmac(), (String)"String"));
        }
        if (request.getMerchantSideMarketingRefundDetails() != null) {
            internalRequest.addParameter("merchantSideMarketingRefundDetails", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantSideMarketingRefundDetails(), (String)"String"));
        }
        if (request.getRefundAccountType() != null) {
            internalRequest.addParameter("refundAccountType", PrimitiveMarshallerUtils.marshalling((Object)request.getRefundAccountType(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static TradeRefundRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static TradeRefundRequestMarshaller INSTANCE = new TradeRefundRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

