/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.PayOrderRequest;
import java.util.Map;
import java.util.UUID;

public class PayOrderRequestMarshaller
implements RequestMarshaller<PayOrderRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/pay/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<PayOrderRequest> marshall(PayOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/pay/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getFeeChargeSide() != null) {
            internalRequest.addParameter("feeChargeSide", PrimitiveMarshallerUtils.marshalling((Object)request.getFeeChargeSide(), (String)"String"));
        }
        if (request.getReceiveType() != null) {
            internalRequest.addParameter("receiveType", PrimitiveMarshallerUtils.marshalling((Object)request.getReceiveType(), (String)"String"));
        }
        if (request.getReceiverAccountNo() != null) {
            internalRequest.addParameter("receiverAccountNo", PrimitiveMarshallerUtils.marshalling((Object)request.getReceiverAccountNo(), (String)"String"));
        }
        if (request.getReceiverAccountName() != null) {
            internalRequest.addParameter("receiverAccountName", PrimitiveMarshallerUtils.marshalling((Object)request.getReceiverAccountName(), (String)"String"));
        }
        if (request.getReceiverBankCode() != null) {
            internalRequest.addParameter("receiverBankCode", PrimitiveMarshallerUtils.marshalling((Object)request.getReceiverBankCode(), (String)"String"));
        }
        if (request.getBankAccountType() != null) {
            internalRequest.addParameter("bankAccountType", PrimitiveMarshallerUtils.marshalling((Object)request.getBankAccountType(), (String)"String"));
        }
        if (request.getBranchBankCode() != null) {
            internalRequest.addParameter("branchBankCode", PrimitiveMarshallerUtils.marshalling((Object)request.getBranchBankCode(), (String)"String"));
        }
        if (request.getComments() != null) {
            internalRequest.addParameter("comments", PrimitiveMarshallerUtils.marshalling((Object)request.getComments(), (String)"String"));
        }
        if (request.getTerminalType() != null) {
            internalRequest.addParameter("terminalType", PrimitiveMarshallerUtils.marshalling((Object)request.getTerminalType(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling((Object)request.getRemark(), (String)"String"));
        }
        if (request.getReceiptComments() != null) {
            internalRequest.addParameter("receiptComments", PrimitiveMarshallerUtils.marshalling((Object)request.getReceiptComments(), (String)"String"));
        }
        if (request.getRiskInfo() != null) {
            internalRequest.addParameter("riskInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getRiskInfo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static PayOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static PayOrderRequestMarshaller INSTANCE = new PayOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

