/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.RechargeAccountBookQueryRequest;
import java.util.Map;
import java.util.UUID;

public class RechargeAccountBookQueryRequestMarshaller
implements RequestMarshaller<RechargeAccountBookQueryRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/recharge/account-book/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<RechargeAccountBookQueryRequest> marshall(RechargeAccountBookQueryRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/recharge/account-book/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getYpAccountBookNo() != null) {
            internalRequest.addParameter("ypAccountBookNo", PrimitiveMarshallerUtils.marshalling((Object)request.getYpAccountBookNo(), (String)"String"));
        }
        if (request.getQueryStartDate() != null) {
            internalRequest.addParameter("queryStartDate", PrimitiveMarshallerUtils.marshalling((Object)request.getQueryStartDate(), (String)"String"));
        }
        if (request.getQueryEndDate() != null) {
            internalRequest.addParameter("queryEndDate", PrimitiveMarshallerUtils.marshalling((Object)request.getQueryEndDate(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPageNo(), (String)"Integer"));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", PrimitiveMarshallerUtils.marshalling((Object)request.getPageSize(), (String)"Integer"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static RechargeAccountBookQueryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static RechargeAccountBookQueryRequestMarshaller INSTANCE = new RechargeAccountBookQueryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

