/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.auth;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.auth.AuthClient;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthKycQueryRequest;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthKycQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthKycRequest;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthKycRequestMarshaller;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthRequest;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthRequestMarshaller;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthResultQueryRequest;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthResultQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.auth.request.MultipleAuthRequest;
import com.yeepay.yop.sdk.service.auth.request.MultipleAuthRequestMarshaller;
import com.yeepay.yop.sdk.service.auth.request.OcrIdcardRequest;
import com.yeepay.yop.sdk.service.auth.request.OcrIdcardRequestMarshaller;
import com.yeepay.yop.sdk.service.auth.response.FaceAuthKycQueryResponse;
import com.yeepay.yop.sdk.service.auth.response.FaceAuthKycResponse;
import com.yeepay.yop.sdk.service.auth.response.FaceAuthResponse;
import com.yeepay.yop.sdk.service.auth.response.FaceAuthResultQueryResponse;
import com.yeepay.yop.sdk.service.auth.response.MultipleAuthResponse;
import com.yeepay.yop.sdk.service.auth.response.OcrIdcardResponse;

public class AuthClientImpl
implements AuthClient {
    private final ClientHandler clientHandler;

    AuthClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public FaceAuthResponse faceAuth(FaceAuthRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        FaceAuthRequestMarshaller requestMarshaller = FaceAuthRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(FaceAuthResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (FaceAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public FaceAuthKycResponse faceAuthKyc(FaceAuthKycRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        FaceAuthKycRequestMarshaller requestMarshaller = FaceAuthKycRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(FaceAuthKycResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (FaceAuthKycResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public FaceAuthKycQueryResponse faceAuthKycQuery(FaceAuthKycQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getRequestNo() == null) {
            throw new YopClientException("request.requestNo is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        FaceAuthKycQueryRequestMarshaller requestMarshaller = FaceAuthKycQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(FaceAuthKycQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (FaceAuthKycQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public FaceAuthResultQueryResponse faceAuthResultQuery(FaceAuthResultQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getRequestNo() == null) {
            throw new YopClientException("request.requestNo is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        FaceAuthResultQueryRequestMarshaller requestMarshaller = FaceAuthResultQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(FaceAuthResultQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (FaceAuthResultQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public MultipleAuthResponse multipleAuth(MultipleAuthRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        MultipleAuthRequestMarshaller requestMarshaller = MultipleAuthRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(MultipleAuthResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (MultipleAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public OcrIdcardResponse ocrIdcard(OcrIdcardRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        OcrIdcardRequestMarshaller requestMarshaller = OcrIdcardRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(OcrIdcardResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (OcrIdcardResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

