/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.m_wallet.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.m_wallet.request.AccountQueryBalanceRequest;
import java.util.Map;
import java.util.UUID;

public class AccountQueryBalanceRequestMarshaller
implements RequestMarshaller<AccountQueryBalanceRequest> {
    private final String serviceName = "MWallet";
    private final String resourcePath = "/rest/v1.0/m-wallet/account/query-balance";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<AccountQueryBalanceRequest> marshall(AccountQueryBalanceRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "MWallet");
        internalRequest.setResourcePath("/rest/v1.0/m-wallet/account/query-balance");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerchantMemberNo() != null) {
            internalRequest.addParameter("merchantMemberNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantMemberNo(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getAccountType() != null) {
            internalRequest.addParameter("accountType", PrimitiveMarshallerUtils.marshalling((Object)request.getAccountType(), (String)"String"));
        }
        if (request.getElecAccount() != null) {
            internalRequest.addParameter("elecAccount", PrimitiveMarshallerUtils.marshalling((Object)request.getElecAccount(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static AccountQueryBalanceRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static AccountQueryBalanceRequestMarshaller INSTANCE = new AccountQueryBalanceRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

